+++
author = ["authors/michael-pecak.md"]
categories = "Interview"
date = "2018-02-28T20:42:00-05:00"
lastmod = "2018-02-28T22:13:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519870447037/sq---piotrbecza%2Be%CC%81aflubackerhighlights005.jpg.jpg"
primary_image_credit = "Piotr Beczała and Martin Katz in recital, Lyric Opera of Chicago, 2018. Photo: Kyle Flubacker."
publishDate = "2018-02-28T20:55:00-05:00"
related_articles = ["articles/searching-for-superlatives-locs-suberb-rigoletto.md","articles/a-dreamy-indulgence-the-pearl-fishers-in-chicago.md","articles/fleming-enchants-luscious-morsels-of-postopera-career.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/piotr-beczala.md"]
short_description = "&quot;I am pleased to say that, in my experience, audiences outside Poland respond to Polish music with great satisfaction and enthusiasm. I appeared one-and-a-half months ago in Zürich with this same program and the great majority of the audience seemed smitten with the Polish portion of the program.&quot;"
slug = "piotr-beczala"
title = "A &quot;rare event&quot; at Chicago Lyric: Piotr Beczała in recital"
+++

The components of the modern-day singing career, with all the associated commercial forces and media dictates, often conspire to produce an offspring that can only be described as paradoxical. A vocal recital — just one lone singer and a pianist performing ephemeral works of musical poetry — is the very definition of an intimate affair. To hold such an event in a 3,563-seat theater is a bit like trying to pillow-talk in…well, a 3,563-seat theater: there's some cognitive dissonance with the notion. Rare are the artists who, through a combination of personality and intensity of communication, transcend the space and reach an audience as if on an individual basis. Renowned tenor [Piotr Beczała](/scene/people/piotr-beczala/) and esteemed collaborative pianist [Martin Katz](/scene/people/martin-katz/) succeeded brilliantly in squaring this circle in their recital on the main stage of the Lyric Opera of Chicago this past Sunday.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519870335889/piotrbecza%2Be%CC%81aflubackerhighlights003.jpg.jpg)
<figcaption>Piotr Beczała and Martin Katz in recital, Lyric Opera of Chicago, 2018. Photo: Kyle Flubacker.</figcaption>
</figure>
 
I had the pleasure and privilege of speaking with the Polish-born singer a few days prior to his arrival in Chicago for the performance. Careers, paradoxes, collaboration, and patriotism were some of the topics we touched on and his conversation proved just as thoughtful and direct as his musicianship. As fellow Poles, we chatted in Polish. I provide English translations of his responses below.
 
Among other things, Chicago boasts one of the largest and most intense Polish communities of any city in the world. Poles are fiercely proud of their cultural heroes, whether historical or current, so when a native son or daughter comes to town, Polonia (as the city's Polish community is known) galvanizes in support of their own. And Polonia certainly showed up on Sunday for Mr. Beczała, filling the immense LOC auditorium nearly to capacity. Following his debut in 2009/10 as the title role in *Faust*, Mr. Beczała was most recently at LOC during the 2016/17 season as Edgardo in *Lucia di Lammermoor*. I ask him how he feels returning to Chicago, this time to sing a recital of art songs.

<div style="padding: 0 1em">

**Piotr Bezcała**: *I feel it's a rather rare event, even today, for an operatic singer to sing art songs on the main stage of an opera theater, which is why I'm all the more excited to present such a recital in Chicago. Not only is there a great operatic tradition at the Lyric Opera of Chicago, but for me as a Pole, so many of my compatriots live in this city. Hence, I chose a program of works that is, shall we say, close to the Polish heart.*

</div>
 
Mr. Beczała's and Mr. Katz's program that afternoon (which the duo repeats in Carnegie Hall on February 28) juxtaposed art songs by Italian and Polish composers from the turn of the 19th-century. The first half included sets by Stefano Donaudy, Ermanno Wolf-Ferrari, Ottorino Respighi, and Francesco Paolo Tosti. The second half consisted of little-known pieces by Karol Szymanowski, Mieczysław Karłowicz, and Stanisław Moniuszko.
 
Though these latter composers may be household names on Poland's music scene, they are not regularly represented on international stages. Beczała's repertoire encompasses an impressively wide range of roles and works from Mozart, Donizetti, and Verdi to Tchaikovsky, Lehar, Tauber, and now also Wagner. But each new project is pursued only after careful consideration and Polish repertoire figures prominently in his programming decisions.

<div style="padding: 0 1em">
 
**PB:** *Whether it's a mixed recital program of opera arias or, like in this case, an art song program, I always try to include selections from Polish operas or art songs by Polish composers like Karłowicz (who is my favorite), Moniuszko, or Szymanowski. The year 2018 marks the centennial anniversary of Polish independence, so there's an especially patriotic element to my programming these days. In my upcoming recitals, I plan to also include some songs by Paderewski, which I hope will be interesting, particularly for Western audiences.*

</div>

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519870372540/piotrbecza%2Be%CC%81aflubackerhighlights001.jpg.jpg)
<figcaption>Piotr Beczała and Martin Katz in recital, Lyric Opera of Chicago, 2018. Photo: Kyle Flubacker.</figcaption>
</figure>

It's not unfair to say that, for many people around the world, the category of "Polish music" begins and ends with the masterpieces of Fryderyk Chopin. This can be both a blessing and a curse for Polish composers as they are inevitably bisected into pre- and post-Chopin groups. Increasingly, major Polish artists, such as pianists Krystian Zimerman (for whom Lutosławski wrote his Piano Concerto and who has championed the music of Grażyna Bacewicz, Poland's most important female composer), Piotr Anderszewski (who tours regularly with Szymanowski's piano works), and singers such as Beczała, have passionately brought other Polish composers into a limelight of their own.

<div style="padding: 0 1em">

**PB:** *I am pleased to say that, in my experience, audiences outside Poland respond to Polish music with great satisfaction and enthusiasm. I appeared one-and-a-half months ago in Zürich with this same program and the great majority of the audience seemed smitten with the Polish portion of the program. And with Szymanowski especially, whose music is rather difficult on the receiving end as compared to other lighter fare. But this also isn't to say that this cycle (Op. 2) is very avant-garde; it's rooted still in late-romanticism, but it is nonetheless quite difficult. So I delighted by the audience's reception and that they seemed to like it.*

</div>

Szymanowski's 6 Songs, Op. 2, which opened the second half Sunday's recital, was without doubt the heaviest portion of the program. It is Szymanowski's earliest published set of art songs and, though not as dense as some of his later music, has all the hallmarks of his style: this singular blend of wafting impressionistic harmonies and exotic Scriabin-esque melodic turns all wrapped in a blanket of existential despondency that is inherently *sui generis*. The texts to these songs, by the transgressive modernist poet Kazimierz Przerwa-Tetmajer, are bleak. "The world remains distant," the first song in the set, captures the longing of a dejected lover with an outburst to a *ff* high-A. In "You have not died," the lover muses on the fact that his beloved's lips are cold, yet she is clearly alive. The cycle concludes with the song "Pilgrim," the rumination of a drifter accepting life as it comes. It takes a laser-like focus to convey the nuances of this language even to a room of native-speakers. For all the beauty he offered the rest of the afternoon, it was in these songs that Beczała put his full artistry on display. I sat breathless through each heart-wrenching word.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519870382174/piotrbecza%2Be%CC%81aflubackerhighlights011.jpg.jpg)
<figcaption>Piotr Beczała and Martin Katz in recital, Lyric Opera of Chicago, 2018. Photo: Kyle Flubacker.</figcaption>
</figure>
 
The Polish language is infamous for its grammatical and pronunciation challenges – this goes doubly for singing in the language. In his 1818 treatise *On the Meter and Rhythm of the Polish Language*, Józef Elsner (co-founder of Warsaw's National Opera, Conservatory, and famed teacher of the young Chopin himself) makes the bold statement that "Polish is second only to Italian as regards its suitability to music and song." Many musicians, then as now, would beg to differ.

<div style="padding: 0 1em">

**PB:** *Of course, I sing in Polish and in many other languages and even I must confess that Polish isn't the language that I associate right away with singing. Although the bulk of my repertoire is in Italian, French, and German, I nonetheless work to cultivate this Polish repertoire. And it must be said that even for a native Pole, the handling of the language when singing is a challenge. It's one thing to speak a language and another to sing it, but this applies to every language. I feel the Polish language is a bit demonized by the public, and even by my colleagues because it is so consonant-heavy. Of course, I admit readily that this isn't an easy language. But I don't think it's that much more difficult than, say, the Czech language, and yet Czech repertoire seems to me more popular and singers are more willing to sing Czech than Polish. I don't quite understand this, but it is a kind of a stereotype. I frequently encourage my friends and colleagues to learn Polish arias and songs, but I generally receive resistance because they feel intimidated by the language.*

</div>
 
The seven songs by Mieczysław Karłowicz were a refreshing follow-up to the demanding Szymanowski set. Here is a composer whose life was cut short at the tragically young age of 32,  whose song output numbers only 22 pieces, yet who managed to highlight the lyrical—indeed, Italianate qualities of the Polish language more successfully than many others. The texts evoke the trees, rivers, and fields of the Polish countryside. Beczała captured the whimsy and charm of these settings with superb shadings and inflections. As in the Italian repertoire of the first half, here Beczała made it known why he is one of the most sought-after artists on today's circuit. He is a tenor with a radiant top and a velvety middle register who employs his instrument with supreme intelligence and craft.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519870395724/piotrbecza%2Be%CC%81aflubackerhighlights009.jpg.jpg)
<figcaption>Piotr Beczała and Martin Katz in recital, Lyric Opera of Chicago, 2018. Photo: Kyle Flubacker.</figcaption>
</figure>
 
Complementing Beczała's artistry was Martin Katz at the piano, an indisputable master musician in his own right and Beczała's go-to collaborator in the U.S.
 
<div style="padding: 0 1em">
 
**PB:** *I always sing with Martin whenever I'm in America. We first met when he was playing for Marilyn Horne, with whom he regularly collaborated. We immediately understood each other and that it could be a rewarding partnership to perform together. As regards pianists, I find it difficult to even say that someone "accompanies" me. I believe very much in and find preferable the words "partner" and "partnership." After all, we create a performance together. It is a tremendous undertaking for a pianist to be a co-creator of a recital. Many things happen spontaneously. Of course, we rehearse the general shape of an interpretation, but there is always room for a certain freedom. And it's never exactly the same from performance to performance. With Martin, we try to approach each opportunity with freshness. It's a very fascinating subject, because every season during recitals I find I discover new elements to such partnerships with pianists.*

</div>
 
Watching — and hearing — Katz play is like witnessing a Zen-master tending his garden. His is an old-school and vanishing brand of pianism that eschews histrionics at the keyboard. There's a quiet mastery in the way he caresses the keys; he conjures up seemingly limitless colors directly from the soul of the Steinway grand. The Respighi songs were especially dazzling in his hands. Listening to the piano writing in these pieces, one was reminded of Respighi's talent for sonic special effects. Particularly in "Pioggia," Katz seemed to conjure a delicate trickling rain.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1519870354824/piotrbecza%2Be%CC%81aflubackerhighlights007.jpg.jpg)
<figcaption>Piotr Beczała and Martin Katz in recital, Lyric Opera of Chicago, 2018. Photo: Kyle Flubacker.</figcaption>
</figure>
 
Considering his distinguished career to-date, I was curious what reflections Mr. Beczała had on the life and art of an opera singer today as compared to when he first began his journey some thirty years ago.

<div style="padding: 0 1em">
 
**PB:** *I try not to think about careers as some separable category of life. I believe that every operatic production, every recital with which I'm occupied at a particular time is an all-consuming undertaking unto itself. Then, when one event ends, there's a kind of reset period followed by the next one. I don't necessarily map out my career as such. Of course, I have a planner and that's a vital element because one necessarily schedules far in advance – I'm now, for instance, in the process of planning my 2021/22 season. But those are merely logistics. The fact is that whatever I am engaged with at the present occupies me totally. It isn't that I strategize how to best divvy up my energies – that for this performance I'll conserve myself so that I'll have more to give for the following show. That to me is a very unprofessional and un-artistic approach. It seems to me that in an opera career, if we must use that term at all, everything boils down to persistence and hard work. One must not rest on one's laurels, but neither should one beat oneself up after less successful performances just because someone may not have liked what we offered. You have to believe in yourself, work diligently, and extract as much satisfaction from your endeavors for yourself and to know that they also bring satisfaction to an audience, whether it be via an opera production or recital performance.*

</div>
 
What advice does he have for today's young aspiring singers?

<div style="padding: 0 1em">

**PB:** *My main piece of advice to young singers is to be more patient than they might want to be or believe themselves to be. This career is one of a long game, it is a much longer-term undertaking than people may realize. I am now 25 years on the stage (this is my 26th season, not counting university) and I really see my life and work as a process. This is continuous work, continuous growth and learning from every single performance. I can't help but feel like many of today's young singers are rather impatient – and perhaps I was that way myself – that's the thing about youth. But, I think the people who go the farthest are those who don't think in terms of "career" as a kind of category, but rather devote themselves fully to whatever they are working on now in the present. Of course, it's necessary to have a plan as pertains the practicalities of life and work, but one must focus on whatever is before oneself presently with discipline and intent. I was recently in Krakow at the conservatory where I was invited to give masterclasses. I spent three wonderful days there working with some very talented young singers, many fine voices. And I made it a point to them that what they are embarking on isn't a sprint, but a more of a triathlon of sorts: it takes a long time and the conditions are always changing. It's silly for one to say that "when I finish university, I will give myself five years to debut at the Metropolitan Opera." That's a nonsensical approach. So, I always tell others that one needs to be patient, to constantly be expanding one's horizons, to always be learning, to always be observing, in order to forge a so-called career for oneself.*

</div>
 
>I am grateful to LOC's Director of Media Relations Magda Krance and Mr. Beczała's management for facilitating this interview as well as to Mr. Beczała himself for his time and insights.
