+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2017-01-30T15:35:00+00:00"
lastmod = "2017-01-31T09:44:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1485809175062/2017-01-31---Speed.jpg.jpg"
publishDate = "2017-01-31T09:44:00+00:00"
short_description = "It can be extremely humbling for a trained pianist to discover just how hard it is to stay with a conductor. It may seem unfair - shouldn&#039;t a conductor be a living, breathing version of a metronome, after all? In some cases, that&#039;s true; Philip Glass&#039; music works well when a tempo is set and maintained, but we guarantee you wouldn&#039;t want to hear your Puccini at an unwavering 108 clicks a minute."
slug = "pianists-wheres-the-fire"
title = "Pianists: where&#039;s the fire?"
+++

It can take a long time for a pianist to realize that their instrument is an anomaly. It's an odd duck, a minority of sorts even among the instruments found in a Western ensemble like a symphony orchestra. 

A piano is self-sufficient, and can hold its own as a solo instrument. In theory, a pianist could go through their entire training and professional career without sharing the stage with anyone else. It's in a small category of independent instruments, like the guitar and the accordion, that can play more than one or two notes at a time, and even accompany itself (Chopin Nocturnes, anyone?).

The piano also belongs to a minority of instruments that, instead of actively sustaining a pitch, makes sound based on the attack of the note. A violinist must work for every second of sound they create; a piano, like most percussion instruments and a lot of guitar styles, can really only control the way a note begins.

It's certainly fascinating that the piano - the rare instrument that is both self-symphonic and attack-based in its sound production - is one of the most ubiquitous elements of Western classical music. There are pianos in the rehearsal room for opera, music theatre, and ballet, and keyboard instruments are littered throughout symphony orchestras.

And thank goodness they are, because the unpopular truth is this: pianists, left on their own for too long, develop rhythmic skills which are, frankly, horrendous.

*What about all those metronomes that pianists use?*, you may ask. *Don't they learn rhythm the same way a cellist does?* 

Well, yes and no. There's staying "with" a metronome, and then there's making music. We heard a piano concerto performed the other day, and in nearly every measure, the pianist arrived at beats 2 and 3 early. It was enough to give us an eye twitch by the end of the first movement. 

It wasn't that the pianist wasn't watching the conductor. It's that they weren't listening. Rhythm isn't created in a vacuum; it comes with enormous context. When we're talking about an orchestra, that context includes the fact that there are a lot of people playing at once, and that most of those people are playing instruments that are slower to make sound than a piano.

It's part of why orchestras do that weird thing of playing "behind the beat", something that conductors have to take into account when they work with a new orchestra. It can seem like an arbitrary delay, but the lag between a conductor's downbeat and actually making sound comes from the mechanics of each instrument. Compared with the instant sound that a piano can offer, it takes time for a violist's bow hairs to catch the strings and make them vibrate, or for a clarinetist's reed to start vibrating with sound.

Rhythm can change. Practicing on one's own, with the help of a metronome, is handy; but it's when musicians play together that they become accountable for their rhythm. Pianists are likely to be early, in part because it's easy for them to make sound. Singers have a reputation for lagging behind the beat, in part because phonation takes longer. Like instrumentalists, singers learn to breathe faster, or get a head start on a large interval, so they don't end up late. Similarly, it's on pianists to really listen to the players around them, and to subdivide like mad, so they don't land early on a beat.

It can be extremely humbling for a trained pianist to discover just how hard it is to stay with a conductor. It may seem unfair - shouldn't a conductor be a living, breathing version of a metronome, after all? In some cases, that's true; Philip Glass' music works well when a tempo is set and maintained, but we guarantee you wouldn't want to hear your Puccini at an unwavering 108 clicks a minute.

That idea of Rhythm+™, the concept of maintaining a tempo while listening to the ebbs and flows within it, is hard to learn any other way except by trial and error. For a long time, playing the piano and singing have felt like extreme ends of the rhythmic spectrum. On the "piano" side, there's rhythm that runs consistently, unchanging; on the "singer" side, rhythm is about knowing which beats hold tension and which offer release. Music happens in a meeting of both sides; without rigidity, music can lose its direction, and without flexibility, music loses its soul.

Pianists, if you want to truly test your rhythmic chops, invite your string player friends (even better, your conductor friends) over for a little salon party. Don't forget the wine.
