+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2014-08-20T13:45:00-06:00"
lastmod = "2017-06-23T23:19:00-06:00"
preamble = "For any of those brave pianists who dive into operatic repertoire, there's an acute awareness of playing music that's specifically *not* written for the piano. While some singers revel in how beautifully Verdi or Mozart or Strauss wrote for the voice, the pianist is, at that same moment, experiencing how poorly that same music feels under our ten fingers. It's a simple problem, and that's that pianists in the opera world are largely stand-ins for the orchestra. \n\nWhen we play opera, it's for a rehearsal or an audition or some other situation in which we're trying to give someone the general picture of how the music goes, for lack of 80 orchestral players to hire at the time. The pianistic discomfort doesn't even come from the problem of playing from crudely reduced vocal scores, or the fact that we're trying to follow the incoherent flailings of a man with a baton. The music of certain composers has a specific tactile connotation, and it has to do with stuff like the choice of key or the use of specific instrumental idioms. I'll give you some examples:\n"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1498281422927/2017-06-23---Keyboard.jpg.jpg"
publishDate = "2014-08-20T13:45:00-06:00"
related_articles = ["articles/how-to-play-for-singers.md"]
short_description = "For any of those brave pianists who dive into operatic repertoire, there’s an acute awareness of playing music that’s specifically not written for the piano. While some singers revel in how beautifully Verdi or Mozart or Strauss wrote for the voice, the pianist is, at that same moment, experiencing how poorly that same music feels under our ten fingers. It’s a simple problem, and that’s that pianists in the opera world are largely stand-ins for the orchestra. "
slug = "pianists-plights-and-opera-fights"
title = "Pianists&#039; plights and opera fights"
+++

## Rossini

Rossini is fun, light, and can move like the wind. It can be almost laughably simple at times, if not utterly sight-readable. But out of nowhere, it can go from harmless "ta-da!" chords and cute little _oom-pahs_ to an endless sea of repeated notes that spell out hell on earth.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429223862747/Screen%20Shot%202015-04-16%20at%206.37.02%20PM.png)
</figure>

"Io sono docile"? More like io sono freaking out. Every time I play this aria I am _convinced_ I've gotten off to an alright start, putting the right finger down on that first E-natural. And then it all goes awry, and by the time I'm asked to repeat five F-sharps in some semblance of a rhythmic pattern, I've decided I can no longer play the piano. It's an added kick-when-the-pianist-is-down to hear that first orchestra rehearsal of the blasted Rossini opera, and to listen to the violins effortlessly play those inevitable repeated-note passages with a few gentle swishes of their bows. It always sounds great, and you finally learn why Rossini crescendos are so fun. But until that moment, you can count on the pianist sitting on the bench in quiet concentration, their thoughts split between trying to find that perfect fingering pattern that will fix their lives and vowing never to take another Rossini gig again.

## Verdi

Verdi is sneaky. You can take a glance at a page from a Verdi score and convince yourself it's sight-readable. Usually some left-handed _oom-pahs_, and a nice tune hanging out in your right hand. The thing is, Verdi is a good orchestrator, and there's plenty of quick changes between groups of instruments; at the piano, these changes mean we jump like schizophrenics between soft and loud, high and low registers. It's like playing whack-a-mole with the keys.
 
This bit looks fairly harmless, with plenty of easy chords to spot and no complicated rhythm stuff; but if you're not ready for Verdi's incredible dramatic writing, it's easy to get mowed over by his score that's moving faster than you are. And accuracy counts in Verdi; you can always "hear through" his music, and it's never an opaque wash of sound. This means you have to play the notes right, and while there are composers that make this a more difficult task, there are always little Verdi bits like this to ruin your day:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429223981823/Screen%20Shot%202015-04-16%20at%206.39.20%20PM.png)
</figure>

Every. Time. Grace notes, I tell you. Coming from above, below, then attached to trills, for Pete's sake. Maybe it's hard for the strings, too. But I tell you, Verdi's tricky; if you're playing Verdi and you're getting comfortable, you're not paying enough attention.

## Puccini

 There are two faces of the pianist who plays Puccini. There's the face of the pianist playing the aria from a Puccini show, joyously revelling in the lush harmonies and diatonic scales (albeit with a few too many flats, but give me flats over sharps any day) and having fun with the elastic rhythm and great bass notes. Then there's the face of the pianist playing the stuff _between_ arias in Puccini. It's randomly tricky. I present you the second page of _Tosca_:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429224426117/Screen%20Shot%202015-04-16%20at%206.46.37%20PM.png)
</figure>

Nasty stuff. Chromatic madness and a hidden bar of 3/4 to make sure you're awake. The trade-off is that in every Puccini opera, there's a "thing" about the transitional music; in _La bohème_, it's the tiny bits of "ba-dum-dum-DUM" interspersed throughout, or in _Madama Butterfly_ it's pentatonic Japan-music. And once you learn the "thing", it sort of applies to the whole piece. It's like owning a master key to the opera; if you've got it, it works. 

The downside is that after the pianist has gone to the trouble of mastering "ba-dum-dum-DUM" in every key, everyone is still a little bit just waiting for that music to get us to the next awesome aria; this means the tricky bits of Puccini are technically thankless, but at least those bits are always on their way to playable, loveable lines that will stick in your head _forever_.

## Strauss

With Richard Strauss, you get out of it what you put in. His orchestral writing is really contrapuntal, with plenty of solo lines from different instruments flowing around each other. It can be difficult for a pianist to decide on what to play, since Strauss is similar to Verdi in the way that you can hear all the inner parts that make up the larger whole. It means that pianists have to come to terms with the limits of their ten fingers, and admit that they really can't play all the notes. 

Even after you've overcome that rudimentary hurdle, Strauss can be fiercely difficult to play. Here's a little bit from a common audition excerpt for opera pianists, from the opening of *Der Rosenkavalier*:
 
<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429224622784/Screen%20Shot%202015-04-16%20at%206.49.50%20PM.png)
</figure>

Terrifying, but it's _so good_. This is what I mean by getting out of Strauss what you put in. If I take the time to learn it well (and it takes less time than you'd think), my fingers never forget it. It always surprises me, since Strauss' orchestration is intricate and his orchestras include a lot more players than Rossini's. But there's something extraordinarily ergonomic about even piano reductions of Strauss operas. 

Maybe wading through his scores demands more of a pianist's brain in the learning stages, but that's why it's more easily retained the next time you're faced with the Composer's Aria or the Presentation of the Rose. It doesn't really matter to me why; Strauss feels like a massage on my hands and arms, and it's _beautiful_ to boot.

## ...and finally, Mozart

 Mozart is like the _ur-_ version of all of the above composers. He writes beautifully for his singers as well as his instruments, meaning that just like in Rossini, the pianist has that problem of orchestral idioms in his vocal score. Mozart's music is an unstopping chameleon of dramatic highs and lows, trading comedy for tragedy and vice versa; like Verdi, if you've not got your wits about you, Mozart can start playing you rather than the other way around. Like Puccini, Mozart's got as many tricky transitions as stunningly beautiful arias, so a pianist's efforts for Antonio's entrance in _Figaro_ will soon be balanced out by stuff like "Contessa, perdono". 
 
But what keeps me from settling comfortably onto the piano bench when I'm about to play some Mozart is the precision of it all. Notes, phrase endings, even the rhythm that's in Mozart's trills; it's all so much harder than it ever sounds, especially once it's done right. Look at these two bits from _Die Zauberflöte_:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429224916732/Screen%20Shot%202015-04-16%20at%206.54.50%20PM.png)
</figure>

If you know the piece, you know this part is _so amazing_. And not overtly hard to play; but, pianists, I dare you all not to whack on the last note they play before the singers come in. Stuff like that is so freaking hard. So is this piece of visual horror for any audition pianist:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1429224995865/Screen%20Shot%202015-04-16%20at%206.56.06%20PM.png)
</figure>

I have a tenor friend who often starts auditions with this aria. I've practiced it too many times to admit, because it's still a crapshoot whether or not I make sure I get my thumb on the right key at the right time or not (C Major secretly sucks). But Mozart is also at the top of that list that I put Strauss in earlier: you get back what you put it, with interest, guaranteed every time.

>Pianists: what are your fingers' favourite operas to play? What pages give you nightmares? Let us know in the comments below!
