+++
author = ["authors/jenna.md"]
categories = "How-to"
date = "2015-09-25T13:27:00-04:00"
lastmod = "2015-09-26T10:36:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443277407280/PianoStage.jpg.jpg"
publishDate = "2015-09-26T10:34:00-04:00"
related_articles = ["articles/star-repetiteur-there-is-such-a-thing.md","articles/turning-pages-turning-heads.md","articles/4-tips-for-when-there-are-too-many-notes.md","articles/4-secrets-for-better-high-notes.md","articles/opera-orchestras-robots-or-out-of-the-loop.md","articles/the-opera-pianists-list-o-priorities.md","articles/how-to-empathize-with-singers.md","articles/tips-for-pianists-how-to-tremolo-like-a-pro.md"]
short_description = "Pianists, when you&#039;re playing orchestral reductions, it&#039;s all a complicated system of smoke and mirrors. Rather than on getting every note under your fingers, your priorities lay in creating a broader palate of sound, representing the different sections of a hypothetical orchestra. There&#039;s a difference in sound between a viola and an oboe, and a group of strings can have a different collective rhythm than a group of winds. "
slug = "pianists-3-tips-for-sounding-like-an-orchestra"
title = "Pianists: 3 tips for sounding like an orchestra"
+++

Pianists, when you're playing orchestral reductions, it's all a complicated system of smoke and mirrors. Rather than on getting every note under your fingers, your priorities lay in creating a broader palate of sound, representing the different sections of a hypothetical orchestra. There's a difference in sound between a viola and an oboe, and a group of strings can have a different collective rhythm than a group of winds. 

Pianists who play opera know the orchestration well, since their only job is imitating it; there's nothing more frustrating than knowing how a piece *should* sound, and being unable to truly mimic the sound. String tremolos are a good example: the piano simply can't *do that*, so it's an effect that's hard to recreate. 

And yet, there are ways. Pianists, as they were shared with me, I'd like to share with you three tips to maximize your palate of sound and sound like a real one-person band.

### 1. Strings vs woodwinds

It's a pretty ubiquitous thing, strings and woodwinds playing together. Lots of strings playing accompaniment to an oboe line, two flutes playing along with two violins, all the strings playing with all the winds, et cetera. A pianist's job is to show the difference in sound between the strings and winds; in terms of piano technique, this becomes a question of how you voice a chord.

When a string section plays together, the sound is fairly uniform, and because the mechanism of instruments are similar, so is their collective pulse. Compare that to a section of woodwinds, which includes three or more *different* instruments with more variance in sound timbre. This means that a chord played by the strings will have a homogenous sound, with no heirarchy of voicing among the section. To do this at the piano, the pianist can **take away all voicing**. It's anti-pianistic technique; voicing, or simply spotting the counterpoint, in piano music is key to keeping it interesting. With music written for a string section, "voicing" doesn't exist. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443275633924/Screen%20Shot%202015-09-26%20at%209.33.52%20AM.png)<figcaption>From *Le nozze di Figaro*: the slurred chords are strings, non-slurred are clarinet, bassoon and French horn.</figcaption>
</figure>

The more you can achieve this voice-less sound, the more significant your shift to the woodwinds will seem (like in the example above). When any combination of flutes, bassoons, French horns, etc., plays together, it feels like a group of soloists. There's a difference between playing chords *without* voicing, like for the strings, and playing chords with *equal* voicing. Equal voicing is what gets the clarity and confidence of each individual line of a woodwind ensemble. At the piano, it's about playing legato with the fingers, not the pedal, and imagining that **each voice is striving to stand out** as a soloist. This comes in handy in plenty of Mozart, all *bel canto*, and definitely in counterpoint-laden Strauss (Richard, to be sure).

### 2. String tremolos

Tremolos in string instruments are about sustaining a colour of sound. The go-to equivalent on the piano is playing the tremolo pitch as an octave, and quickly alternating between the bottom and top note, [honky-tonk piano style](https://www.youtube.com/watch?v=ngUMA_aKmak). If you're imitating a whole section strings, making up a tremolo chord, the same theory applies; break the chord up so that you can alternate between some of the notes and the rest of the notes by rocking your hand back and forth. Here's an example from *Madama Butterfly*:

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443274663693/Screen%20Shot%202015-09-26%20at%209.27.42%20AM.png)
</figure>

Starting at rehearsal 38, the strings play a triad of tremolo notes; whoever did the piano reduction made it easy to spot the trick I'm talking about, by breaking up the chord in a way that makes sense for a pianist's hand. The trick to really getting the right sound, though, is in ignoring this helpful shortcut. When the chord at 38 changes slightly, three bars later, what really happens is that all three parts shift at the same time. If a pianist plays as written, starting with the top two voices and then alternating with the lowest, that's akin to a bad orchestra, with someone in the string section being constantly out of sync with his neighbours. 

So, as the chord shifts, **shift all your fingers at the same time**; the other option sounds a bit more [saloon-piano-esque](https://www.youtube.com/watch?v=ngUMA_aKmak). Bonus tip: be very careful not to start a tremolo with the heavy bump that can come with placing a hand on a chord. The nature of strings and their bows means that a tremolo often starts with very little attack, as if the sound eases into existence. Pianists can achieve this by imagining that **each tremolo start with a quick crescendo out of silence**. This kind of this comes in handy when playing "Celeste Aïda" or "O du, mein holder Abendstern," or most of *Hänsel und Gretel*.

### 3. (Almost) Always add a lower octave

The piano just sounds more orchestral with extra oomph in the bass. Now, this isn't a blanket statement, and a pianist's use of octaves should be informed by what's in the orchestra score. But often there's more bass than meets the eye; for example, when the double basses play with the string section, they **sound an octave lower than written**. Extra octave in the bass. It doesn't mean you play louder, but the harmonies are easier to hear, and there are more overtones in the sound; it's one of the incremental differences that adds up to sounding like an orchestra.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1443276088280/Screen%20Shot%202015-09-26%20at%209.59.57%20AM.png)<figcaption>A section of Verdi's *Rigoletto* quartet, where some extra octaves would sound nice.</figcaption>
</figure>

I've found that singers often respond to the added support of more foundation in the accompaniment. The example from *Rigoletto* above shows the tenor working hard, and the orchestra gently supporting him. Those pizzicato chords aren't loud, to be sure, but there's somehow more sound in a softly pizz-ing section than in a dry, staccato piano chord. Instead of a singular note on beats 1 and 3, add that extra lower note. The singer will immediately feel better supported, and you'll be able to get that **reverb-like effect** that happens when double basses and celli pluck their strings.

>Readers, are you left with questions? Rebuttals? Tips of your own? Share them all in the comment section below!
