+++
author = ["authors/david-todd.md"]
categories = "How-To"
date = 2023-03-29T12:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "This article is one of a series called [\"The Elton John Act\"](/pianists-progress-i-the-elton-john-act/), which aim to demystify the process of becoming an operatic répétiteur and assist anyone wishing to audition as one in the German-speaking operatic system. Here we begin with the first of the usual audition excerpts, the Maid Scene from Richard Strauss' opera _Elektra_."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1679530380/media/2023/03/Pianistseries_pianogirl_by4gpq.jpg"
primary_image_credit = "You’ll need to channel everything you’ve got into the piano in this chilling yet colourful scene!"
related_articles = ["articles/pianist-s-progress-ii-trampolines-tongue-twisters-the-set-audition-excerptsexcerpts.md", "articles/pianist-s-progress-i-the-elton-john-act.md"]
related_companies = []
related_people = []
short_description = " Whatever the staging, the atmosphere the music creates is oppressive, nasty and yet sometimes tender, and without a feel for the context of the whole piece, you will always struggle to recreate the senseless violence of the maids in this opening scene."
slug = "the-elton-john-act-iii-violent-sadistic-utterly-engaging-the-maid-scene-from-elektra"
title = "The Elton John Act III: Violent, sadistic & utterly engaging - the Maid Scene from Elektra"
youtube_url = ""

+++
* Opera: _Elektra_
* Composer: Richard Strauss
* Length of scene to learn: Beginning of the opera to Figure 34
* Edition Used: Boosey and Hawkes (with German and English text)
* Recordings I listened to: Solti 1961 with Birgit Nilsson as Elektra, Karl Böhm 1965 with Inge Borkh, Gergiev with Jeanne-Michèle Charbonnet, Abbado 1989 with Eva Marton (DVD).

The Maid Scene from _Elektra_ was the first set excerpt I learnt for auditions as a repetiteur, and it is still my favourite. This scene opens the opera and is violent, immersive and utterly engaging. I now love coming back to it, and like all good pieces of music, I discover something new every time. Before we dive in, a general tip for all of these excerpts is to make some kind of version that you can easily carry around with you, or perhaps play from an iPad, if you feel comfortable doing so. The last thing you want when trekking to an audition is a bag weighed down with heavy opera reductions.

If you don't know _Elektra_, you must start by watching it, to get a sense of the totally dark, thrilling world that Richard Strauss creates. The opera, nothing to do with Marvel's more recent creation, was written in 1909, and is a one act tour-de-force that threatens to swallow you up if you let it. Whatever the staging, the atmosphere the music creates is oppressive, nasty and yet sometimes tender, and without a feel for the context of the whole piece, you will always struggle to recreate the senseless violence of the maids in this opening scene. I've heard versions of this excerpt on the piano that were utterly depressing, not because the repetiteur had channelled Strauss' cruel world, but because they had so completely missed the point, playing a sanitised version to absolute perfection and with every voice part sung as if they were reading the shipping forecast. If any excerpt needs drama, it's this one!

## Developing your process

Before you even look at the piano part, I would suggest working out who the characters are, as they switch around a lot, with each one singing short lines. You have five maids (Erste Magd, Zweite Magd etc) and then the Overseer (Die Aufseherin) who enters just before Figure 19. All of them work as servants in the palace where Elektra is being held, and all of them are equally sadistic, except the Fifth. When the Fifth expresses some humanity for Elektra just before Figure 17, ("Ich will vor ihr mich niederwerfen und die Füße ihr küssen"), the Overseer is so disgusted that she takes the Fifth Maid away to be flogged. Pretty dark stuff.

Your process after this can be entirely your own, but I did the following, which I would recommend. Having played only a little Strauss before, I found it very difficult, and I learnt the piano part very slowly, getting to the point where I was familiar enough with the harmony that I could play large chunks of the excerpt fluently without stopping. At this point I didn't think much about the orchestration, texture or technical details, and was pleased simply to have a version that I could play through.

After this, I began to learn the vocal lines, which I did by learning them in isolation, and then adding them to the rough accompaniment I had already mastered. I find this method has two big advantages; firstly, even though at first it is hard to see it, the harmony often helps to support the vocal lines, and sometimes, such as four bars before Figure 17, the vocal lines are doubled in the orchestra, which is a big help. Secondly, by studying the piano part and vocal lines in conjunction like this, the whole piece is developed in one go. This should help to avoid the outcome of seeming like you are merely a pianist who is singing along, or someone whose singing distracts from their pianistic technique.

> Strauss, like Puccini, was so colourful in his writing, that you can have fun finding many of his musical references yourself.

This process must be done very slowly. It is crucial that the rhythms of the vocal lines are absolutely accurate, that you understand every word, that the text is sung clearly with excellent German pronunciation, and all of the characters (particularly that kind Fifth Maid and the brutal Overseer) are dramatically clear. Take two or three pages a day at first, and then it will become easier. Once the vocal lines were secure, I went back to the piano part and made sure I knew exactly what all of the orchestral instruments were that I was playing.

## Delving into the score

This must be done by consulting the full score, which you can find on IMSLP.com, in order to delve into Strauss' dazzling tapestry of musical colour. Some honourable mentions should go to the biting brass just after Figure 1 as Elektra darts backwards, the razor-sharp strings at Figure 3 representing the cat, the barking bass dogs at Figure 16, and the brittle, mocking woodwind just before Figure 24, to name but a few. Strauss, like Puccini, was so colourful in his writing, that you can have fun finding these yourself.

At this stage I added in some orchestral lines that were not in my piano reduction, and here I sometimes remove some lines that I find distracting or too technically difficult, though actually, I found this edition very playable once I had learnt it. It is important to remember that the editions we play are only an interpretation of the full score written by someone else, which often contain mistakes or are very un pianistic to play. Therefore there is no shame in some minor adjustments or omissions, so that your hands can fit around the score better. Here I also listened to the recordings listed above to get a sense of the scene, though it is crucial not to base your whole learning process on these, because this excerpt is so complicated that even the best recordings, which have often been produced with a tight schedule, have rhythmical errors in them.

From this point on, it is a matter of gradually increasing the tempo until it is correct. Make sure that the tempo relationships are accurate, an example being two bars before Figure 1, where the half-note beat must equal the quarter-note beat of the opening bars. There are also some very subtle changes in tempo which must be clear (e.g. Piu Mosso, two before Figure 5, or the accelerando at Figure 8), and Strauss metronome marks can generally be trusted. By this point, I found that my singing was completely linked to my playing and that I knew the orchestra/piano part well enough that it didn't distract from my singing and the dramatic intent I was trying to show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679530416/media/2023/03/Pianistseries_girllistening_x5ulov.jpg){{% /md %}}

<figcaption>Try not to be too critical when listening back to yourself!</figcaption>  
</figure>

## Listening back to yourself

Even though it's excruciating, I recommend recording yourself and listening to yourself back on a regular basis, even if that's the only thing you do with the piece all day. When we sing and play together, it can be so all-consuming that we can struggle to self-evaluate, and sitting back and listening to a recording of ourselves can be invaluable. I found doing this made me realise where I was rushing, where my text wasn't clear, or where I was making rhythmic mistakes.

> Entering into the murky world of Elektra's dungeon is the perfect distraction from a panel of curious adjudicators.

Even though I had at first been intimidated by the complexity of the piece and a little overwhelmed by the seeming technical difficulty, I now in fact always begin my auditions with _Elektra_, as I find I can now relax in the overbearing dramatic nature of the whole thing. Entering into the murky world of Elektra's dungeon is the perfect distraction from a panel of curious adjudicators, and the raw emotion on display, coupled with the orchestral detail, means there is always an opportunity to show off a feeling for drama, musical colour and orchestral texture, which are crucial skills in a good repetiteur. I hope you learn to love this piece as much as I do and it brings success in your auditions in future. Viel Spaß!