+++
author = ["authors/david-todd.md"]
categories = "How-To"
date = 2023-03-29T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "This article is the second in a series that began with [\"The Elton John Act\"](/pianists-progress-i-the-elton-john-act/). These articles try and address the black hole of information out there to help and support early-career répétiteurs who are interested in working in the German-speaking opera world. Here we take a general look at the excerpts that are usually requested at audition."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1679529374/media/2023/03/Pianistseries_gymnast_eo45ip.jpg"
primary_image_credit = "The ideal répétiteur is like an Olympic-sized trampoline, supporting the other athletes in their work while remaining flexible."
related_articles = ["articles/pianist-s-progress-iii-violent-sadistic-utterly-engaging-the-maid-scene-from-elektra.md", "articles/pianist-s-progress-i-the-elton-john-act.md"]
related_companies = []
related_people = []
short_description = "Sometimes the full-fat beginning of Der Rosenkavalier is also requested. The key here is to pace the excitement in the right way, as on stage a lot of love is being made."
slug = "the-elton-john-act-ii-trampolines-tongue-twisters-the-set-audition-excerpts"
title = "The Elton John Act II: Trampolines & tongue-twisters - the set audition excerpts"
youtube_url = ""

+++
Having established that most auditions require the "Elton John Act", any sane person usually asks "why"? After all, we didn't get into opera because of our beautiful singing voices. I have wondered on more than one occasion whether répétiteur auditions are simply some kind of twisted fun for the panel, who enforce the suffering only because they all had to go through it themselves in their youth.

The answer usually given is that we need to be prepared for rehearsals where one of the singers may be away or ill. In theory when this happens, the répétiteur should be prepared to "sing in" the vocal lines of the singer who is indisposed. In my experience the conductor is actually the one who often likes to do this, leaving a slightly disgruntled répétiteur rueing the hours they spent preparing the vocal lines using a singing voice which their mother still says "sounds nice". It is of course also completely unrealistic that you will ever have to sing every vocal line while playing as you do in an audition, because if the singers are all sick, the management will most likely cancel the rehearsal completely, unless they are hinting to you that you need more practice. As a result, you may well think it pointless that répétiteurs are asked to perform this extravaganza of a one- man or woman show.

Well, not quite.

## Getting used to multi-tasking

Getting a répétiteur to sing and play at the same time is actually a very good way of finding out who is the best person to take on the general multi-tasking role that is the core of the job. As soon as a candidate starts playing and it's clear that their head is buried in the music, or they are staring at their fingers and generally not engaging with the drama of the piece they are meant to be bringing to life, they give themselves away. They reveal through their body language that their musical intentions are not really oriented outwards, but rather inwards, in a way that is not going to support anybody.

> The set repertoire that is usually chosen is full of drama, intrigue, power and passion. If the répétiteur can show this through their singing, then it is clear that they have the sense for drama that is only going to enrich an opera house.

If the ideal répétiteur is like an Olympic-sized trampoline, supporting the other athletes in their work while remaining flexible, this insular kind of pianist is more like a concrete block. Sure, it may support you quite well up to a point, but after a few minutes of jumping, things are going to get quite uncomfortable.  As I mentioned above, whether the person is a trampoline or concrete block unfortunately becomes pretty clear after the first few lines of music that they play.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679529759/media/2023/03/Pianistseries_pianoguy_lzy5uf.jpg){{% /md %}}

<figcaption>If you work on your own singing, maybe even your neighbours will thank you for it!</figcaption>  
</figure>

## Focus on your singing

From this initial springy foundation, everything else should follow. The set repertoire that is usually chosen is full of drama, intrigue, power and passion. If the répétiteur can show this through their singing, then it is clear that they have the sense for drama that is only going to enrich an opera house. In auditions it is clear that many people have focused on their piano playing, but far too few focus on their singing, and how they are conveying the drama of the passages they are trying to represent. Of course the playing is important and it must be of an excellent professional quality, but unless the singing is also packed with emotion and passion, you’re rarely going to win over a panel, especially if you are competing in a crowded field. 

Through your singing you are also showing how you will coach singers in future. While you definitely don’t have to demonstrate a trained operatic singing voice yourself, if your diction is sloppy, then it follows that you will probably let things slide when you are coaching the singers. If you are singing wrong notes, it gives the impression that you will not be able to hear a singer’s mistakes when you are working with them. 

My advice would be to practise away from the keyboard almost as much as you practise at the keyboard. Record yourself singing and listen to it back, no matter how painful that is for you. Check that your pronunciation is correct and understandable, and that the way you are singing shows that you understand every word and exactly what is going on in the scene. In short, demand of yourself everything that you would demand of a singer in a coaching.

## A variety of styles

The traditional audition repertoire in the German-speaking world provides you with plenty of drama and the chance to show a range of operatic styles and the main three operatic languages, though unfortunately Baroque and contemporary music are glaringly absent. The piano parts are very difficult, though after a few auditions you will get used to them, and after a few years they will become like old friends that you are happy to see and reminisce with about all those awkward, difficult and sometimes successful times you have been through together!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679529746/media/2023/03/Pianistseries_Rosenkavalier_czywvt.jpg){{% /md %}}

<figcaption>Sometimes the full-fat beginning of Der Rosenkavalier is requested as a set excerpt. Photo: Robert Workman.</figcaption></figure>

The absolute standard piece is the finale of the second act of Mozart's _Le nozze di Figaro_, a mammoth, sublime and exquisitely tricky piece of music that covers everything from a bumbling gardener to a deranged aristocrat. Then you are usually asked to bring a piece by Richard Strauss, either the opening scene of _Elektra_ or the Judenquintet from _Salome_. _Elektra_ gives you the chance to unleash your inner dark side, while in _Salome_ you can channel your argumentative nature. Both demand lush romantic orchestral playing alongside a solid feel for vocal lines that often go against what you are playing – like patting your head and rubbing your tummy at the same time while playing World Cup level football with your feet.

Sometimes the full-fat beginning of _Der Rosenkavalier_ is also requested. The key here is to pace the excitement in the right way, as on stage a lot of love is being made. For the French excerpt, it's usually the fiddly Smuggler’s Quintet from _Carmen_. Full of tongue-twisters which would tax Napoleon himself, it is essential that the various tempi in this excerpt stay steady. 

In the following articles I will focus on each of the audition excerpts I play for auditions (as I usually play _Elektra_ instead of _Salome_, that is not included here), giving tips and help where I can. We will then move on to the graveyard where sadly the dreams of many a répétiteur have gone to die – _prima vista_, or _Blattspiel_, better known in English as "the dreaded sight-reading".  I hope the articles are useful for your own preparation and that you can use them as a spring-board for your own preparation.