+++
author = ["authors/david-todd.md"]
categories = "How-To"
date = 2023-03-26T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = "What is a repetiteur, and how exactly do they help in the opera-making process? This article, the first of a series (originally published on David Todd's blog, [_Opera with a Hot Toddy_](https://www.david-todd.co.uk/?page_id=770)) delving into one of opera's lesser-known roles, will hopefully help to address the black hole of information and support available to répétiteurs starting out in the world of opera..."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1679528708/media/2023/03/Pianistseries_elton-john-446485_1920_v5pbpa.jpg"
primary_image_credit = ""
related_articles = ["articles/how-to-lead-your-pianist.md", "articles/how-to-play-for-singers.md"]
related_companies = []
related_people = []
short_description = "You won't be bashing out the chords of \"Bennie and The Jets\" while singing along to your heart's content. Your task will be to play some of the most difficult ensemble moments in the entire opera repertoire, singing every part and every ensemble."
slug = "the-elton-john-act"
title = "The Elton John Act"
youtube_url = ""

+++
'And now, the time is wearing thin,  
The murderer is still within,   
The cast could just not find a lead,   
“This is impossible”, they all agreed.

But there was one they’d all forgot,   
Who in plain sight as sure as not,   
Did do the deed, and planned before,   
That our poor bass would live no more.

Beware the one who’s always there,   
But often blends into the air,  
Who watches, waits, here caused a stir,   
The murderer was: the répétiteur!’

At an incredibly niche, geeky party in Glasgow a few years ago, made up of opera musicians who had to write poetry in order to be granted entry, I wrote a rhyming murder mystery set in an opera house. It was no _Phantom of the Opera_, but the final lines revealed who had been the murderer; someone who was able to hide in plain sight for the whole opera-making process.

This is because the role of a répétiteur is simultaneously one of the most important elements of the opera rehearsal process and one of the least known. As an old teacher of mine said, without the répétiteur (or "repetitor" as they're known in the German-speaking world), it would be basically impossible for normal rehearsals to happen, having a much greater impact than if a mere conductor or singer were absent. He also argued that it was one of the most stressful jobs in the whole theatre.

Répétiteurs work incredibly hard at all stages of the opera process (including practising before any rehearsals even start), they balance an incredible array of skills and talents, and yet are still somehow first in the firing line of a frustrated conductor. Add to that the fact that even the most ardent opera-lovers have no idea what the role is, most English-speaking people can neither spell nor pronounce it (to misquote Hermione, "it's rep-a-ti-TEUR, not rep-a-TIT-teur", unless you're speaking in German), and you might be forgiven for wondering why we do it at all.

> I recently saw a répétiteur described as a "rehearsal pianist" which frustrated me, because this is only a small part of what they actually do.

## The best opera role of them all

Despite all of this, there are few other roles that are so all-encompassing and therefore musically satisfying, and as a result a répétiteur's relationships with other people in the rehearsal room are incredibly important. The role is also a fantastic way to learn about singers and get a broad knowledge of a wide range of the opera repertoire. I recently saw a répétiteur described as a "rehearsal pianist" which frustrated me, because this is only a small part of what we actually do.

Yes, the répétiteur plays the part of the orchestra during the rehearsals, which itself is an incredibly difficult thing, but they are also more often than not at any one time singing in the parts of singers who are off sick, making notes to relate to other singers during the break, closely following the gesture of a conductor who may or may not be clear to read, and keeping track of the staging as it progresses. That's at least five things simultaneously for a start!

## The Tactical Coach

Of course prior to staging rehearsals even beginning, they will have probably been "coaching" the singers regularly too. I often try and relate this to sport in order to explain it better. If singing teachers are the fitness coaches, keeping a player healthy and ready physically for their next game, répétiteurs are the tactical coaches, suggesting where and when it will be best to shoot at which point in the game, where the defence will be most vulnerable, and how to refine how the player is already kicking to produce an even more accurate shot.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679528797/media/2023/03/PIanistseries_soccerfield_r9jhxm.jpg){{% /md %}}

<figcaption>Répétiteurs are the tactical coaches, suggesting amongst other things, where and when it will be best to shoot at which point in the game.</figcaption>  
</figure>

Singing teachers help the singers on a technical level to use their body in the best way to produce the most beautiful sound that they can. The répétiteur when coaching focuses on phrasing, tempo, intonation, clarity of text, diction, repertoire suggestions, language pronunciation, and simply ensuring that the rhythm and notes are all correct. In order to do this they cannot be robots; they have to have an empathy for singers, an understanding of what makes each individual singer tick, how to motivate them, and how far to push them. Of course, sometimes there is crossover for both areas; there are some répétiteurs who know a great deal about singing technique and can therefore help usefully, and many singing teachers who often help in all the musical areas mentioned above. However, the skills mentioned above mark the general parameters of the job.

> In order to know what the orchestra is like, you have to bury yourself in the orchestral score and immerse yourself in listening to different orchestras to get a sense of the sounds and weight that different instrumental sections make.

Often many beginner répétiteurs play as if they are still driving a sports car (even though sadly on a répétiteur's salary, this will be an imagined idea rather than as a result of lived experience), and they need to learn to react in a way that is more like an orchestra. In order to know what the orchestra is like, you have to bury yourself in the orchestral score and immerse yourself in listening to different orchestras to get a sense of the sounds and weight that different instrumental sections make. It is for these reasons that being a répétiteur is still seen as ideal training for those wanting to become conductors. If you can multi-task to this extent, have strong personal skills that motivate people effectively, and have learnt to understand orchestral sound by processing musical scores at this level, you are already halfway to being a good conductor.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1679528785/media/2023/03/Pianistseries_cruiseship_z7nhce.jpg){{% /md %}}

<figcaption>If the solo piano is a sports car, the orchestra is more like an ocean liner. They can both be top of the range vehicles but will need to be steered and handled differently.</figcaption></figure>

## Auditioning as a Répétiteur

In order to hire new répétiteurs, most auditions in the German-speaking opera world use the same audition repertoire and look for the same qualities and skills. Though at first I thought this was unimaginative, it is actually an advantage for the candidate, who usually only has to learn this set repertoire once and then can use it over and over again for different jobs. In this repertoire, you have to do what a colleague of mine calls the "Elton John Act". 

Thankfully that doesn't mean dressing as Donald Duck and picking out your flashiest coloured glasses before entering the rehearsal room, though I suppose it could be one way to stand out! No, instead it means means singing the vocal lines of an excerpt at the same time as playing the piano. Unfortunately however, you won't be bashing out the chords of "Bennie and The Jets" while singing along to your heart's content. Your task will be to play some of the most difficult ensemble moments in the entire opera repertoire, singing every part and every ensemble.  

> The joy comes in identifying where we can improve and working on that area, though we can only do this if we know what’s expected in the first place!

Having recently been "on the other side", as part of the panel for the first time in auditions, I want to write more about this process to help anyone interested in becoming a répétiteur. I do not pretend that I have all the answers, but I do feel I have something to offer, mainly because when preparing for auditions I've always been surprised at the lack of information out there for early-career répétiteurs, and I am keen to expand on what information there is. I would also hate these articles to be overwhelming or off-putting; the truth is that we are all on a journey to being better musicians and not everyone has all of these skills at the same level. The joy comes in identifying where we can improve and working on that area, though we can only do this if we know what is expected in the first place! 

If you are interested in becoming one of the unsung heroes (no pun intended) of opera or developing your skills for the next audition, stay tuned for the articles coming your way, which I hope will encourage you and help you to prepare yourself for the next stage of your musical journey.