+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-02-12T14:00:00-05:00"
lastmod = "2016-02-13T11:25:00-05:00"
preamble = "Baritone [Phillip Addis](/scene/people/phillip-addis/) and pianist [Emily Hamper](/scene/people/emily-hamper/) are preparing for the [Canadian Art Song Project](/scene/companies/canadian-art-song-project/)'s upcoming concert, [*The Pilgrim Soul*](http://www.canadianartsongproject.ca/concert-season/#feb19), **February 19th, 7:30pm at Enoch Turner Schoolhouse**. The husband-and-wife team are longtime collaborators, and for this concert they'll present a program of music by Canadians Chester Duncan, Larysa Kuzmenko, Imant Raminsh, plus works by Dominick Argento and Gustav Mahler.\n\nAddis and Hamper spoke with us about *The Pilgrim Soul*, about the themes in Canadian art song, and about their unique partnership."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1455305269116/pilgrimSquare.jpg.jpg"
publishDate = "2016-02-13T09:00:00-05:00"
related_articles = ["articles/aptly-named-the-living-spectacle.md","articles/in-review-ash-roses.md"]
related_companies = ["scene/companies/canadian-art-song-project.md"]
related_people = ["scene/people/phillip-addis.md","scene/people/emily-hamper.md"]
short_description = "Baritone Phillip Addis and pianist Emily Hamper are preparing for the Canadian Art Song Project&#039;s upcoming concert, The Pilgrim Soul, February 19th, 7:30pm at Enoch Turner Schoolhouse. The husband-and-wife team are longtime collaborators, and for this concert they&#039;ll present a program of music by Canadians Chester Duncan, Larysa Kuzmenko, Imant Raminsh, plus works by Dominick Argento and Gustav Mahler."
slug = "phillip-addis-emily-hamper-the-pilgrim-soul"
title = "Phillip Addis &amp; Emily Hamper: The Pilgrim Soul"
+++

## What can you tell us about the Canadian works on this concert? 

**Phillip Addis**: These works were selected by the Canadian Art Song Project for their thematic similarities, as they all touch upon a search for truth, beauty and a sense of place. Depending on the individual texts that are set, the songs range from a sort of folk-ish innocence to absolutely tormented frustration.  

**Emily Hamper**: The Canadian works are quite diverse. The [Chester] Duncan is musically uncomplicated, with a wistfulness that matches the Housman text. To me it embodies a classic, mid-20th century style of Euro-Canadian music. The [Larysa] Kuzmenko cycle is almost the opposite. The wonderfully quirky poetry by Poe is vividly set with crunchy chromatic harmonies and full dynamic range. (This cycle is the most literal depiction of a traditional pilgrimage on the programme.)

[Imant] Raminsh shows his gentle harmonic language and playful, descriptive rhythms in his settings of the Yeats poems, [*The Pilgrim Soul*]. Clear echoes of English folk song style are combined with some unexpected twists. These love poems bring a comforting conclusion to the evening with a sense of connection with the goal (the beloved, in this case).

## Are there qualities in Canadian art song that sets it apart from American or British song?

**Emily**: Answering this question is tricky without getting into a discussion of Nationalism and defining what it "means" to be Canadian or anything else. I would say that what is unique about Canadian art song is the same as what is unique about Canadian music in general. Based on nothing but my own gut feeling, I sense a search for self-definition or exploration of identity in much of the Canadian music I encounter. With British or American music, I am often confronted by a very strong message of national identity from the composer (and librettist, when applicable), but this may have more to do with my perceptions of British and American music than anything else. 

**Phillip**: I would agree completely with Emily's sentiment regarding the diversity represented in the art form, and the deliberately open-ended definitions of what our music is. If I were to choose one common thread, it would have to be the language and sounds of the natural world. They don't tend to exist in a romantically pastoral relationship to the people, so much as in an expansive presence just beyond our conscious thought. There are many exceptions, of course, but the vastness of the country still looms in many of our composers' works.  Canadian artists are inevitably influenced by American and British culture, including the art song tradition, but I find there is less of an effort to be Canadian in the way that those nations sought to define their sounds.

**Emily**: During my adult performing years I have encountered such a diversity of styles in contemporary Canadian music that I am hard pressed to find any common theme. (A further distinction could also be made between the contemporary musical language of English and French Canada.) The "sound" I identified in my youth seems far less prevalent now. What links it together for me is its diversity. Everything from intensely challenging, highly cerebral stuff to minimalism to film score-type soundscape seems to be the norm now. I would even suggest that there are as many Canadian musical styles as there are Canadian composers, and that this is not a bad thing.

## How often do you two perform together? Is there anything unique about your process that you don’t find when you collaborate with others?

**Emily**: It varies. In recent years, at least two to three times per season in recital or some sort of concert. When I perform with other singers, the preparation often has to happen within days (or hours). This requires a heightened connection as performers, including instant reactions and some on-the-spot decision making, but I find that is not difficult to achieve. Naturally, the longer one has known and worked with someone, the easier the musical connection. As well as living together, Phillip and I have the distinct advantage of having known each other and worked together for many years. 

**Phillip**: As Emily mentioned, we usually have a few programs to put together in a given season.  We wish it could be more, but the opportunities for recitals are very few.  I don't really perform with anyone else, in recital, so I can only really compare it to, say, concert work with orchestras or chamber groups.  The main difference, besides the group dynamics and instrumentation, obviously, is in knowing each other's personality and musicianship in a way that doesn't require an explanation between us. Partly as a result of this, but also simply because of our life together, the amount of time we then have to experiment with ideas, and to let them mature, is a luxury that can't really be replicated outside of such a relationship.

**Emily**: Living together means we can share every step of the preparation process, starting with learning (or re-learning) the music together. We can push the boundaries, take time to try crazy things. This often results in greater freedom while performing, since we have already tried just about every possibility in rehearsal. Sharing frustrations and understanding the demons which plague each of us as performers is a challenge, but makes a satisfying performance all the more rewarding. One great thing about sharing a household is being able to chat randomly about the program when one of us gets an idea, or look something up, while we are going about our usual routines at home. This does result in a feeling of never being "off", but it gives a feeling of constant involvement with the project.

## How do you think these concert events fit into the larger mission of CASP?

**Emily**: Live performance is the best way to foster engagement with Canadian song repertoire for both audiences and performers. Many people may not be aware of how accessible the repertoire is, or the diversity within the genre and the sheer volume of works. Just getting these works performed and on a performance catalogue is a huge achievement. Commissions and recordings resulting from the performances will assist in the mission as well. 

**Phillip**: Hopefully we can help pique the audience's curiosity in how Canadian culture can be represented through song. There is, in fact, a wealth of material that has been written over the decades that simply needs performances like these to give the works life, so that people can hear the varied voices of our composers.

## Do you have a favourite piece on this program?

**Emily**: Of the Canadian works, the Kuzmenko (*In Search of Eldorado*) speaks the loudest to me overall. There’s a directness to her musical language which gives immediate meaning to the speaker’s words, and the text setting is cleverly done. The traveler's hopes and eventual disappointment are made clear without imposing sentiment or judgement. 

I think the third Raminsh setting, *When You Are Old*, is also pretty special. It’s the #1 hit in my brain right now.

The Mahler was a personal favourite in my teen years, and I listened to it over and over. The poetic journey captivated me, as did the orchestration, though I was unaware of the depth of tragedy at the time. (I had yet to learn the significance of the Linden tree in German romantic poetry).

**Phillip**: The more I work on *Eldorado*, by Larysa Kuzmencko, the more I enjoy the journey.  She sets Poe's excellent texts in such a visceral way, leading us to a kind of inevitable clash of anguish and transcendence. *The Andrée Expedition*, by Argento, is probably the biggest challenge on the programme, and arguably the most profound.  It's factual account of the doomed journey stands at odds with the delusions and despair that permeate the cycle.  The satisfaction of navigating this many-layered piece is its own reward.

**Emily**: My other favourite is the Argento. I love the frank and personal account of theadventure. The text is taken from the diaries and letters kept by the explorers. Though not explicitly poetry, it uses a lot metaphor and is emotionally powerful. The excitement, blind faith, humour, madness, and tragedy of the expedition are concisely related. Pianistically it is very gratifying. Argento uses the instrument to its fullest capacity in illustrating every aspect of the tale.

>For details and ticket information about The Pilgrim Soul, follow our box office links below.
