+++
author = ["authors/loren-lester.md"]
categories = "Review"
date = "2017-11-11T14:33:00-05:00"
lastmod = "2017-11-12T21:59:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510428422772/2017-11-11---square---persona_04pr.jpg.jpg"
primary_image_credit = "Amanda Crider as Alma and Lacey Dorn as Elisabet in a scene from LA Opera's 2017 production of Persona. Photo: Larry Ho/LA Opera."
publishDate = "2017-11-12T10:26:00-05:00"
related_articles = ["articles/belle-bete-la-opera-beauty.md","articles/a-dreamy-psychological-thriller-vanessa-at-oper-frankfurt.md","articles/the-medium-opera-as-film-noir.md"]
related_companies = ["scene/companies/los-angeles-opera.md"]
related_people = ["scene/people/amanda-crider.md"]
short_description = "It&#039;s Alma, played by mezzo-soprano Crider who must carry the show on her musical shoulders and she delivers a stunning performance, both as singer and as actress. Crider doesn&#039;t miss a beat capturing the emotional complexity of Alma&#039;s character while traversing the complexity of Keeril Makan&#039;s score."
slug = "persona-and-the-sounds-of-silence"
title = "Persona and the Sounds of Silence"
+++

An opera about two women - one of whom doesn't sing - is a daring idea. The 1966 Ingmar Bergman film [*Persona*](https://www.laopera.org/season/1718-Season/persona/) (on which the opera is based) stars two women, one of whom doesn't speak. In the opera by composer Keeril Makan and librettist Jay Scheib, one of the lead characters is also silent, and the show becomes a musical monologue for the other. In the current [LA Opera Off Grand production](https://www.laopera.org/season/1718-Season/persona/) you have the push and pull of something that is at once a rather faithful adaptation and, at the same time, a work that is entirely original. The results are splendid.

Though the film is in Swedish and the opera is in English, both works share the same plot: Elisabet, a seemingly healthy actress, stops talking and is put into the care of Alma, a dedicated nurse. Alma continually pierces the silence by telling Elisabet all about herself. The result is that Alma learns more about herself than perhaps she wants to know, and she winds up "pouring" her personality into Alma (who is revealed to be an empty vessel.) The two become one - or do they? More words have been written about Bergman's movie than any of his other sixty or so films, because the work is so layered and contradictory. In Bergman's film, actresses Bibi Andersson and Liv Ullmann share enough Swedish DNA to look like sisters. One of the most memorable images from the film is when their faces merge. In the opera, [Amanda Crider](/scene/people/amanda-crider/) (as Alma) and [Lacey Dorn](http://www.imdb.com/name/nm5001897/) (as Elisabet) look nothing alike - one is brunette and one blond for example. This proves to be no obstacle to the plot as it plays out. Director (and as noted, lyricist) Jay Scheib gets enormous credit for putting talent before type. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510428533825/2017-11-11---persona_01pr.jpg.jpg)
<figcaption>Evan Ziporyn conducts a scene from LA Opera's 2017 production of *Persona*, with Joshua Jeremiah as the Man and Peabody Southwell as the Doctor, and Lacey Dorn (visible onscreen) as Elisabet. Photo: Larry Ho/LA Opera.</figcaption>
</figure>

Scheib never lets us forget that the story was once a film. Several cameras and numerous monitors capture the live opera performances, many in close-ups that we usually never get to see except in the smallest of theaters. Influenced not only by Bergman but by early television, the composition of Scheib's shots remind us of the live plays that filled the airwaves in the 1950's. The cameras - one of which is on a large boom - often obscure the action on the stage but we never miss anything, thanks to the TV screens. This is especially important for our understanding of the character of Elisabet (a powerful and subtle "silent film" performance by Dorn.) Fine support comes from Peabody Southwell and Joshua Jeremiah in small but essential roles.

But it's Alma, played by mezzo-soprano Crider who must carry the show on her musical shoulders and she delivers a stunning performance, both as singer and as actress. Crider doesn't miss a beat capturing the emotional complexity of Alma's character while traversing the complexity of Keeril Makan's score. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510428550252/2017-11-11---persona_32pr.jpg.jpg)
<figcaption>Lacey Dorn as Elisabet, with Amanda Crider as Alma in a scene from LA Opera's 2017 production of *Persona*. Photo: Larry Ho/LA Opera.</figcaption>
</figure>

Makan has written a minimalist work where much of the dialogue in the libretto stays on one note or moves sparingly; this is merely a set-up for the orchestral and vocal explosions that surprise us at the most important dramatic turning points. Alma's phrase "I'm changing," for example, wildly breaks free from the recitative just as Alma is breaking free from herself. And at the moment when Alma is in a violent rage, the notes dance in the stratosphere of the soprano's upper range. (We do need the supplied subtitles at this point, but for the majority of the show the words are very clear and unencumbered by vocal compromises that can help singers hit notes but can confuse the audience.) There are no melodies to be found anywhere but there are some lovely passages, particularly when Alma sings to a sleeping Elisabet.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510428574578/2017-11-11---persona_10pr.jpg.jpg)
<figcaption>Amanda Crider as Alma and Lacey Dorn as Elisabet in a scene from LA Opera's 2017 production of *Persona*. Photo: Larry Ho/LA Opera.</figcaption>
</figure>

The "score" of Bergman's film by Lars Johan Werle is nothing more than some dissonant blasts of flutes and xylophone, but Makan was clearly influenced. Werle may have set the tone, but Makan runs with it, opening things up with an eight-piece ensemble under the direction of Evan Ziporyn. While Crider sings the words, Ziporyn's group - especially not one, but two percussionists - offer all the punctuation. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510428584145/2017-11-11---persona_14pr.jpg.jpg)
<figcaption>Amanda Crider as Alma and Lacey Dorn as Elisabet in a scene from LA Opera's 2017 production of *Persona*. Photo: Larry Ho/LA Opera.</figcaption>
</figure>

The expert work of lighting and video designer Joshua Higgason and his team of live video editors and camera operators were essential for Scheib's vision. Camera operators Paulina Jurzec and Kim Madalinski move the cameras constantly in and around all the stage blocking. They are given a well-deserved bow in the curtain call. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510428604595/2017-11-11---persona_17pr.jpg.jpg)
<figcaption>Lacey Dorn as Elisabet and Amanda Crider as Alma in a scene from LA Opera's 2017 production of *Persona*. Photo: Larry Ho/LA Opera.</figcaption>
</figure>

This was the LA Opera debut for all of the creatives associated with this production except for producer Beth Morrison. At the talkback, Beth Morrison promised more projects and if this is any example, we eagerly await their arrival. No doubt that there is a bright future for LA Opera Off Grand and the Contemporary Opera Initiative which is dedicated to "the cultivation of new voices and new visions" - or, in this case, great voices and great visions. 
