+++
author = ["authors/daniel-weisman.md"]
categories = "Review"
date = "2018-04-09T12:55:00-04:00"
lastmod = "2018-04-10T12:33:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523297302011/sq---JB4A7198.jpg.jpg"
primary_image_credit = "Out of Darkness: Two Remain, the Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera."
publishDate = "2018-04-09T14:18:00-04:00"
related_articles = ["articles/heggies-holocaust-operas-see-canadian-premiere.md","articles/meet-the-friends-their-seven-deadly-sins.md"]
related_companies = ["scene/companies/the-atlanta-opera.md"]
related_people = ["scene/people/elise-quagliata.md"]
short_description = "The second act follows the story of Gad Beck, performed by actor Tom Key. Gad, an older man, is preparing for bed when the ghost of his lover, Manfred Lewin, appears to remind Gad of the horrors, though Gad, who has held on to Manfred&#039;s book of poetry and his picture, had spent years just trying to forget it."
slug = "perfect-for-its-time-heggie-double-bill-in-atlanta"
title = "Out of Darkness: Two Remain is perfect for its time"
+++

Jake Heggie has done it again. He took my heart and soul, reeled me in like a hungry fish on the line with promises of an emotional connection and beautiful music and then he stomped my heart into the ground and spit on it for good measure and, the entire time, I let him, thanked him for it, and would gladly do it again.

Following the spectacular success of his 2000 opera, *Dead Man Walking*, Jake Heggie has steadily grown to heights as one of the great composers of American opera, standing tall next to the likes of Samuel Barber, Douglas Moore, Tom Cipullo, and Carlisle Floyd. Heggie's other operatic works include a setting of the famous *Moby-Dick* and, my personal favorite, *Three Decembers*. His repertoire of opera and song have become staples of voice recitals and opera companies worldwide which is why [*Out of Darkness: Two Remain*](https://www.atlantaopera.org/performance/darkness-two-remain/) had such strong expectations leading into it which, I am happy to say, it completely exceeded.

*Out of Darkness: Two Remain* is the operatic creation molded by Jake Heggie and librettist Gene Scheer, who also collaborated with Heggie on *Moby-Dick* and *Three Decembers*, at the interest of Music of Remembrance in Seattle and their artistic director, Mina Miller after a collaboration back in 2012. The piece has undergone a bit of a rework with almost a full rewrite of act one since its workshop premiere. This was the professional world premiere of this version of the opera. The two-act opera could be excerpted as two seperate one-acts, at least at first. Taken out of context the stories are similar, both following an oppressed minority during the height of the Nazi regime, but their stories weren't that of the atypical action-movie hero that one would expect from Hollywood, they are the true life stories of actual survivors: Krystyna Zywulska and Gad Beck.

The set itself (designed by Christopher S. Dills) was effective, transforming the black box stage into a platform surrounded by walls of scrim and empty picture frames, the floor littered with a yet-unidentifiable substance. Behind the scrim of the backdrop hid the small but musically mighty six piece orchestra, expertly led by conductor Joseph Mechavich, whose clear conducting and expert control only added to the success. I cannot go on without stopping to mentioned Heggie's use of Jewish melody into the orchestra throughout, helping set the scene and transport the audience back in time.

The first act follows an aged Krystyna Zywulska, as she struggles to record material for an upcoming biography chronicling her time as a political prisoner in Auschwitz-Birkenau. In truth, Krystyna Zywulska is Sonia Landau, a Jew who has hidden her name and her heritage. The grown Krystyna seems flighty, almost carefree as she attempts to recount her story without frustrating herself. Zywulska wants to be seen as more than a survivor-- a hero, her guilt over surviving seems to take her back as she's haunted by a seemingly nameless ghost that she cannot ignore.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523297451517/JB4A7014.jpg.jpg)
<figcaption>*Out of Darkness: Two Remain*, the Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

Zywulska reminisces back to her time in Auschwitz, where she was known as Krysia. She remembers her friends, among them Zosia and Edka, as they struggled to survive. Krysia begins to write lyrics and songs to help keep the morale of her cohort raised. She remembers a melody, sung constantly throughout the act by a ghostly figure. Edka is caught with a piece of paper containing some of Krysia's lyric but manages to escape death while Zosia and Krysia rush to burn the remainder of the pages.

The nameless, ghostly figure that continued to haunt the adult Krystyna joins her flashbacks, revealing herself to be a childhood friend named Mariola. Krysia rises through the ranks of the prisoners Mariola is bussed into the camp, recognizing Krysia as Sonia Landau, the Jew from Łódź who had grown up beside the Landaus. Krysia is forced to call Mariola a liar in order to save herself, condemning Mariola to death. Later, as Krystyna mentally comforts her younger self while saying "Brava, Krysia, brava" to remind her that, as hard as things are, she has survived, snow begins to pour from the sky, a thing that was, earlier in the opera, seen as a blessing is now shown to be a terror as Krysia explains that it is not snow but, in fact, ash which joined the piling of substance at the floor of the stage. It is Mariola.

Scheer and Heggie make a point to show that this point in the opera is the death of Sonia Landau, though Krystyna Zywulska lives on. In essence, the death of her childhood and the remainder of her innocence. Krystyna is shown as the sole survivor from her bus, having to sit and watch as her friends and family withered away, turning picture frames into tombstones for each of her friends as the wordless melody of Mariola weaves throughout the act.

Director Tomer Zvulun's premise for this piece kept Krystyna (the elder) in somewhat of a safety bubble, disconnected from the memories as they played out in front of her, breaking the barriers of truth to bring her into the fray and force her to connect with her past and confront it. The beginning of the act shows Mariola singing her melody as she enters the stage. While a small role, soprano Jasmine Habersham is devastating as Mariola. Zvulun puts her on the stage throughout the majority of the opera when all she has to do is sing her wordless melody. Habersham's sweet voice was hauntingly lyrical and provided a sumptuousness needed to make the audience feel for her single scene as a living character. 

Maria Kanyova plays the present Krystyna Zywulska, playing the role with a whimsy that seemed to brush off the pains of her past until her character breaks. Kanyova's soprano was effortless and controlled, mixing perfectly with Second Year Atlanta Opera Studio Artist Bryn Holdsworth, who played the younger Krysia with the warmth and depth I have expected from Ms. Holdsworth since seeing her in *Seven Deadly Sins* last year. Ms. Holdsworth's performance, alongside Ms. Kanyova’s, was a double-whammy of total devastation as we learned to suffer alongside them. Mezzo-soprano [Elisa Quagliata](/scene/people/elise-quagliata/) sang a warm and thick Zosia. Her voice boomed in the house, making me wish that we could have heard more of her. Rounding out the cast as Edka was Atlanta Opera Studio Artist Gina Perregrino whose mezzo-soprano held strong among the larger roles; her dramatic integrity helped bring a sincerity to Krysia's naivety.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523297588355/JB4A6348.jpg.jpg)
<figcaption>*Out of Darkness: Two Remain*, the Atlanta Opera, 2018. Photo courtesy of The Atlanta Opera.</figcaption>
</figure>

The second act follows the story of Gad Beck, performed by actor Tom Key. Gad, an older man, is preparing for bed when the ghost of his lover, Manfred Lewin, appears to remind Gad of the horrors, though Gad, who has held on to Manfred's book of poetry and his picture, had spent years just trying to forget it.

It is almost like *A Christmas Carol* in the way that Manfred appears to Gad. Gad tries to deny him but Manfred reminds him of their love, the fun that they had at the clubs back in Berlin before the world turned upside down. Manfred and Gad’s love affair at nineteen is shown as strict taboo. Gad muses that, even after the war, homosexuality was forbidden even until 1969 and that, after the war, no one was willing to listen to the struggles of those who made it out. Manfred leads Gad into a journey of understanding, telling him what happened to them in the camps, how he died, how his friends were brutalized. Gad reminds Manfred that he had tried to get him back-- having borrowed a Hitler Youth uniform and infiltrating the camp with reason to get Manfred back and that it was Manfred who refused to leave, stating that if he did leave and left his family to die in the camps, that he would never be free. Manfred sings the lyricless tune that Mariola sang in the first act. Gad begs the ghost of his lover for one final dance.

Mr. Key's performance, though riddled with a few wasted gestures for my taste, was deep and painful in the best of ways. His journey with the ghost of Manfred is heart wrenchingly beautiful to the point where I'm pretty sure I heard audible tears in the audience. As Manfred, baritone Ben Edquist is a young singer to watch. His smooth velvety baritone and shimmering, floated top were instrumental in making the show as strong as possible. His aria "One by one" was one of the most dramatically intense pieces that I've ever been privileged enough to see live.

Both acts also featured four dancers, representing prisoners, Nazi soldiers, citizens, and even the youthful presentation of Gad and Manfred in act two. The show would not have worked without the presentations done by Miriam Golomb, Nicole Johnson, Brandon Nguyen, and Joshua Rackliffe as choreographed by John McFall.

As the lights rose post Manfred and Gad's ending, we find Gad reprising one of the songs from earlier in the piece, joined by Manfred, Krystyna, Krysia, Zosia, Edka, Mariola, and the four dancers who all sang the final chorus together.

I didn't completely find this brief epilogue necessary. While it was still very moving, I felt that Heggie put it into the piece in an attempt to help tie the two acts together while I felt that having Manfred reprise Mariola's melody was enough.

This piece is perfect for its time - it is completely relevant to the world that we live in today and applies to many things. Heggie, Zvulun, and Scheer make a perfect combo with an all star cast and crew and present a work prudent for today. If you enjoy the music definitely consider stopping by next season to see Atlanta Opera present Heggie's *Dead Man Walking* in February.

>[*Out of Darkness: Two Remain*](https://www.atlantaopera.org/performance/darkness-two-remain/) runs through April 15. For details and tickets, [click here](https://www.atlantaopera.org/performance/darkness-two-remain/).
