+++
author = ["authors/melissa-ratcliff.md"]
categories = "Review"
date = 2022-10-27T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Vancouver Opera's [production of The Pearl Fishers](https://www.vancouveropera.ca/whats-on/pearl-fishers/) runs through October 30, 2022."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1666911626/media/2022/10/sqVO_-_Pearl_Fishers_-_Dancers_-_photo_by_Emily_Cooper_Photography_iankh4.jpg"
primary_image_credit = "A Kandyan dancer in Vancouver Opera's production of The Pearl Fishers, 2022. Photo: Emily Cooper Photography."
related_articles = ["articles/division.md", "articles/forgiving-racism-onstage.md"]
related_companies = ["scene/companies/vancouver-opera.md"]
related_people = ["scene/people/aaron-blake.md", "scene/people/vartan-gabrielian.md", "scene/people/phillip-addis.md", "scene/people/miriam-khalil.md"]
short_description = "The projections describe how the librettists and composer themselves had never visited \"Ceylon\" (currently Sri Lanka) nor knew about the culture, and were writing from a place of ignorance. Then the curtain rises on the chorus, sets, costumes, and the opening in the tropical setting full of palm trees."
slug = "a-confused-concept-pearl-fishers-in-vancouver"
title = "A confused concept: Pearl Fishers in Vancouver"
youtube_url = ""

+++
[Vancouver Opera](/scene/companies/vancouver-opera/) opened its first full season since the pandemic began with a production of Bizet's _Pearl Fishers_. In this version, VO started the opera with…. Bizet. The composer, played by Jason Cook, appears on stage in 1860s garb to begin the opera. He is joined by the principals, themselves decked in 1860s costume as Bizet hands out the scores to each and then they begin reviewing. During this, the projections describe how the librettists and composer themselves had never visited "Ceylon" (currently Sri Lanka) nor knew about the culture, and were writing from a place of ignorance. Then the curtain rises on the chorus, sets, costumes, and the opening in the tropical setting full of palm trees. The principals, still in Victorian dress, mix amongst the chorus, until vanishing into the wings, appearing back in their _Pearl Fisher_ costumes for their appointed cues.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666911666/media/2022/10/VO-PearlFishers_-_Full_stage_cast_chorus_-_photo_by_Emily_Cooper_Photography_ozewyw.jpg){{% /md %}}

<figcaption>The cast of The Pearl Fishers, Vancouver Opera, 2022. Photo: Emily Cooper Photography.</figcaption>  
</figure>

The VO chorus starts with a rousing _Sur la grève en feu,_ about the dangers that lay ahead of them. The chorus was massive and powerful, sounding like far more than the 30-some singers on stage. [Aaron Blake](/scene/people/aaron-blake/) as Nadir and [Phillip Addis](/scene/people/phillip-addis/) as Zurga arrive shortly thereafter, reuniting after a year separated, and rekindling their friendship after nearly losing it to falling in love with the same woman. They sing the immortal _Au fond du temple saint_ and as they begin describing the beautiful woman who captured them both, a dancer emerges at the top of the temple. Danced by Hasini Basnayake (also assistant choreographer), she told the whole story of the beautiful priestess Leïla through Kandyan dance. While the duet is a personal favourite, I couldn't stop watching the graceful dancer silhouetted against the sunset, and it was such a phenomenal moment in the production to showcase this lovely, traditional art form.

Aaron Blake's Nadir was passionate and bright, with an agile tenor with high notes to spare. He brought pathos and sympathy to his plight, and his friendship with Zurga, and affection for Leïla were poignant and heartfelt. Addis was an absolute powerhouse as Zurga, with phenomenal and stratospheric high notes with a brilliant colour. He was menacing and sympathetic in equal measure, and his change of heart in the finale was heartfelt and genuine.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666911700/media/2022/10/VO-Pearl-Fishers-Phillip_Addis_Aaron_Blake_-_photo_by_Emily_Cooper_Photography_n2jm9s.jpg){{% /md %}}

<figcaption>Phillip Addis as Zurga (left) and Aaron Blake as Nadir in The Pearl Fishers, Vancouver Opera, 2022. Photo: Emily Cooper Photography.</figcaption>  
</figure>

To balance this pair was [Miriam Khalil](/scene/people/miriam-khalil/) as Leïla. While the veiled priestess is mostly stationary for Act I, she brought a beautiful warmth to the role, with a light soprano that floated effortlessly in the quietest moments, holding back her affections for Nadir, and remaining stoic and steadfast in her duty until she can no longer deny her feelings for Nadir. In the third act, her pleas to save his life came with both strength and gentleness in equal measure. Bass-baritone [Vartan Gabrielian](/scene/people/vartan-gabrielian/) rounds out the cast as Nourabad, with a dark vocal colour and strength that worked in perfect contrast to the brighter voices on stage, and his menace and power came through with his strong presence, and stronger bass.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666911731/media/2022/10/VO_-_Pearl_Fishers_-_Miriam_Khalil_-_photo_by_Emily_Cooper_Photography_ndjfvg.jpg){{% /md %}}

<figcaption>Miriam Khalil as Leïla in The Pearl Fishers, Vancouver Opera, 2022. Photo: Emily Cooper Photography.</figcaption>  
</figure>

Directorially, the approach taken in this production was very traditional. The cast and chorus faced the audience most of the time, rather than facing the person they were conversing with. Lots of straight lines downstage and not much movement made the sound very clear, but not as entertaining to watch. Likewise having the chorus downstage, and the principals 10 feet above and 20 feet behind put the principals at a disadvantage in the ensembles, and their sound was often lost.

The VO orchestra, conducted by Kamna Gupta was in fine form, with lush orchestrations that are the hallmark of Bizet's style, delivered with precision and grace. Bizet can be very difficult to execute well, but Gupta handled it brilliantly with soaring highs and achingly poignant lows.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666911759/media/2022/10/VO-PearlFishers-Aaron_Blake_and_chorus_-_photo_by_Emily_Cooper_Photography_nbtolt.jpg){{% /md %}}

<figcaption>Aaron Blake (Nadir) and the Vancouver Opera Chorus in The Pearl Fishers, Vancouver Opera, 2022. Photo: Emily Cooper Photography.</figcaption>  
</figure>

Four South Asian dancers round out the ensemble with various dance scenes throughout the show. Using a mixture of traditional and very modern dance forms, they would underscore or complement the action on stage. They were also brought out frequently to stand or sit around one of the principals for long periods without any obvious purpose. It happened so frequently it began to feel very tokenistic, reminiscent of Gwen Stefani and her Harajuku girls as a means to add cultural clout that ended up being distasteful, and if anything highlighted the lack of any South Asian cast.

What was missing from the production was any South Asian singers. With a Lower Mainland population of \~300,000 South Asian people with a vibrant local arts community, and a global population approaching 2 billion, I don't know why VO chose not to cast South Asian leads, or delay the production until they could be scheduled. It would have been a wonderful opportunity for South Asian singers to showcase their talent and their culture in such a diverse and multicultural city as Vancouver. Working with the Asian Opera Alliance or South Asians in Western Classical Music, casting singers like Meher Pavri, Asitha Tennekoon, Maya Kherani, or Nikhil Navkal would have brought some amazing representation to these phenomenal artists.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1666911781/media/2022/10/VO-Pearl_Fishers-Vartan_Gabrielian_Miriam_Khalil_Phillip_Addis_-_photo_by_Emily_Cooper_Photography_avfy7o.jpg){{% /md %}}

<figcaption>(l-r) Vartan Gabrielian as Nourabad, Miriam Khalil as Leïla, and Phillip Addis as Zurga in The Pearl Fishers, Vancouver Opera, 2022. Photo: Emily Cooper Photography.</figcaption>  
</figure>

The setting was full of anachronisms, using both primitive torches and fire pits for lighting, as well as \~1850s lanterns. Simple wooden furniture with forged chains and beer bottles. It also had people playing cricket, which wasn’t introduced into South Asia until the 1700s, and yet no one wore shoes, which was either intended to place the setting as very ancient, or was assuming South Asian people did not ever wear shoes outdoors, which is not the case.

It felt throughout like the setting was intended to be both fantastical, and also be South Asian-inspired, but it didn't succeed. Instead, it felt like it was often performing the stereotypes it was trying so hard to avoid (or attribute to the ignorance of the composer). Like having Leïla smudging the smoke in the temple, instead of lighting incense. A purely fantastical setting with a different location that was entirely fictional would have made this conceit work better, or a production with a South Asian cast and director that brought in the art, music, and culture of the South Asian communities would have been beautiful. That is a production that I would love to see. Instead, it tried to be both and ended up as neither.