+++
author = ["authors/carly-gordon.md"]
categories = "Review"
date = "2019-01-29T18:54:04+00:00"
disclaimer = ""
image_gallery = []
postamble = "Next up from Palm Beach Opera is [_Don Giovanni_, February 22-24](https://pbopera.org/event/don-giovanni/), and [_Die Fledermaus_, March 22-24](https://pbopera.org/event/die-fledermaus/)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1548788491/media/2019/01/sq7P9A9323.jpg"
primary_image_credit = "Kristina Mkhitaryan as Violetta in La traviata, Palm Beach Opera, 2019. Photo: Bruce Bennett."
related_articles = ["articles/steps-forward-for-operas-women-tosca-at-pbo.md", "articles/too-many-jewels-the-search-for-meaning-pbos-candide.md", "articles/summer-opera-nights-in-palm-beach.md"]
related_companies = ["scene/companies/palm-beach-opera.md"]
related_people = ["scene/people/emily-blair.md", "scene/people/natalie-rose-havens.md", "scene/people/ben-schaefer.md", "scene/people/massimo-cavalletti.md", "scene/people/kristina-mkhitaryan.md"]
short_description = "Like the jewels she wore (and there were many), soprano Kristina Mkhitaryan sparkled in the starring role, singing with agility, clarity, and show-stopping emotional depth. Her soft, liquid entrances in \"Addio, del passato\" melded impeccably with the plaintive oboe solo."
slug = "a-real-woman-shines-through-reductive-traviata-in-palm-beach"
title = "A real woman shines through reductive Traviata in Palm Beach"
youtube_url = ""

+++
The problematics in _La traviata_ are par for the course – another operatic woman who tragically dies after having sacrificed her personal happiness and fortune for the sake of a particularly doting stalker – but Verdi's famed fallen heroine is one of few to command her own narrative with genuine agency, making choices driven by morality, reason, and awareness of her own mortality.

To deem the plot feminist would be generous, but it's worth noting that Verdi composed the work while living happily out of wedlock with renowned soprano [Giuseppina Strepponi](https://en.wikipedia.org/wiki/Giuseppina_Strepponi). The couple were frequently subjected to sanctimonious society gossip, making it hardly a leap to see in Violetta an operatic woman victimized not by the violence of men – for once – but by the oppression of stigma and societal double-standard.

>It's alarming and reductive that a director sees Violetta as little more than a "coquette" entangled in a "frenzied shimmer of diamonds."

[Palm Beach Opera](/scene/companies/palm-beach-opera/)'s _La traviata_, which closed its three-show run at the Kravis Centre for the Performing Arts on January 27, counts among more than 100 ill-fated Violettas to meet their untimely end on U.S. and Canadian stages this season alone. Luckily, exceptional musicianship and a flair for spectacle made PBO's rendition stand out from the pack – though shaped by a bizarre directorial vision out of touch with the current moment and in conflict with the opera's history.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548789980/media/2019/01/7P9A9277.jpg){{% /md %}}

<figcaption>Kristina Mkhitaryan (Violetta) in La traviata, Palm Beach Opera, 2019. Photo: Bruce Bennett.</figcaption>

</figure>

Like the jewels she wore (and there were _many_), soprano [Kristina Mkhitaryan](/scene/people/kristina-mkhitaryan/) sparkled in the starring role, singing with agility, clarity, and show-stopping emotional depth. Her soft, liquid entrances in "Addio, del passato" melded impeccably with the plaintive oboe solo, and her Act II duet with Germont – a resonant and earnest turn by baritone [Massimo Cavalletti](/scene/people/massimo-cavalletti/) – wove deftly between drama and dialogue, sung with nuance and warmth.

As Alfredo, tenor Alexey Tatarintsev sang with a clear tone and compelling energy, though opposite the radiant Mkhitaryan, his lovelorn laments at times played as petulant – an apt interpretation, given the character's creepy persistence in his courtship of Violetta, paying visit to her sickbed before the two even meet and professing his love (a rousing "Brindisi") within a minute of their first interaction.

>Most memorable was Flora's gambling salon, with bright red velvet walls crossing the line from luxurious to sinister, presaging the drama ahead.

Among the smaller roles, PBO's Benenson Young Artist studio made a strong showing. Mezzo-soprano [Natalie Rose Havens](/scene/people/natalie-rose-havens/) sang Flora with bubbly charm, and soprano [Emily Blair](/scene/people/emily-blair/)'s Annina stood out with a sweet tone. Baritone [Ben Schaefer](/scene/people/ben-schaefer/) as the Baron Douphol, tenor Brian Wallin as Gastone, and bass-baritone Ted Allen Pickell as the Marquis D'Obigny all sang strongly and looked the stately part. Backed by fun and fiery orchestral work under conductor Antonello Allemandi, the PBO Chorus added gusto to the party scenes, dressed in costume designer Desmond Heeley's stunning period wear.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548790144/media/2019/01/7P9A9464.jpg){{% /md %}}

<figcaption>Alexey Tatarintsev (Alfredo) in La traviata, Palm Beach Opera, 2019. Photo: Bruce Bennett.</figcaption>

</figure>

Heeley doubled as scenic and prop designer as well, imagining a palatial salon in Act I that, transformed by Stuart Duke's lighting design, becomes desolate and cavernous as Violetta plays out her final moments. Alfredo's countryside villa in Act II lingered between steampunk and Impressionism, the lushly painted garden playing backdrop to a tangle of trellises and a foreboding sense of disrepair. Most memorable was Flora's gambling salon, with bright red velvet walls crossing the line from luxurious to sinister, presaging the drama ahead.

>_La traviata_ is, in part, an opera about prostitution – but Violetta is so much more than her occupation, her wealth, her admirers, or her illness.

In his Palm Beach Opera debut, director Fabio Ceresa drew inspiration for this velvet-drenched vision from a childhood memory, recalling in his program note how he once caught a glimpse of a prostitute on the cover of a magazine – "gracefully reclining on a pillow of red velvet, her hair hanging loose, her hands covering her breasts \[...\] stark naked" – and instantly fell in love. "\[The\] mouth with its delightful little pout, the leg artfully positioned to cover what the eye was not supposed to see – something struck a chord in me, deeply," Ceresa writes. "It was as if the eyes of the woman communicated a frightened embarrassment, a gasp of modesty \[...\] One day I would certainly meet her. When I grew up I would certainly marry her. That afternoon, I fell in love for the first time." (All of this as a _child_, mind you.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1548790181/media/2019/01/7P9A9652.jpg){{% /md %}}

<figcaption>Massimo Cavalletti (Germont) and Kristina Mkhitaryan (Violetta) in La traviata, Palm Beach Opera, 2019. Photo: Bruce Bennett.</figcaption>

</figure>

There's a lot to unpack in even those few lines of a much longer and equally unsettling program note, but notable is his conclusion that Violetta "is a woman that a child had better not look at for too long. Beautiful though she may be, in the eyes of an adult she is still a _coquette_" (referring to the euphemism his grandmother used to explain away his quaint, not-creepy-at-all childhood obsession with the magazine's covergirl). _La traviata_ is, in part, an opera about prostitution – but Violetta is so much more than her occupation, her wealth, her admirers, or her illness. She makes decisions with independence and resolve, her choice to leave Alfredo at Germont's request swayed not by his pleas to think of his daughter's compromised honour, but by the strength and depth of her personal compass.

It's alarming and reductive that a director sees Violetta as little more than a "coquette" entangled in a "frenzied shimmer of diamonds." Yet Mkhitaryan successfully brought the heroine to life with all her many layers, complex and sharp and conflicted. The real Violetta was there all along, even if the men around her failed to see her for who she was.