+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-02-29T09:04:00+00:00"
lastmod = "2016-02-29T14:14:00+00:00"
preamble = "American tenor [Paul Appleby](/scene/people/paul-appleby/) has an exciting 2016 lined up, both on the opera stage, and in concert. In April he sings Belmonte in [The Metropolitan Opera's *Die Entführung aus dem Serail*](http://paulapplebytenor.com/events/mozart-die-entfuhrung-aus-dem-serail-belmonte/), and he makes his debut at the Glyndebourne Festival as Bénédicte in Berlioz' *Béatrice et Bénédicte*. \n\nAppleby is a self-proclaimed recitalist, and on **March 4 at 7:30pm** he makes another debut, at [Wigmore Hall with pianist Malcolm Martineau](https://wigmore-hall.org.uk/whats-on/lachner-schumann-wolf-and-more-201603041930). He has a clear passion for telling stories though song, and he took the time to tell us about what he has to say with his Wigmore Hall programme."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1456736830114/2016-02-29---Paul-Appleby.jpg.jpg"
primary_image_credit = "Photo by Frances Marshall."
publishDate = "2016-02-29T13:57:00+00:00"
related_articles = ["articles/talking-with-singers-nicole-cabell.md","articles/talking-with-singers-elizabeth-caballero.md","articles/talking-with-singers-leah-crocetto.md","articles/in-review-paul-appleby-at-wigmore-hall.md","articles/recitals-that-stick-matthias-goerne-at-wigmore-hall.md","articles/in-review-times-two-ensemble-prisma-wien-bernarda-fink.md","articles/a-generous-winterreise-at-wigmore-hall.md"]
related_people = ["scene/people/paul-appleby.md"]
short_description = "&quot;Most of all I am looking forward to the acoustic. I have never been to the hall but I haven’t had a conversation with a singer who has sung there who doesn’t mention how perfect a room for singing it is. But as I think about it, more importantly than the loveliness of the space I am looking forward to participating in the community of Wigmore.&quot;"
slug = "paul-appleby-telling-stories-at-wigmore-hall"
title = "Paul Appleby: telling stories at Wigmore Hall"
+++

## Why do you sing professionally?

I sing professionally because I have had a very privileged life. I was privileged to be born to parents who provided me with a life of financial stability, a good education, imparted a love of music and the arts in me, and who unfalteringly supported my dreams of pursuing this career. My upbringing permitted me to pursue the training that a professional career requires, and the success I enjoy today is another form of privilege that affords me a decent living and opportunities to make music with extraordinarily talented and accomplished collaborators.

Like many performers, I have a (tiny) bit of a complex about doing this as a job because it feels selfish to spend my time on earth serving my passion. Of course, we musicians serve our community and fellow man in an important and irreplaceable way, but it shouldn't be so fun! It is much more difficult to navigate all the travel now that my wife and I have a toddler, but at the same time, my daughter has shown me how important the arts are to kids (and all of us really). I see that I can be of value to my community as a musician by remembering how fortunate I have been and recognizing that every single person deserves the same exposure to art and the enrichment it brings.  

## What do opera and recital rep have most in common, and how do you feel they inform each other? 

As a singer, I believe that in both opera and song you must strive to express the entirety of the emotional, intellectual, and dramatic content of the music through your voice. Of course, you should use whatever other tools you have at your disposal, too (you’d be a fool not to!), but the discipline of preparing to perform requires the same focus on the details of language and vocality. 

I think of myself first and foremost as a recitalist — songs are closest to my musical heart. But I am a theater guy too, and my way into songs often involves me imagining detailed prosaic images and stories to illuminate the poetic nature of an art song (I describe an example of that process in [this blog post](https://nosongissafefromus.wordpress.com/2015/12/02/song-of-the-day-december-2/)  about Schubert’s "Die Taubenpost".) 

Opera provides the performer with a character in a specific circumstance with clearly described emotions, but these parameters can make it more challenging to connect personally to the character and the music. For example, in *Don Giovanni*, the accompanied recit before "Or sai chi l’onore" leading to Donna Anna’s aria and then to "Dalla sua pace" is an unavoidably precise emotional moment for Don Ottavio. That scene can be exhilarating to perform as Ottavio grapples with trust, love, disgust, empathy, anger, duty — not to mention his role in a carefully structured society. All this information is so useful as a performer, and the scene combines so many layers of human complexity into it. But "Dalla sua pace" must also be tethered that specific complexity.

In song, I find my work is to create the same degree of specificity in my own mind about the song I am performing, but the nature of a song and its text allows me to imagine and create that specificity in a way that resonates deeply and specifically within me. For example, "L’île inconnue" (the last song of Berlioz’s *Les nuits d’été*) is to me a theatrical scene. Of course, it the context of a song recital, you as the performer have to maintain some constancy of your persona thorough the set, and through the entire recital to a lesser degree. But I see this sailor leaping about the pier with a slightly-too-young, beautifully naïve girl and he is seducing her with enormous charm and energy. I’m not going to put on a sailor’s hat for the song, and I’m not going to leap around the stage, or use a "girly" voice when she says her line in the poem, but that scene must be technicolor in my mind when I stand relatively still and sing it on stage.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/o7Vv4fiEXsc" frameborder="0" allowfullscreen></iframe>
</figure>

## What do you look forward to most for your Wigmore Hall debut? 

Most of all I am looking forward to the acoustic. I have never been to the hall but I haven’t had a conversation with a singer who has sung there who doesn’t mention how perfect a room for singing it is. But as I think about it, more importantly than the loveliness of the space I am looking forward to participating in the community of Wigmore. Thanks to the vision, knowledge, and commitment of [Wigmore Hall director] John Gilhooly, the hall strikes me as the most dedicated spot in the world for the art of the song recital. 

Wigmore’s audience is surely among the most informed and sensitive in the world, and I am so looking forward to being a part of that community. 

## You find importance in choosing a recital programme that tells a story; what kind of connections have you found in the songs on your Wigmore Hall programme?

There are LOTS of stories! I think of this programme as two parts, but for brevity’s sake now I’ll restrict myself to the story of its first half. The songs, composers, and poets of the first all-German half interact with each other in innumerable ways, and this Heine looms so large in lieder, especially with Schumann, as his first cycle and first engagement of Heine texts, op. 24 tells a really important story about Schumann, his vision of the lied, and his understanding of his place in the development of the art form.  

Although it is not as definitively narrative as *Die Schöne Müllerin* or *Winterreise*, the nine poems of op. 24 tell the story of a young guy who is heartbroken and then goes on a journey to escape his pain. Schumann was clearly seeking to carry on Schubert’s work by not only creating a kind of homage to Schubert’s great works (op. 24, no. 7 "Berg und Burgen" in which the protagonist is contemplating the surface of water struggling to distinguish between projections, reflections, and actual depths within it in four strophic verses in A major is a loving tribute to "Tränenregen"), but also by picking up the baton the master laid down with his mere six, monumental, Heine settings at the very end of his life. Schubert seemed to express some ambivalence about Heine’s poetry—I imagine its layers of irony and pre-Modernist artistic self-awareness turned him off despite his awareness of its genius and the magnificent results of his settings of it—but Schumann finds a perfect voice for his psychologically complex musical instincts and forward looking artistry.  

Wolf figures into this story too because he, like Schumann, was a devoted student of the masters who came before him and the influence of Schubert — Wolf’s "Das Ständchen" evokes Schubert’s famous "Rellstab Ständchen" as it dances in D between major and minor modes while hitting the tonic pitch obsessively throughout - Schumann, and of course Wagner are profound in his songs. Wolf also shared some form of mental illness akin to Schumann’s own that brought a brilliant volatility to his songs. Yet the earnest Eichendorff whose poems Wolf sets in these songs is the equal of and antithesis to Heine. The last song of the Schumann cycle, "Mit Myrthen und Rosen" sets a poem about writing songs — pretty meta! — and the unwieldy structure of the song evokes Schumann’s own divided self and desires as it describes an artist creating art for a loved one he is separated from by time and distance. Wolf’s "Wolken wälderwärts gegangen" is also a song about a composer who has left home and love behind and explores the mysterious relationship between creativity and desire, inspiration and heartbreak. Heine’s toys with the notion of the ego-driven poet while Eichendorff articulates something elegantly mournful about the creative process, but in the hands of each poem’s respective composer, a complex and compelling picture of Romantic sensibilities emerges. 

This cadre of artistic personalities — Schumann, Wolf, Heine, and Eichendorff — and their voices resonant and speak to each other across these songs. 

## Do you have any pre-recital rituals? 

In the last year I have gotten into yoga, and it has become really important to me both from a singing standpoint and a personal one. I have found yoga to be really helpful to my singing in the physical discipline it demands and the use of breath it encourages. But I have found the lessons of mental focus that yoga teaches even more useful in my singing. Singing is a complex physical, mechanical process at the service of communicating complicated feelings and ideas in a profoundly intimate way. Yoga helps me explore the relationship of a physical practice that exists to serve the deeper spiritual content underneath its surface. This is how I would describe singing.  Practicing some light yoga before a recital is a great way to warm up my body and prepare it for tension, balance, and release while focusing my mind on a deeper level of understanding.

>For full details, and to purchase tickets for Paul Appleby's Wigmore Hall recital debut on March 4th, follow our box office links below.
