+++
author = ["authors/jeremy-hirsch.md"]
categories = "Review"
date = 2019-11-19T05:00:00Z
discipline = ""
disclaimer = ""
image_gallery = []
postamble = "Oper Frankfurt's [_Tamerlano_](https://oper-frankfurt.de/de/spielplan/tamerlano/) is onstage through November 24."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1574134014/media/2019/11/sq4152_tamerlano07_dxqhvj.jpg"
primary_image_credit = "(l-r) Lawrence Zazzo (Tamerlano) and Brennan Hall (Andronico) in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus."
related_articles = ["articles/dalibor.md", "articles/an-absolute-triumph-koskys-carmen.md"]
related_companies = ["scene/companies/oper-frankfurt.md"]
related_people = ["scene/people/lawrence-zazzo.md", "scene/people/rb-schlather.md"]
short_description = "The characters begin as caricatures. Tamerlano (Lawrence Zazzo), a sadistic Southwestern oil baron who's a cross between Yosemite Sam and Daniel Day Lewis's tics in There Will Be Blood, has a grin (and mustache) glued to his face."
slug = "patience-rewarded-in-oper-frankfurts-tamerlano"
social_media = []
title = "Patience rewarded in Oper Frankfurt's Tamerlano"
website = ""
youtube_url = ""

+++
Some indie opera tropes have grown too tired to contribute much to spontaneous, surprising story telling. Examples include placing a character or two onstage before the audience enters, the orchestra being part of the _mise en scène_ and participating gamely in a few meta jokes, characters moving in ambiguous slow motion during transitions, sets looking slapdash and minimalist, the score being benignly altered, singers melodramatically intoning texts, and the fourth wall being broken, a lot.

Director R.B. Schlather utilizes all of the above techniques in the first act of his new _Tamerlano_ (Handel) at Oper Frankfurt's hip alternate venue, the Bockenheimer Depot.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574134024/media/2019/11/4156_tamerlano01_uykmn6.jpg){{% /md %}}

<figcaption>Lawrence Zazzo (Tamerlano, front right) and in the background from left to right Yves Saelens (Bajazet), Elizabeth Reiter (Asteria) and Brennan Hall (Andronico) in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus.</figcaption>  
</figure>

In this case, the devices seem geared toward gussying up Handel's exposition with something beyond (or beside) the opera's circumstances. The characters begin as caricatures. Tamerlano (Lawrence Zazzo), a sadistic Southwestern oil baron who's a cross between Yosemite Sam and Daniel Day Lewis's tics in _There Will Be Blood_, has a grin (and mustache) glued to his face. He giddily flings around a bull whip on his way to taking the helpless Asteria (Elizabeth Reiter) from her lover, the hapless Andronico (Brennan Hall), and torturing his imprisoned wartime rival, Asteria's father, the Sultan Bajazet (Yves Saelens).

> The countertenor wiggles through coloratura with his entire body, his shoulders shimmying up and down.

The first act passes by with a lot of bells and whistles but not much else. Then, surprise! Intermission. Does the line seem extra long for drinks? Better stretch those glutes; another two hours (at least) to go.

Luckily, in the second act the singers get space to work and the evening begins to transform.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574134037/media/2019/11/4161_tamerlano08_spxopx.jpg){{% /md %}}

<figcaption>Elizabeth Reiter (Asteria) and Brennan Hall (Andronico) and the Frankfurt Opera and Museum Orchestra in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus.</figcaption>  
</figure>

Asteria has come to a breaking point. If she doesn't take drastic action, her father will be murdered by Tamerlano, whom she will be forced to marry, and her lover Andronico will be coupled with princess Irene, Tamerlano's (former) fiancée. Asteria decides that to restore order, she must run a covert scheme to murder Tamerlano as she joins him for the first time on his throne. Meanwhile, since she must keep her father and lover out of the loop for her plan to succeed, her relationships with them are falling apart. Both believe Asteria is sacrificing their fates to gain Tamerlano's throne in earnest.

> From the first phrase, her voice is placid, shimmering yet unwavering.

In the aria "Non è più tempo" (roughly: "time has run out"), Asteria ruminates on the isolation of her heroism as she convinces Andronico that she no longer desires him. Soprano Elizabeth Reiter's voice quivers with apprehension, blooms with adoration, withers with guilt, and soars with resolve, her timbre buoyant with unimpeachable fortitude.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574134048/media/2019/11/4165_tamerlano14_qdurot.jpg){{% /md %}}

<figcaption>Lawrence Zazzo (Tamerlano) and Elizabeth Reiter (Asteria) in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus.</figcaption>  
</figure>

The character of Irene, Asteria's rival, is portrayed as a crazy, power hungry, jilted lover who, dressed in tacky but expensive couture, bounds about throwing money and influence at her problems. However, with the aria, "Par che mi nasca in seno," mezzo-soprano Cecelia Hall restores the character's humanity. From the first phrase, her voice is placid, shimmering yet unwavering. After a lot of energetic posturing, Hall becomes a vessel of sincerity. Her genuineness is magnified by orchestral figures that vacillate between nobility and vulnerability.

These stretches of taintless singing make up for the bluster that surrounds them. Yves Saelens as Bajazet is a gruff, indignant, fallen ruler on the precipice of annihilation. Only when he sees the depth of his daughter's suffering does he allow expressions of tenderness expressed with wafting lyricism.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574134060/media/2019/11/4169_tamerlano18_h5451c.jpg){{% /md %}}

<figcaption>Yves Saelens (Bajazet) in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus.</figcaption>  
</figure>

Zazzo as Tamerlano also shouts and pounds, but his objective is to threaten. The countertenor wiggles through coloratura with his entire body, his shoulders shimmying up and down. It's a visual quirk that seems chosen to physicalize the peculiarity of his character but perhaps it also keeps his singing fluid. He races through Tamerlano's treacherous runs with accuracy and panache.

Though Liviu Holender has too high a voice for Leone, it pays off in his ability to gracefully manage the tessitura of the final chorus. Only the aria suffers, whose low lying range never quite allows his voice to bloom.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574134071/media/2019/11/4150_tamerlano19_ucpr9z.jpg){{% /md %}}

<figcaption>(back to front) Liviu Holender (Leone), Lawrence Zazzo (Tamerlano) and Brennan Hall (Andronico) in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus.</figcaption>  
</figure>

Countertenor Brennan Hall, in the role written for superstar alto castrato Senesino, lacked a degree of power in his middle voice that the role demands. Still, he gave a sincere performance as Andronico. As he climbed through the risers after a particularly brutal dramatic sequence, fat tears ran down his cheeks. It was touching to see and a welcome justification for the actors being so close to the spectators.

Maestro Karsten Januschke's gestures in the overture were overly performative – the risk of being on display – creating brief disunity within the orchestra, however he quickly settled down and drew a high-octane, multi-textured performance out of Frankfurt's excellent band.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574134097/media/2019/11/4171_tamerlano21_p6o8ow.jpg){{% /md %}}

<figcaption>(l-r) Yves Saelens (Bajazet), Elizabeth Reiter (Asteria) and Brennan Hall (Andronico) in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus.</figcaption>  
</figure>

A lot can be forgiven for a powerful third act and it's here that Schlather brings the full stakes of reality to bear. Tamerlano rips off his disguise and transforms from a leather cowboy into a gangster enforcer. His weapon of choice is a long, aluminum softball bat which he lugs over his shoulder and taps menacingly with his ring.

> The group sings a sublime choral ensemble of resigned thanks. They've lived to see another day.

The good guys' plan has unraveled and Tamerlano is out of patience. He sends Asteria to the slave quarters to be raped. A bale of hay is emptied onto the floor, and Asteria, in a dark, leather BDSM pig mask, is thrown onto the pile. Left alone, she removes the mask and reveals her face bruised and bloodied and her white wedding gown stained red.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1574135258/media/2019/11/4153_tamerlano06_lxje1z.jpg){{% /md %}}

<figcaption>(l-r) Brennan Hall ( Andronico), Elizabeth Reiter (Asteria) and Liviu Holender (Leone) and the Oper Frankfurt and Museum Orchestra in Tamerlano, Oper Frankfurt, 2019. Photo: Monika Rittershaus.</figcaption>  
</figure>

Bajazet, who professes repeatedly that he would rather die than appease Tamerlano's will, downs the poison he has saved for just such a dehumanizing moment. His death is wrenching in itself, but more heartbreaking is the way he says goodbye to Asteria. Father and daughter embrace for what they wish was an eternity.

Bajazet's death sways Tamerlano to relent. He allows Asteria and Andronico to reunite and takes Irene back as his betrothed. Order is restored but with a devastating body count. The group sings a sublime choral ensemble of resigned thanks. They've lived to see another day. The ascending dance transforms into a cascade of sighs as the theater dims imperceptibly to black.