+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2018-10-09T19:34:00-04:00"
lastmod = "2018-10-19T15:29:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539128039910/sqMichaelFabiano_MariaAgresta_LABOHEME_LYR181003_087_c.jpg.jpg"
primary_image_credit = "Michael Fabiano (Rodolfo) and Maria Agresta (Mimì) in La bohème, Lyric Opera of Chicago, 2018. Photo by Todd Rosenberg."
publishDate = "2018-10-09T19:34:00-04:00"
related_articles = ["articles/an-operas-evolving-relevance-turandot.md", "articles/bohemian-atg-boheme.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/maria-agresta.md", "scene/people/rolando-villazon.md", "scene/people/zachary-nelson.md", "scene/people/danielle-de-niese.md", "scene/people/ricardo-rivera.md"]
short_description = "Director Richard Jones deserves fervent applause for his three-dimensional realization of this show.  Characters and set-pieces alike moved and reacted with cinematic deliberateness.  Rising conductor Domingo Hindoyan makes his Lyric debut in this production. The LOC orchestra responded with a lush blanket of sound, emanating from the pit and supporting the singers.  "
slug = "pass-the-tissues-a-beautiful-new-bohème-in-chicago"
title = "Pass the tissues: a beautiful new Bohème in Chicago"

+++
There's a special kind of energy in the air on a season's opening night at major opera houses like the Lyric Opera of Chicago.  This past Saturday, the LOC kicked off its 2018-2019 season with a beloved and indomitable classic: Puccini's [*La bohème*](https://www.lyricopera.org/concertstickets/calendar/2018-2019/la-boheme-opera-tickets).
 
Ambling through the Civic's iconic art-deco foyer, surrounded by bedazzled patrons donning fine gowns, tuxedos, turbans, wraps, and trinkets, one vicariously absorbed the collective glamour of the occasion. Despite the glitz and gleam, though, the occasion itself – that of hearing and seeing *La bohème* performed live by stellar musicians – predominated the evening. Personally, I never tire of this piece (and acknowledge its place in an opera house's repertory along with the likes of *Aida* and *Carmen*, which together with *Bohème* comprise the "ABCs" of box-office success).  Puccini's *La bohème* is a masterpiece. There! I said it.  And those who pooh-pooh this score, I claim, don’t really know it.  (Benjamin Britten notwithstanding who, in a 1951 article in *Opera* magazine, derided *Bohème* as "cheap" and "empty.") 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539127851408/MichaelFabiano_MariaAgresta_LABOHEME_CU-98_c.jpg.jpg)
<figcaption>Michael Fabiano (Rodolfo) and Maria Agresta (Mimì) in *La bohème*, Lyric Opera of Chicago, 2018. Photo courtesy of Lyric Opera of Chicago.</figcaption>
</figure>

A joint venture with the Royal Opera House Covent Garden and Teatro Real Madrid, the current production of *La bohème* on the LOC stage thoroughly lived up to the occasion.  With glorious singing, engaged acting, stunning sets and costumes, and the incomparable LOC orchestra, the ovation following the curtain-drop was resounding, inevitable, and earned.

Spearheading the cast in the lead roles of Rodolfo and Mimì were tenor [Michael Fabiano](/scene/people/michael-fabiano/) and soprano [Maria Agresta](/scene/people/maria-agresta/).  Fabiano, making his Lyric debut with this run, put his bona fides as one of today's star young tenors on full display.  Although it's difficult to forget the sounds of famous Rodolfos of the past (Pavarotti, to name just one example and my personal bias), I cannot recall a more nuanced performance of this role than Fabiano's from this Saturday.  His text-driven delivery was refreshing, insightful, and utterly to the benefit of Puccini's parlando style of vocal writing.  What I heard was not just beautiful singing, but impassioned declamation.  As an actor, Fabiano was equally committed to the throes of his character's life, desires, and faults.  I watched him with rapt attention.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539127861591/MichaelFabiano_MariaAgresta_LABOHEME_CU-36_c.jpg.jpg)
<figcaption>Michael Fabiano (Rodolfo) and Maria Agresta (Mimì) in *La bohème*, Lyric Opera of Chicago, 2018. Photo courtesy of Lyric Opera of Chicago.</figcaption>
</figure>
 
Opposite Fabiano, Italian soprano Maria Agresta (last season's Liù in LOC’s [*Turandot*](/an-operas-evolving-relevance-turandot/)) proved an arresting Mimì both vocally and visually on stage.  Most moving were the dichotomies she brought to her performance: outward fragility with inner strength, foreboding with hopefulness, a sense of independence with a profound human need for connection and love. Her famous Act I aria, "Si, mi chiamano Mimì" was glorious in all these regards, while her lovelorn reminiscences and ultimate death in Act 4 were seriously heartbreaking.  Yes, I cried.  It was impossible not to.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539127870516/DanielledeNiese_ZacharyNelson_LABOHEME_LYR181003_206_c.jpg.jpg)
<figcaption>Danielle De Niese (Musetta) and Zachary Nelson (Marcello) in *La bohème*, Lyric Opera of Chicago, 2018. Photo by Todd Rosenberg.</figcaption>
</figure>

[Danielle De Niese](/scene/people/danielle-de-niese/) is comparatively new to Puccini, but you never would have guessed that from her magnificent and uproarious performance as Musetta in this production.  From the moment she pranced onto the stage, it was impossible to take your eyes off her.  As Marcello's ex, she played the jilted girlfriend immaculately.  No one at Café Momus was safe as she sauntered across the tightly packed table-tops while singing her signature znumber "Quando m'en vo." At the other end of the spectrum, in Act IV, De Niese as Musetta was a totally sympathetic and caring friend to the dying Mimì.  That moment when she brings Mimì the muff…I'm done…where are the tissues? Stage histrionics aside, fabulous though they were, De Niese's singing on Saturday night was equally captivating — like an unspooling thread of radiant silk.  I know her primarily for her Handel and Mozart roles, but now having heard her sing Puccini, I hope she will delve further into the late-Romantic repertoire in the future.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539127878414/DanielledeNiese_ZacharyNelson_RicardoJoseRivera_AdrianSampetrean_MichaelFabiano_MariaAgresta_LABOHEME_LYR181003_456_c.jpg.jpg)
<figcaption>Danielle De Niese (Musetta), Ricardo José Rivera (Schaunard), Adrian Sâmpetrean (Colline), Michael Fabiano (Rodolfo), and Maria Agresta (Mimì) in *La bohème*, Lyric Opera of Chicago, 2018. Photo by Todd Rosenberg.</figcaption>
</figure>

Rounding out the cast were baritones [Zachary Nelson](/talking-with-singers-zachary-nelson/) as the painter, Marcello, [Ricardo José Rivera](/scene/people/ricardo-rivera/) as the musician, Schaunard, and bass Adrian Sâmpetrean as Colline, the philosopher.  Each was a standout for the distinct colors they infused into their respective roles.  Nelson especially was a dynamic presence, gruff in character though honeyed in voice.  I'm excited to hear more of him in the future. 
 
A special shout-out must go to the marvelous LOC chorus and chorus master Michael Black as well as to the Chicago Children's Choir directed by Josephine Lee.  As an ensemble they complemented each other superbly in both look and sound. The sets and costumes, designed by Stewart Laing, were exactly what one would hope to see in a new production of *La bohème*: fresh, yet tasteful and at the service of the story. (Sorry, I don't follow the *Bohème*-in-outer-space bandwagon. \*See the 2017 production at the Paris Opera.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539127887264/LABOHEME_WS-32_c.jpg.jpg)
<figcaption>A scene from *La bohème*, Lyric Opera of Chicago, 2018. Photo courtesy of Lyric Opera of Chicago.</figcaption>
</figure>
 
Director Richard Jones deserves fervent applause for his three-dimensional realization of this show.  Characters and set-pieces alike moved and reacted with cinematic deliberateness.  Rising conductor Domingo Hindoyan makes his Lyric debut in this production. The LOC orchestra responded with a lush blanket of sound, emanating from the pit and supporting the singers.  

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1539127898662/MichaelFabiano_ZacharyNelson_LABOHEME_LYR181003_413_c.jpg.jpg)
<figcaption>Michael Fabiano (Rodolfo) and Zachary Nelson (Marcello) in *La bohème*, Lyric Opera of Chicago, 2018. Photo by Todd Rosenberg.</figcaption>
</figure>

For the total opera experience — whether it's your first or hundredth time — go see this production of [*La bohème* at the Lyric Opera of Chicago](https://www.lyricopera.org/concertstickets/calendar/2018-2019/la-boheme-opera-tickets). The shows runs until October 20, 2018 and again in January, 2019.