+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-04-22T19:37:00+01:00"
lastmod = "2016-04-23T12:03:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461407604298/2016-04-23---Scissors-2.jpg.jpg"
publishDate = "2016-04-23T11:55:00+01:00"
related_articles = ["articles/opera-in-concert-uncluttered-or-uninteresting.md"]
short_description = "When it&#039;s harder to pull a section away from an entire scene, to find the real beginnings and ends of an aria, does that mean the opera is a purer melding of theatre and music? When a singer fights the urge to sing a bit from Bluebeard&#039;s Castle, and opts instead for &quot;Quando m&#039;en vo&quot;, are her urges founded in some quantifiable difference in quality? "
slug = "party-arias-the-traits-of-lesser-operas"
title = "Party arias: the traits of lesser operas?"
+++

For working opera singers, it may feel as though they spend as much time learning roles as they do choosing arias to sing at concerts, galas, parties, and endless other random events worthy of great singing. There's a list of favourites that make it on these kinds of programmes, like the Laughing Song from *Die Fledermaus*, the Doll Song from *Les contes d'Hoffmann*, stuff from  *Carmen*, *Il barbiere di Siviglia*, *La traviata*, *Le nozze di Figaro*, and just about anything by Puccini.

These choices keep popping up not because singers lack imagination or a diverse repertoire; it's because these operas are great. Of course, there are other great operas, like *The Death of Klinghoffer* and *The Rape of Lucretia* and *The Cunning Little Vixen* and *Tristan und Isolde* and *The Rake's Progress* and *Dialogues des Carmélites* and *The Turn of the Screw*. Frankly, this latter list of operas is where singers will find more of the meaty roles, the layered pieces of theatre and music that get their performance juices flowing. So, why are they the rarer picks for a gala?

The answer isn't a mystery: excerpts from *Peter Grimes* or *Satyagraha* or *Doctor Atomic* are really difficult to pull off out of context. Arias by Handel and Rossini and Verdi are usually neatly contained as a single musical number, with an introduction, aria proper, postlude, and an applause-inducing cadence at the end. Wagner, Strauss, and even late Verdi get trickier, since their operas are more through-composed; even with "Presentation of the Rose" or "O du, mein holder Abendstern", finding those ideal spots to start and end the arias often takes some score doctoring. There are great bits like "Non, monsieur mon mari" from *Les mamelles de Tirésias* and Pierrot's Tanzlied from *Die tote Stadt*, but things can get awkward when there's no one to share those interjections from other characters or choruses (and pianists often hate it when it's suggested that they pipe up as a gag).

It's a funny paradox. Operas have evolved from the numbered forms of Mozart and Donizetti, and have shifted towards the more real-time, continuous flow of Britten and Adams and Carlisle Floyd. There's no change in musical quality, but there's an arguable move towards a theatre-first approach, one where the music closely serves the text, rather than the two elements existing more as stand-alone pieces. You could play instrumental versions of "Martern, aller Arten" or "Ernani, involami", and they'd still maintain a good amount of musical integrity. But to take the words away from "Bottom's Dream"?

This problem is irritating when it comes to finding some variety in a singer's list of party hits, but on the other hand, it's a huge testament to the cohesion and organicism of these hard-to-excerpt operas. When it's harder to pull a section away from an entire scene, to find the real beginnings and ends of an aria, does that mean the opera is a purer melding of theatre and music? When a singer fights the urge to sing a bit from *Bluebeard's Castle*, and opts instead for "Quando m'en vo", are her urges founded in some quantifiable difference in quality? Yes, the story of *La bohème* is a great one, but does Puccini *tell* stories in the same way as Bartók?

This isn't a push to get more Britten or more Mussorgsky on the list of party arias. It's similar to the difference between Rodgers & Hammerstein and Stephen Sondheim; both offer fantastic music, but the latter requires more subtle surgery to pull sections of it out of context. For an opera to have a "hit number" isn't a knock against it, not at all. "Ain't it a pretty night" from *Susannah* is a well-known chunk of an opera that's largely conversational and totally text-based, in the same way as the neat, divided "Glitter and and be Gay" from *Candide*. 

It's not news that we're big champions of new opera, yet it's hard to deny that we walk away from hearing performances of 21st-century works not with many tunes in our head, but instead with really transcendent experiences of hearing stories told in that heightened way that only opera can achieve. Is it just a matter of time before excerpts from newer works begin to populate the norm of what it means to have a party aria? Or will a divide grow larger and larger, between how opera can be represented in small doses, and how it's experienced in its full-length form?

>Readers, what do you think? Let us know in the comments below.
