+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2016-04-21T09:50:00+01:00"
lastmod = "2016-04-21T12:10:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461235507927/2016-04-21---CLS-2015-16-Season-Finale-Credit-James-Berry.jpg.jpg"
primary_image_credit = "Photo by James Berry."
publishDate = "2016-04-21T12:05:00+01:00"
related_articles = ["articles/great-nights-sketches-of-miles.md","articles/review-the-personal-side-of-bachs-b-minor-mass.md"]
related_companies = ["scene/companies/city-of-london-sinfonia.md"]
related_people = ["scene/people/helen-charlston.md","scene/people/charlotte-bray.md"]
short_description = "The whole evening was one that urged us to simply close our eyes and listen. It&#039;s always refreshing to hear a well-honed orchestra with so much attention paid to the experience, rather than relying simply on the deep roots of traditional classical concert tropes."
slug = "paris-reflected-at-southwark-cathedral"
title = "Paris Reflected at Southwark Cathedral"
+++

The [City of London Sinfonia](/scene/companies/city-of-london-sinfonia/) closed its RE:Imagine series last night at the Southwark Cathedral, with *Paris Reflected*, a concert that brought listeners into the *Belle Époque*. It was the time of Debussy, Fauré, Ravel, Monet, Manet, Pissarro, the building of Paris' Sacré-Coeur Basilica, and The Great War. The latter hung over so much of the art and music of the time, yet it's always a surprising reminder to experience it, and to see and hear all the light and kindness in these works.

Under maestro Benjamin Nicholas, the Sinfonia treated us to Debussy's *Petite Suite*, specifically the orchestrated version by fellow composer Henri Büsser. Helped by the Southwark Cathedral's stunning acoustic, the sounds of flutes and harps, shimmering strings, and curious augmented chords evoked something so quintessentially French, without the music's transparency ceding to walking on eggshells. Gabriel Fauré's *Pavane* followed, reminding us that we could listen to that tune all night long. It's funny how *Pavane* comes from a notable period in time, and achieves a timeless sound in part through its looking back to early dance forms of the 16th and 17th centuries. 

The Sinfonia kept up these historical nods, with [Charlotte Bray](/scene/people/charlotte-bray/)'s arrangement of the *Sarabande* from J.S. Bach's Partita no. 6 in E minor, BWV 830. Originally for keyboard, Bray let anachronistic instruments like the marimba and clarinet share Bach's counterpoint. Maurice Ravel did similarly in his *Tombeau de Couperin*, which closed the first half of *Paris Reflected*. Again, we heard that enticing mix of old forms and rhythms, coloured with new harmonies; the Sinfonia brought us through Ravel's quick turns, from the fragile and transparent, to the impossibly lush. Plus, the Cathedral offered up some delicious reverberation.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461235559447/2016-04-21---Benjamin-Nicholas-Conducts-CLS-Credit-James-Berry.jpg.jpg)<figcaption>Benjamin Nicholas conducts the City of London Sinfonia. Photo by James Berry.</figcaption>
</figure>

The second half was full of Maurice Duruflé's *Requiem*, and the Sinfonia was joined by the [Holst Singers](https://holstsingers.com/), the [Southwark Cathedral Girls' Choir](http://cathedral.southwark.anglican.org/worship/music-and-choirs), organist and Girls' Choir director Stephen Disley, baritone [Roderick Williams](http://www.ingpen.co.uk/artist/roderick-williams/), and mezzo-soprano/contralto [Helen Charlston](/scene/people/helen-charlston/). Duruflé's is a *Requiem* that lives up to the grandness of the text, yet stays human and easy; perhaps it's his love of Gregorian chant melodies that lets this work move organically, full of melodies that don't dwell or resort to heavy-handed storytelling. A composer strongly influenced by his life as a church musician, Duruflé writes what feels like the hopeful side of religion, rather than the threatening. 

The two choruses were stunning to hear, and there was something beautiful about watching them, too; standing on a steep incline of risers, with a long cathedral nave extending behind them, there was something immediate about these singers. They were organized in sound, and somewhat haphazard in look; the singers of all ages (and heights) created uneven lines of people, like a true congregation of everyday men, women and children. The soloists, too, struck a beautiful mix of drawing attention to what they sang, and avoiding an operatic "spotlight".

The whole evening was one that urged us to simply close our eyes and listen. It's always refreshing to hear a well-honed orchestra with so much attention paid to the experience, rather than relying simply on the deep roots of traditional classical concert tropes. There's something lovely about hearing Debussy and Fauré, while spotting the train amble by through the cathedral windows.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1461235597450/2016-04-21---Southwark-Cathedral-Vaults-Credit-James-Berry.jpg.jpg)<figcaption>Southwark Cathedral Vaults. Photo by James Berry.</figcaption>
</figure>

For more from the City of London Sinfonia, have a look at their upcoming [*Crash Bang Wallop: Secrets of the Garden*](https://cityoflondonsinfonia.co.uk/whats-on/2249/crash-bang-wallop-secrets-of-the-garden/) on Saturday, June 18 at Cadogan Hall. The family-oriented concert features the CLS offering up musical clues, as young people put on their explorer's hats.
