+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-11-27T09:35:00-05:00"
lastmod = "2015-11-27T11:39:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448640221303/2015-11-27---SummerPrograms.jpg.jpg"
publishDate = "2015-11-27T11:30:00-05:00"
related_articles = ["articles/how-to-make-the-most-of-your-summer-program.md","articles/opera-in-summer.md","articles/wells-fargo-isnt-antiarts-everyone.md","articles/4-things-you-shouldnt-expect-from-summer-programs.md","articles/music-degrees-expectations-4-tips-for-new-students.md"]
short_description = "Summer programs, and their expensive nature, have been under scrutiny during this 2015/16 audition season. It&#039;s not a new conversation; the advent of bloggers has meant conversations about not-cheap aspects to the opera training industry, including famed bass-baritone Alan Held&#039;s strong words for YAPs (conversely, there&#039;s this controversial article about why audition fees are necessary)."
slug = "paid-summer-programs-is-it-time-for-a-revolution"
title = "Paid summer programs: is it time for a revolution?"
+++

Summer programs, and their expensive nature, have been under scrutiny during this 2015/16 audition season. It's not a new conversation; the advent of bloggers has meant conversations about not-cheap aspects to the opera training industry, including famed bass-baritone [Alan Held](/scene/people/alan-held/)'s [strong words for YAPs](http://slippedisc.com/2014/11/opera-stalwart-young-artist-programs-are-ripping-off-young-artists/) (conversely, there's [this controversial article](http://thousandfoldecho.com/2014/10/17/why-opera-companies-charge-audition-fees-and-why-you-should-pay-them/) about why audition fees are necessary). The common source of contention is the high, often prohibitive, cost of summer opera programs. 

Young singers and pianists who pay these fees aren't doing it because they have the extra cash; they do it because they want an audition for XYZ Summer Opera Workshop, and they can't do it without paying $500-$5000 in tuition. They want a summer full of face-time with great teachers and coaches that are hard to track down during the academic year. There's some sense to this reasoning; summer programs give singers and pianists work experience and lessons with new mentors. And to what should it all lead? Jobs!

Yet, the investment is vague, and no promises are ever made. This isn't necessarily the fault of these mentors, nor of the folks behind these summer programs; the industry is inconsistent, and students learn this fact, too. But it's a problem when the dots are difficult to connect between summer experience and fall employment. Yes, it's up to the singer or pianist to work on their craft, and to be savvy about where to look for auditions, and with whom to keep in touch. At the same time, these summer programs offer help to young artists who are taking these next steps, by bringing them teachers, conductors, guest speakers, and other not-to-be-missed opportunities. 

In reality, not every singer who pays tuition for a summer program gets the same amount of reward. Singers can slip through the administrative cracks, and they don't always get all the lessons and coaching times they were anticipating. It's common for young artists to be accepted into these summer programs, when they're not yet ready to take advantage of what the program has to offer. Working too soon with the likes of Gerald Martin Moore or Michael McMahon, this doesn't stretch the young artist, it goes over his or her head (and I think that's a poor use of said artist's funds). 

Sometimes these artists are more vocally advanced, with significantly more stage experience; in a relatively low-pressure environment like a summer program production, they're not being stretched professionally. Their great voices are being used for the summer program's "product", which is the show at the end of it all. Casting exciting voices isn't an issue in itself; but there's a problem with a program, whose mission reads some variance on "helping emerging artists bridge the gap between training and professional work," putting their energy and resources into a final production instead of a tailor-made educational opportunity for these artists. 

Firstly, rigorous rehearsals can be the reason for the imbalance among program participants. Younger singers are often given chorus parts and/or understudy roles in the Summer Program Production, and too often their staging and music rehearsals take precedence over these singers' individual lessons and coachings. These chorus singers are often the greenest of the bunch, and it's a sad irony that their training opportunities are the first to go because of a rehearsal call. And because they're young, these artists are the least likely to argue, to insist on having the lessons they were told make up the cost of their tuition.

More importantly, production-oriented programs without their own grant coverage cost the artists way more than those that are process-oriented. Why? They have to pay for a theatre, for sets, costumes, for a full orchestra (because as we all know, a summer program is way less legit if they do their shows with just piano, and heaven forbid the pianists at these programs get some performance experience of their own). I've [mused before](/artists-administration-reputations/) about programs who have lavish sets for their shows, but a deplorably bad administrative staff. It's indicative of what the program heads want to accomplish, and it often appears that they want to be opera companies rather than training programs.

So, what's a better use of a young artist's summer? In my humble opinion, it's an even split between lessons with a teacher or coach you trust, and a course in business or arts administration (or, even shadowing an ongoing production). Summer programs need to be the first to react to the closure of opera houses in North America, by training artists to create their own performance opportunities. The standard schedule for summer opera programs is something like five weeks of lessons and rehearsals, punctuated by one or two one-hour talks about how the industry is hard, and what agents are looking for in a singer. Instead, five weeks of learning to program, produce, and market a show of their own imagining could be more of a teach-a-man-to-fish method. I wonder what a program like that would cost?

Now, if you want to pay for an onstage opportunity, that's your perogative. It *does* teach you things, you *will* learn your craft. It's worth it, in my opinion, to invest some money in the summer program circuit; meeting other colleagues who aren't based in your city is really important, and programs are a hub for doing that sort of thing. Relationships are more consistent than most audition processes, in my own experience.

The vague concept of that student-to-professional bridging, though, is where summer programs need to get specific. Again, they're part of the same mysterious, inconsistent industry as the artists trying to break in, and it's not fair to say that these programs should come up with the answers of Opera-Gig-Getting 101. I do think that they have some responsibility, as the frontline for many aspiring singers and pianists, to represent the industry accurately. Paying $4000 to sing one performance of Frasquita might teach you the role, maybe improve your French, and get you more comfortable onstage, but it would be a *very* rare case for you to earn that money back by singing Frasquita professionally. Putting that money towards guaranteed lessons and some training in production and marketing might give a young artist more tangible tools for starting their career.

It's a two-way street. Young artists need to get specific about what they want to learn and who they want to meet. If that starts to mean less auditioning for summer programs, and more seeking out your own education, so be it. It's also the way that these programs will learn what young artists really want, and hopefuly begin to offer it. What do you think, readers? Is there a revolution to begin?
