+++
author = ["authors/arturo-fernandez.md"]
categories = "Review"
date = "2019-09-29T04:00:00+00:00"
disclaimer = ""
image_gallery = []
postamble = "Boston Lyric Opera's production of [_Pagliacci_](https://blo.org/pagliacci/) runs through October 6. "
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1569692999/media/2019/09/sqPagBLO2019-PAG-7byLizaVoll_yx7lro.jpg"
primary_image_credit = "Rafael Rojas (Canio) in Boston Lyric Opera's 2019 production of Leoncavallo's Pagliacci. Photo: Liza Voll."
related_articles = ["articles/blo-barber-brings-delightful-laughter-amid-overdesign.md", "articles/blo-s-electrifying-rape-of-lucretia-a-revelation.md"]
related_companies = ["scene/companies/boston-lyric-opera-1.md"]
related_people = ["scene/people/tobias-greenhalgh.md", "scene/people/rafael-rojas.md", "scene/people/michael-mayes.md", "scene/people/lauren-michelle.md", "scene/people/omar-najmi.md"]
short_description = "This, combined with a note-complete love duet, was enough for the production to justify the bells and whistles of its carnival pre-show, and I found myself not wanting for Pagliacci's much-beloved double-bill partner Cavalleria rusticana."
slug = "pagliacci-alone-makes-festive-shocking-season-opener"
title = "Pagliacci alone makes festive, shocking season opener"
youtube_url = ""

+++
Imagine for a second the following scene: an audience is ushered into a relatively small carnival by a train of clowns playing March of the Gladiators on kazoos. To one side, a matching game with ducks floating in water: whoever gets a matching pair wins a rubber ducky. To another, a refreshments table that sells saltwater taffy and cotton candy, among other popular carnival treats. Next to that, a stage shared alternately by an amateur choir and a duo of young jugglers.

> The effect was disarming in a way that left the audience unprepared.

In the center of it all, a clown blows bubbles next to someone blowing balloon animals while watching a plastic trombone. And there you are, animatedly chatting with friends as, with a blast of confetti, a tent opens up and you are beckoned into a theater area.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693082/media/2019/09/PagBLO2019-PAG-1LizaVoll_xu0b7x.jpg){{% /md %}}

<figcaption>in Boston Lyric Opera's 2019 production of Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

You would expect, at the end of all this, that a show with clowns would play. In a sense, there are clowns in this show, but the clowns of Leoncavallo's _Pagliacci_ come onstage, presenting us with their troubles. As practically everyone in the opera world knows, _Pagliacci_ is an affair that does not end well.

For their return to the Steriti Memorial Rink, [BLO went all out](https://blo.org/pagliacci/) for the pre-show carnival, which opened its doors an hour before the opera began. One would think that something so jovial would be perhaps distasteful for one of opera's most iconic tragedies, and yet the effect was disarming in a way that left the audience unprepared, perhaps in no small part thanks to the commitment of everyone in the pre-show carnival.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693101/media/2019/09/PagBLO2019-PAG-4byLizaVoll_auysnp.jpg){{% /md %}}

<figcaption>Lauren Michelle (Nedda), Rafael Rojas (Canio) and Michel Mayes (Tonio, background) in Boston Lyric Opera's 2019 production of Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

The clowns attending to the carnival made sure that everyone was having as fun of a time as possible, even down to how they referred to it as "the carnival" and the rapport they built with patrons. For most caught up in the carnival affairs, the spectre of the opera's well-known finale seemed to vanish, and the result breathed new life into the entirety of a work that has been performed almost to death.

> I found myself not wanting for Pagliacci's much-beloved double-bill partner Cavalleria rusticana.

In particular, it left us unprepared for the violent finale (which was also more violent than usual, considering that Canio opts to choke Nedda to death and that Tonio smacks Beppe in the head with a wine bottle); I actually jumped in my seat at Silvio's stabbing despite the fact that I knew it was coming, and this shock remained through Tonio gleefully exclaiming opera's most recognizable final line before rampaging around the stage blowing up confetti and cackling like Heath Ledger's Joker.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693294/media/2019/09/PagBLO2019-PAG-0010_ij39cj.jpg){{% /md %}}

<figcaption>Tobias Greenhalgh (Silvio) and Lauren Michelle (Nedda) in Boston Lyric Opera's 2019 production of Leoncavallo's Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

This, combined with a note-complete love duet, was enough for the production to justify the bells and whistles of its carnival pre-show, and I found myself not wanting for Pagliacci's much-beloved double-bill partner _Cavalleria rusticana_.

Of course, the effect would most likely have been lost if not for the efforts of the singers that traversed the circle-in-the-round staging where the actual opera was performed, and here practically everyone delivered in some way. The first of these was [Michael Mayes](/scene/people/michael-mayes/) as Tonio.

Michael Mayes was a _tour de force_, deftly balancing between the ridiculous and the menacing aspects of his character. This came to the fore particularly in the play within a play, where he plays up Taddeo's foolishness, but then stabs a chicken rather violently with the eventual murder weapon as if to signal to the real audience that Canio was not the only one breaking character that night. This play in contrast never let up for a second after Tonio tried to force himself on Nedda earlier, and the result was electric.

> Rojas brought a pathos to the whole aria, and the way he subtly broke down during the aria's conclusion humanized Canio.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693141/media/2019/09/PagBLO2019-PAG-8102665_zwfnq1.jpg){{% /md %}}

<figcaption>Omar Najmi (Beppe/Harlequin) and Lauren Michelle (Nedda/Colombina) in Boston Lyric Opera's 2019 production of Leoncavallo's Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

Then there was [Lauren Michelle](/scene/people/lauren-michelle/), who played a much more sympathetic Nedda than usual. She had a beautifully crystalline voice that gave Nedda a fiery, almost youthful energy, and this augmented already playful acting in the first half of the opera to allow the audience to really sympathize with Nedda. She was also playful as Colombina in the play within a play, but she was kept grounded in her fears, particularly with acting that made it clear she was trying to keep the show going after Canio breaks character not even a minute after he enters.

Both were so good that it almost overshadowed [Rafael Rojas](/scene/people/rafael-rojas/) as Canio. This, though, is perhaps more understandable: it was announced at the top of the performance that Rojas was in the process of recovering from a throat infection, and it showed in how Rojas' voice seemed rather quieter than the rest of the cast. This little bout of illness absolutely did not stop Rojas from stopping the show when it came time for him to sing "Vesti la giubba," though: Rojas brought a pathos to the whole aria, and the way he subtly broke down during the aria's conclusion humanized Canio.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693161/media/2019/09/PagBLO2019-PAG-8102743_ygnrjl.jpg){{% /md %}}

<figcaption>(l-r) Rafael Rojas (Canio/Pagliacci), Michael Mayes (Tonio), and Lauren Michelle (Nedda) in Boston Lyric Opera's 2019 production of Leoncavallo's Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

The rest of the cast was rather accomplished in everything, even if they were not quite so prominent as the central three singers. [Tobias Greenhalgh](/scene/people/tobias-greenhalgh/) made for a rather playful Silvio whose voice melded beautifully during his love duet with Michelle. [Omar Najmi](/scene/people/omar-najmi/) managed to make quite a few things out of the normally thankless role of Beppe, and in the few scenes where he had anything important to do he still managed to make a mark as a character trying to keep the show going on.

And then there was the chorus, which was rather excellently managed in terms of staging: they frequently weaved throughout the audience, and they brought a lot of life to the opera's many crowd scenes that made the audience feel they were part of the action in a way that extended what the carnival pre-show did.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693628/media/2019/09/PagBLO2019-PAG-8102581_mgg1da.jpg){{% /md %}}

<figcaption>An acrobat performs in Boston Lyric Opera's 2019 production of Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

Even the production team seemed to find a better way to work in the Steriti Memorial Rink: the acoustical problems that were present in BLO's foray into _Trouble in Tahiti_ were definitely not so prominent here, and while there were still moments where the singers were fighting the orchestra they generally came when the singers were addressing other parts of the circle in the round.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693314/media/2019/09/PagBLO2019-PAG-8LizaVoll_krtdti.jpg){{% /md %}}

<figcaption>Lauren Michelle (Nedda/Colombina) and mar Najmi (Beppe/Harlequin) in Boston Lyric Opera's 2019 production of Leoncavallo's Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

> If BLO had a proper opera house, I scarcely think they would dare to try something so crazy as to open Pagliacci with a full-blown interactive carnival.

There is very little to criticize about this production, but alas there is one big point of contention: the choice to sing the opera mostly in English instead of Italian. This in itself is not a problem, considering that singing the work in English is actually the best way to maintain the immersion. It also helps that only Rojas really struggled with English diction throughout the performance, with everyone else delivering some of the best English diction I have ever heard in opera.

I found it rather immersion-breaking, then, when Nedda and Silvio sang the entire love duet in Italian, switching to that for a reason that I frankly still do not fully understand. Apart from the logistical issue of how the love duet is almost never heard in its complete form and thus likely doesn't have a good performance translation in English, I can only think of one explanation for why this happened.

> This Pagliacci, therefore, is a testament to the effectiveness of BLO's installation operas.

Perhaps they were playing Silvio as a kind of foreigner in the world the production set up, but then one has to ask oneself why Silvio's brief interaction with Nedda just before the show-within-a-show is entirely sung in English. It's a rather confusing choice to commit to singing the opera almost entirely in English, and it took me out of the performance a little.

Fortunately, it did not take me out enough to dull the effect of this fresh new way of presenting opera. I have overheard whispers from older patrons of Boston Lyric Opera that it is a shame that BLO does not have an opera house that it can call home. In light of this performance, I have to say I am inclined to disagree: if BLO had a proper opera house, I scarcely think they would dare to try something so crazy as to open _Pagliacci_ with a full-blown interactive carnival instead of yet another performance of _Cavalleria rusticana_.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1569693113/media/2019/09/PagBLO2019-PAG-8102211_pogvht.jpg){{% /md %}}

<figcaption>in Boston Lyric Opera's 2019 production of Leoncavallo's Pagliacci. Photo: Liza Voll.</figcaption>

</figure>

This _Pagliacci_, therefore, is a testament to the effectiveness of BLO's installation operas, and I cannot wait to see what is to come next.