+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2021-03-01T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1614021540/media/2021/02/sqBLO-2021-USHER-Luna-in-the-Detention-Yard_hv557v.png"
primary_image_credit = "Luna in the detention yard | Boston Lyric Opera's 2021 operabox.tv production of The Fall of the House of Usher. Image: operabox.tv/Boston Lyric Opera."
related_articles = ["articles/la-nilsson-celebrating-birgit-nilsson-at-100.md", "articles/fellow-travelers-a-cathartic-necessary-affair.md"]
related_companies = ["scene/companies/boston-lyric-opera-1.md"]
related_people = []
short_description = "The additions are debatable but the film stands as a considerable artistic achievement and is testament to the resilience of opera in the pandemic era. At its core it is quite a luxury in and of itself."
slug = "overlapping-stories-fall-on-the-house-of-usher"
title = "Overlapping Stories Fall on the House of Usher"
youtube_url = ""

+++
Three years ago I had the pleasure of reviewing the Philip Glass opera, _The Fall of the House of Usher_ when it was presented by the Mannes School of Music/New School. Fifty people were gathered in a single U-shaped row of the intimate Stiefel Concert Hall to hear this stunningly sung and played chamber opera. Employing visual electronics, perspective altering scenery and an orchestra behind a lace curtain, this eerie production had a romantic and gothic allure. Looking back, a live performance like this taking place in a pre-pandemic world was a sublime luxury.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1614022227/media/2021/02/BLO-2021-USHER-The-House-of-Usher_heujxi.jpg){{% /md %}}

<figcaption>The House of Usher. Boston Lyric Opera's 2021 operabox.tv production of The Fall of the House of Usher. Image: operabox.tv/Boston Lyric Opera.</figcaption>  
</figure>

As the pandemic continues to inflict an abundance of uncertainty on performing arts organizations, the Boston Lyric Opera has embraced the opportunities of the virtual with impressive boldness. The company has produced and is currently streaming a [filmed version of _Usher_](https://www.operabox.tv/featured/videos/usher) on operabox.tv through June 30. Attempting to give the work a contemporary perspective, the film takes liberties with Edgar Allan Poe's tale with the insertion of two overlapping storylines.

The additions are debatable but the film stands as a considerable artistic achievement and is testament to the resilience of opera in the pandemic era. At its core it is quite a luxury in and of itself. Film and opera director, James Darrah skillfully situates the opera within the concepts, attending to the momentum that is so vital to Glass' composition. He sustains a swift pace while creating a feeling of confinement throughout the film that contributes to its inexorable destiny.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1614022286/media/2021/02/BLO-2021-USHER-Luna-in-a-Detention-Center-cage_1_joev4s.png){{% /md %}}

<figcaption>Luna in a detention cage. Boston Lyric Opera's 2021 operabox.tv production of The Fall of the House of Usher. Image: operabox.tv/Boston Lyric Opera.</figcaption>  
</figure>

Glass and Poe remain intact and the results are arresting but the total package feels removed from what they and librettist, Arthur Yorkins, had in mind. Utilizing animated drawings, stop-motion animation and archival film clips, the BLO film attempts to recast the story from the point of view of a mute migrant child named Luna who is finding her way from Guatemala City to the United States/Mexico border. Luna encounters an abandoned doll house along the way and imagines Poe's story taking place within.

> The repetitive phrases and shifting layers that so identify a Philip Glass composition take on a resonant and quite seductive air.

On top of that we enter Usher and Luna's experience via the medium of television. A retro console television set is our portal to its influence on a variety of matters from American icons and the post-World War II development of suburbs to the nuclear threat. Though the film is relentlessly inventive, even as it evokes the magnificent collaborations of William Kentridge, the Luna/television concept remains as incongruous as it sounds.

We begin and end somewhere in the vicinity of _The Twilight Zone_ with a gender-bending host gamely played by Sheila Vand. Possessing considerable verve and impressive _avant garde_ credentials, Vand is sly and more than faintly dangerous when called upon to explain the film's three pronged concept. The screenplay by Raúl Santos, something wholly separate from the libretto, places her alongside that relic of a television where she tell us that _Usher_ exists in the darkest reaches of our personal and television fantasies. Would Poe's hints of sexual ambiguity, hallucination and supernatural forces not reach us without this warning? Vand mitigates the heavy handed moment with sardonic glee.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1614022323/media/2021/02/BLO-2021-USHER-William-rests_vpkdqk.jpg){{% /md %}}

<figcaption>William rests. Boston Lyric Opera's 2021 operabox.tv production of The Fall of the House of Usher. Image: operabox.tv/Boston Lyric Opera.</figcaption>  
</figure>

The BLO employs a first-rate recording with its orchestra led by David Angus, who derives lush and propulsive playing from his twelve-person ensemble. The repetitive phrases and shifting layers that so identify a Philip Glass composition take on a resonant and quite seductive air. On that note, this recording would be a welcome addition to the Glass audio catalog, especially considering the fine voices involved.

Tenor Jesse Darden's desperation is palpable as Roderick Usher, maintaining an agile and handsome sound throughout as he internally disintegrates. As Madeline, Roderick's otherworldly sister, Chelsea Basler brings this haunted and haunting being to etherial life. With only the sound of variations on "aah" Basler's bright and fluid soprano creates a mesmerizing and disturbing presence. Daniel Belcher as William, Roderick's friend, sends his rich baritone on a journey from uncertainty to fear as he is engulfed in the darkness of the Ushers. The ominous bass of Jorgeandrés Camargo as the servant and the dark tenor of Christon Carney's rueful physician add to the sense of foreboding.

> The screen then begins to fill will what appears to be strands of Madeline's hair, suddenly a creeping mass.

The grueling hardships of immigration, no matter how this concept fits, are powerfully presented in the animated drawings, especially the inhumanity of parentless children in detention center cages. But Luna's journey and the immigration experience remain outside the opera. Never is it convincing that she is imagining or reflecting the _Usher_ story even when her giant eye peers inside the doll house. Fortunately the visual are so skillfully rendered as to appear unforced, but separate just the same. The dots don't connect but the picture is compelling nonetheless.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1614022361/media/2021/02/BLO-2021-William-on-horse-with-storm_1_ovsfw7.png){{% /md %}}

<figcaption>William on horse with storm. Boston Lyric Opera's 2021 operabox.tv production of The Fall of the House of Usher. Image: operabox.tv/Boston Lyric Opera.</figcaption>  
</figure>

The film clips induce an added sense of anxiety, a commodity with which the opera already teems. Animal testing; duck-and-cover classroom drills; an assembly line of doll parts; and the plundering of the land in the name of growth flash by. They contribute to what the film portrays as our misguided national identity and sense of priorities but the statement is hurly-burly. Their connection to the very private and specific angst of Roderick and Madeline is not so much a mystery as nonexistent.

Opera and concept coalesce with surprising beauty and dramatic impact whenever the stop-motion animation created by the Ancient Order of the Wooden Skull takes over. The animated figures create their own drama which is oddly heightened by the limits of their artificiality. William's intense gaze and stiff posture along with Roderick's hollow stare and weakening presence convey volumes about their characters. Seen in various guises Madeline is an altogether spectral presence, achieving in stop-motion what live performance could not. In their brief appearances the chilling figures of the servant and physician carry their full evocative weight.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1614022394/media/2021/02/BLO-2021-USHER-William-and-Roderick_pok4uk.jpg){{% /md %}}

<figcaption>William and Roderick. Boston Lyric Opera's 2021 operabox.tv production of The Fall of the House of Usher. Image: operabox.tv/Boston Lyric Opera.</figcaption>  
</figure>

When Roderick opens the music box that William presents as a gift he finds JFK, Jackie and Marilyn Monroe twirling about in various combinations. If anything puts a contemporary face on the work this is it—the vision of Camelot corrupted. In a scene that has its origins in the introduction in which Vand, with devious affection, brushes a doll's hair, we see, much to William's dismay, Roderick running a brush through Madeline's. The screen then begins to fill will what appears to be strands of Madeline's hair, suddenly a creeping mass.

> The film is a stimulating excursion into a dark world.

The figures of humans and the exquisitely rendered horse that William rides, share a rhythmic compatibility with Glass' composition. This is not to say that they dance to the music. It's something much more subtle than that. The atmospheric lighting and shadow that grace the stop-motion scenes embellish like the brushstrokes of a master. Linger over the closing credits and appreciate the group of talented artists and technicians who collaborated so seamlessly on this project. They read  the credit roll for a Marvel Studio epic.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1614022423/media/2021/02/BLO-2021-USHER-Luna-and-her-mother-flee_iupghh.png){{% /md %}}

<figcaption>Luna and her mother flee. Boston Lyric Opera's 2021 operabox.tv production of The Fall of the House of Usher. Image: operabox.tv/Boston Lyric Opera.</figcaption>  
</figure>

Providing what might be the largest audience _The Fall of the House of Usher_ has yet to receive, the BLO is offering seven days of access with the purchase of a modest $10.00 ticket at [operabox.tv](https://www.operabox.tv/). With each viewing I admit to taking less issue with the incongruities, or, depending on your point of view, its contemporary perspectives.

Whether you buy into BLO’s three-story renovation or prefer Poe's early 19th-century gothic, you will likely succumb to this _Usher_. The film is a stimulating excursion into a dark world and the performance of Glass' fine chamber opera is an intense and unsettling pleasure.