+++
author = ["authors/michael-calderone.md"]
categories = "Review"
date = "2017-10-01T17:03:00-04:00"
lastmod = "2017-10-01T21:45:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506891758128/2017-10-01---square---01258Ariane-et-Bachus.jpg.jpg"
primary_image_credit = "Ariane et Bachus, Haymarket Opera Company, 2017. Photo: Chuck Osgood Photography."
publishDate = "2017-10-01T21:33:00-04:00"
related_articles = ["articles/littleknown-gems-ariane-et-bachus.md","articles/palpable-chamber-music-haymarket-operas-lenten-oratorio.md"]
related_companies = ["scene/companies/haymarket-opera-company.md"]
related_people = ["scene/people/scott-brunscheen.md","scene/people/david-govertsen.md","scene/people/nathalie-colas.md","scene/people/kristin-knutson.md","scene/people/ryan-de-ryke.md"]
short_description = "A highlight of the performance was the chorus of the furies in Act IV, as summoned by the sorcerer Géralde. Snakes were an effective unifying visual element here: not only were the demons themselves swaying like charmed snakes and brandishing faux snakes, but their Medusa-like wigs and skirts fashioned from wide strips of flowing fabric brought great movement to the scene. The music&#039;s regular flowing triple meter was often unexpectedly interrupted by hemiola hiccups so typical of baroque dance rhythms."
slug = "overdue-for-the-stage-haymarket-opera-companys-ariane-et-bachus"
title = "Overdue for the stage: Haymarket Opera Company&#039;s Ariane et Bachus"
+++

The [Haymarket Opera Company](/scene/companies/haymarket-opera-company/), a Chicago-based period performance troupe devoted to performances of 17th- and 18th-century operas, opened their 2017/18 season on September 30 with a performance of Marin Marais' [*Ariane et Bachus*](http://www.haymarketopera.org/arianeetbachus/). This was Haymarket's largest production to date, and marks the first fully-staged production of *Ariane et Bachus* since the 1696 premiere at the Académie Royale de Musique in Paris. For this production, Haymarket utilized a critical performance score newly prepared by Brazilian scholar Silvana Scarinci and the Laboratory of Early Music (LAMUSA). Ms. Scarinci, an accomplished lutenist, also performed in the orchestra. 

Jean-Baptiste Lully is perhaps the composer most closely associated with French baroque opera, or *tragédies en musique*. Unlike Italian *opera seria* of the time, which utilized a structure alternating recitative and *da capo* aria, *tragédies en musique* take advantage of a variety of solos, duos, trios, dance, and choral numbers in an almost through-composed style to emphasize the drama of the five-act libretto. Lully was a favorite musician of King Louis XIV's court and had a complete monopoly on opera performance in the kingdom. His untimely death in 1687 from an infection on his foot (caused by wounding himself with his own conducting staff) opened up the genre for other composers, such as Marc-Antoine Charpentier and Marin Marais. The sequence of arias, duos, choral and dance sections in *Ariane et Bachus* is exemplary of Lullian *tragédies en musique*, and the libretto by Saint-Jean follows the Greek myth of the same name.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506892052267/2017-10-01---00644Ariane-et-Bachus.jpg.jpg)
<figcaption>*Ariane et Bachus*, Haymarket Opera Company, 2017. Photo: Chuck Osgood Photography.</figcaption>
</figure>

Director and choreographer Sarah Edgar is a specialist in 18th-century stage performance, and says she is inspired as a director by the postures and scenes found in baroque sculpture and painting. This is evident in the staging: the singers hold themselves gracefully upright and move deliberately, and the painterly composition of artists on stage highlight the most important aspects of the drama. Brisk bodily action is reserved for the characters' most impassioned utterances, increasing the dramatic thrust that occurs at cadences. These performances also mark the debut of the Haymarket Opera Company Ballet, whose five dancers moved musically and were a lively and elegance presence on stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506892088872/2017-10-01---01335Ariane-et-Bachus.jpg.jpg)
<figcaption>*Ariane et Bachus*, Haymarket Opera Company, 2017. Photo: Chuck Osgood Photography.</figcaption>
</figure>

While the staging is often physically restrained, this performance was not dry by any means. Soprano [Kristin Knutson](/scene/people/kristin-knutson/) exhibited a balance of strong emotions and austerity in her portrayal of the abandoned Ariane. Her clarion voice blended richly with that of soprano [Nathalie Colas](/scene/people/nathalie-colas/), who sang the role of Ariane's confidante Corcine; their duets were lovely. Baritone [Ryan de Ryke](/scene/people/ryan-de-ryke/) and bass-baritone David Govertsen brought a husky vigor to the music of Adraste and Géralde, companions who often shared the stage. As a blushing Bacchus, tenor [Scott Brunscheen](/scene/people/scott-brunscheen/) sang with nuance and boyish charm. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506892119675/2017-10-01---01282Ariane-et-Bachus.jpg.jpg)
<figcaption>*Ariane et Bachus*, Haymarket Opera Company, 2017. Photo: Chuck Osgood Photography.</figcaption>
</figure>

A highlight of the performance was the chorus of the furies in Act IV, as summoned by the sorcerer Géralde. Snakes were an effective unifying visual element here: not only were the demons themselves swaying like charmed snakes and brandishing faux snakes, but their Medusa-like wigs and skirts fashioned from wide strips of flowing fabric brought great movement to the scene. The music's regular flowing triple meter was often unexpectedly interrupted by hemiola hiccups so typical of baroque dance rhythms. Chorus Master Donald Nally deserves high praise for his well-balanced and rhythmically deft choristers, both here and throughout the opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506892199608/2017-10-01---01303Ariane-et-Bachus.jpg.jpg)
<figcaption>*Ariane et Bachus*, Haymarket Opera Company, 2017. Photo: Chuck Osgood Photography.</figcaption>
</figure>

The orchestra, led by Music Director Craig Trompeter, played with buoyancy and virtuosity. Jory Vinikour's florid embellishments from the harpsichord sounded particularly innate and effortless. During the supernatural and storm scenes in this opera I would have appreciated the fuller sound of a larger orchestra (the orchestra was a lean 20 players, with 11 in the string section), but this was a minor detractor from a very fine evening of music and theater. 

>[Ariane et Bachus](http://www.haymarketopera.org/arianeetbachus/) runs through October 3rd at Studebaker Theater. For details and tickets, follow our box office links below.
