+++
author = ["authors/michael-pecak.md"]
categories = "Review"
date = "2017-11-08T09:31:00-05:00"
lastmod = "2017-11-08T09:53:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510151745442/2017-11-08---square---PaSO-Hanted-Manor---Return-of-Hunters.jpg.jpg"
publishDate = "2017-11-08T09:53:00-05:00"
related_articles = ["articles/in-review-stiffelio.md","articles/in-review-bluebeards-castle-erwartung.md","articles/in-review-boris-godunov.md"]
short_description = "I must confess a certain bias on my part for this opera. As both a Chicagoan and fellow Pole, this opera has had a special place in my heart since my childhood. I grew up with its melodies and rhythms and came to appreciate its historical significance in Polish Saturday School. Naturally, I was thrilled to learn of a Chicago production."
slug = "overdue-for-a-chicago-performance-the-haunted-manor"
title = "Overdue for a Chicago performance: The Haunted Manor"
+++

There are certain opera productions that, once planned and announced, ride a wave of excitement, promotion and hype, promising a magnificent splash on opening night: an event not to be missed. Such was the case with Stanisław Moniuszko's (1819-1872) *Straszny Dwór* (*The Haunted Manor*), put on at Chicago's Copernicus Center by the Paderewski Symphony Orchestra, Chorus, and invited guest singers from Poland. 

Over its roughly twenty-year presence in Chicago, PaSO, under the General Directorship of Barbara Bilszta and Musical Directorship of Wojciech Niewrzoł, has established itself as the premiere cultural representative for this city's massive Polish community. The organization presents regular orchestral concerts, collaborates with local Polish arts and dance groups, invites important artists from the motherland (composers Wojciech Kilar and Krzysztof Penderecki as well as pianists Piotr Paleczny and Janusz Olejniczak to name a few) and also includes a music academy for youngsters—all with the aim of serving and promoting Polish culture abroad. So it makes perfect sense for this opera to be performed by this orchestra in this city.
 
That said, the weekend's run of *The Haunted Manor* had all the buzz of a true événement. Held up as the great "Polish National Opera,” Moniuszko's masterpiece is a repertory staple in opera houses across Poland. Elsewhere, it is rarely performed. Part of the reason may very well be the exportability of the notoriously complex and consonant-heavy Polish language. But the language itself is a crucial point. Poland ceased to be a country in 1795 and during the next century, when its citizens underwent a process of ever-increasing Russification and Germanization, merely communicating in Polish was a revolutionary act. Language became central in preserving the country's past (however real or romanticized) and in expressing its hopes for the future. 

For Polish composers of the nineteenth century, this meant aspiring to compose a "Great" Polish opera, rooted in Polish history, and with a Polish libretto. Fryderyk Chopin famously declined insistent requests by family and colleagues to try his hand at grand opera. But while Chopin preferred to create more intimate and personalized worlds in his piano works, his slightly younger compatriot, Moniuszko, emphatically embraced the theater and came to be recognized as "the father" of Polish national opera with his *The Haunted Manor* hailed as the quintessential Polish work in the genre.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510151794334/2017-11-08---PaSO-Hanted-Manor---Hanna---Anna-Parysz%2C-Stefan---Rafal-Bartminski%2C-Zbigniew---Karol-Skwara%2C-Jadwiga----Katrzyna-Szymkowiak---.jpg.jpg)
<figcaption>Anna Parysz (Hannah), Rafal Bartminsky (Stefan), Karol Swkara (Zbigniew), and Katrzyna Szymkowiak (Jadwiga) in *The Haunted Manor*, Paderewski Symphony Orchestra and Chorus, 2017. Photo: Krzysztof Babiracki.</figcaption>
</figure>
 
Beloved by Poles — then as now — for its overt patriotism, folk-inflected melodies, catchy choruses, and traditional Polish dance numbers, Moniuszko's score was quickly blocked by the Russian censor when it premiered in Warsaw in 1865. After only three performances it was never performed publicly again during the composer's lifetime, yet its impact on the Polish collective consciousness was immediate and long-lasting.
 
The story revolves around two brothers, Zbigniew and Stefan, who, having retired from military life, pledge themselves nonetheless to bachelorhood and service to country. Their plan is to return to their rural familial plots, but to always "have arms and heart at the ready for the fatherland (dla ojczyzny!)." As significant others would inhibit their vigilance and liberty, they swear off women and spouses. "There are no maidens in your hut," sing the brothers' comrades in the opening swashbuckling chorus. 

Of course, things change once they meet the eligible young daughters of their old family friend, Miecznik (the Sword Bearer). Hanna and Jadwiga live with their father in a manor known for its eerie reputation. After a complementary chorus of servant-girls singing about that most perilous of pre-twentieth-century female fates — spinsterhood — the sisters attempt to divine who their future husbands might be by reading the shapes in melted wax.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510152487477/2017-11-08---Hanna---Anna-Parysz%2C-Damazy---Jacek-Ornafa.jpg.jpg)
<figcaption>Anna Prysz (Hannah) and Jacek Ornafa (Damazy) in *The Haunted Manor*, Paderewski Symphony Orchestra and Chorus, 2017. Photo: Krzysztof Babiracki.</figcaption>
</figure>

Images of helmets and swords appear, much to the chagrin of Damazy, a foppish barrister who fancies himself the best suitor. Damazy conspires with Cześnikowa, the brothers' headstrong and scheming aunt, who has designs of her own for the boys' love-lives. As the patriarch of the estate, Miecznik makes his demands unequivocal: the men worthy of his daughters' hands must be courageous, virtuous, observant of national traditions, skilled marksmen, as well "devoted to God, family, and country." The deeper underlying message of his wonderful Act-2 aria — written, moreover, in characteristic polonaise rhythm — is unmistakable. 

Suspicious of the two brothers, Aunt Cześnikowa, Damazy, and a slew of supporting characters determine to pull the rug from beneath the feet of Stefan and Zbigniew through some calculated diablerie. Mysterious clocks, talking paintings, and mistakes of identity comprise much of Acts 3 and 4, thus superbly balancing an inherently patriotic-moralistic plot with elements of romance and comedy.
 
It must be conceded that, for all its fine duets and ensemble numbers, this is a rather man-centric opera with the most important and memorable arias belonging to Stefan and Miecznik. PaSO's production this past weekend featured tenor Rafał Bartmiński in the former role and baritone Leszek Skrla in the latter. For their artistry and experience, both singers were the decided standouts of the show. Both are regulars of Poland's main-stages and veterans of their respective roles in *The Haunted Manor*. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510152506944/2017-11-08---Leszek-Skrla---Miecznik.jpg.jpg)
<figcaption>Leszek Skrla (Miecznik) in *The Haunted Manor*, Paderewski Symphony Orchestra and Chorus, 2017. Photo: Krzysztof Babiracki.</figcaption>
</figure>

Much like Miecznik's aria mentioned above, Stefan's aria in Act 3 is one of the emotional pillars of the opera. Known in Polish as "Aria z kurantem" ("Chimes Aria"), this piece plays on an idiomatically Polish variety of nostalgia, or "żal." In the middle of the night, the chimes of an aged malfunctioning clock in the manor mysteriously begin playing again. Their tune is an old-fashioned eight-bar polonaise, but for Stefan it's unnervingly familiar and unleashes a flood of memories from his childhood: of his father teaching him and his brother the basics of swordsmanship, of his mother watching over them as they played among trees, of his father going away to war, of his mother praying for his safe return. Bartmiński captured the latent symbolism with a powerfully projecting, yet captivatingly expressive tenor voice, delivered with the conviction of a native son. See an equally compelling recital performance of this aria by Bartmiński here:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/FH5rNbJOHxc" frameborder="0" gesture="media" allowfullscreen></iframe>
</figure>

As Miecznik, Skrla commanded the stage with a voice and presence worthy of great Verdian baritones. (Indeed, if his available YouTube clips are any indication, he is a superb *Rigoletto*!) As the most senior and established member of this production's cast, Skrla's experience was particularly welcome during moments of musical disconnect between stage and pit. A couple of the ensemble pieces noticeably lacked cohesion, but were held together thanks to Skrla's assertiveness. His is a rich, dark, and booming voice: perfect for the pointed gravitas of his arias, including the big one in Act 2. There was a charge in Skrla's voice as he sang the words, "devoted to God, family, and country," looking directly at the audience, which rewarded him with an affectionate ovation.
 
Singing the roles of Hanna and Jadwiga were, respectively, soprano Anna Parysz and mezzo Katarzyna Szymkowiak, both accomplished up-and-comers on Poland's operatic scene. Together they were irresistibly charming as the mischievous sisters, especially in the Act 3 scene where they taunt their unsuspecting love-interests by posing as portraits of themselves. To Hanna's firecracker Act 4 recitative & aria, Parysz brought impressive clarity and shape to the dizzying sixteenth-note passages while never losing the rhythmic crisp so crucial to Polish melodies. Szymkowiak was memorable for her smooth honeyed mezzo in Jadwiga's plaintive Dumka. Keep your eyes and ears on these two — the world's stages will be beckoning.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510152497992/2017-11-08---Marta-Stachyra---Czesnikowa.jpg.jpg)
<figcaption>Marta Stachyra (Czesnikowa) in *The Haunted Manor*, Paderewski Symphony Orchestra and Chorus, 2017. Photo: Krzysztof Babiracki.</figcaption>
</figure>
 
The remainder of the cast comprised young singers in varying stages of their development. Tenor Jacek Ornafa was a crowd favorite, playing the part of the conniving Damazy with the zeal of a Disney henchman. Mezzo Marta Stachyra, as the machinating Aunt Cześnikowa, was aggravating in all the right ways. Other invited guests for this production included an excellent supporting choir from Warsaw's F. Chopin University of Music (formerly the Warsaw Conservatory) as well as Chicago-based Polish folk-dance companies WICI and Lajkonik. Much like in French Baroque opera, dance is essential to Polish opera (and Polish culture generally). The two troupes combined for this run of *The Haunted Manor* were exquisitely choreographed in the several traditional Polish dances, including the Kujawiak and especially this opera's famous concluding Mazur. The costumes, designed by Barbara Kędzierska and based on traditional nineteenth-century Polish garb, complemented both the aristocratic and the rustic elements of the score. Hunting caps were suitably plumed and skirts twirled in a vibrant kaleidoscope of color.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1510152515653/2017-11-08---PaSO-Hanted-Manor---Mazur---WICI-Theatre-of-Dance-and-PaSO-Chorus.jpg.jpg)
<figcaption>A scene from *The Haunted Manor*, Paderewski Symphony Orchestra and Chorus, 2017. Photo: Krzysztof Babiracki.</figcaption>
</figure>
 
I must confess a certain bias on my part for this opera. As both a Chicagoan and fellow Pole, this opera has had a special place in my heart since my childhood. I grew up with its melodies and rhythms and came to appreciate its historical significance in Polish Saturday School. Naturally, I was thrilled to learn of a Chicago production. Though there were components of this show that I found underwhelming and lackluster, I and the packed Copernicus Center audience applauded enthusiastically nonetheless because it happened. Musically, Moniuszko combines a sense of Verdian lyricism with a Weber-ian romantic flare and feel for narrative that makes for engrossing opera. 

And singers take note: there are some fantastic arias here with which to spice up an audition package or recital program. I hope professional companies in the U.S. will soon embrace this work into their repertoires.

>For more from the Paderewski Symphony Orchestra, visit their [website](http://www.pasochicago.org/).
