+++
author = ["authors/jenna.md"]
categories = "Review"
date = 2021-09-27T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = "Opera Theatre of St. Louis's 2021 Outdoor Festival is available to stream through September 30."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1632319222/media/2021/09/sqOTSL_hfj1m7.jpg"
primary_image_credit = "Jarrett Porter as Neil Armstrong in Steven Mackey and Rinde Eckert's Moon Tea, Opera Theatre of St. Louis's New Works, Bold Voices Lab, 2021. Photo: Eric Woolsey."
related_articles = ["articles/happening-now-otsl-s-digital-2021.md"]
related_companies = ["scene/companies/opera-theatre-of-st-louis.md"]
related_people = ["scene/people/joshua-blue.md", "scene/people/patricia-racette.md", "scene/people/monica-dewey.md", "scene/people/markel-reed.md", "scene/people/nicole-cabell.md", "scene/people/will-liverman.md"]
short_description = "The Tongue & The Lash features some of the night's best singing. Markel Reed as Baldwin orates with a steely baritone that comes with some bite; tenor Jonathan Johnson exudes an easy power that's slightly unnerving — even a bit colonialist — in his portrayal of Buckley, fan of racial segregation."
slug = "before-its-gone-gems-out-of-opera-theatre-of-st-louis"
title = "Before it's gone: gems out of Opera Theatre of St. Louis"
youtube_url = ""

+++
These days, small wins are worth a lot — and I count it as a small win that I can watch Opera Theatre of St. Louis's 2021 Outdoor Festival from way up here in Canada.

The Festival, which includes six performance events from OTSL's 2021 season, is [available to stream](https://opera-stl.org/streaming) through September 30, and I'm officially recommending it. It's a great mix of standards (_Gianni Schicchi_), near-standards (_La voix humaine_), rarities (_Highway 1, U.S.A._), and world premieres ([_New Works, Bold Voices Lab_](https://opera-stl.org/nwbv-lab)).

If I'm to pick a favourite, I'm torn between the three actually fantastic new operas in the _New Works_ showcase, and the 1940s gem by William Grant Still, [_Highway 1, U.S.A._](https://opera-stl.org/highway) Both productions fit perfectly with OTSL's mission to champion new works and be a part of opera's future; I love when a great cause comes with great discoveries, too.

_Highway 1, U.S.A._ draws us in with its excellent cast, headlined by baritone [Will Liverman](/spotlight-on-will-liverman/) and soprano [Nicole Cabell](/talking-with-singers-nicole-cabell/). Right away I was pulled into the story, which as far as opera plots go, starts off fairly conflict-free; usually when I'm pulled in, it's because of the artists. Liverman and Cabell show a natural warmth for each other as Bob and Mary; they play a married couple who love and respect each other, and Mary shows her love by setting high standards for Bob and his troubled brother, Nate (Christian Mark Gibbs).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632319094/media/2021/09/OTSL_H1_1_uuripb.jpg){{% /md %}}

<figcaption>Nicole Cabell as Mary and Will Liverman as Bob in William Grant Still's Highway 1, U.S.A., Opera Theatre of St. Louis, 2021. Photo: Eric Woolsey.</figcaption>

</figure>

Still's score is gorgeous, a mix of luscious sounds and matter-of-fact text setting. Liverman shines in his heroic top range, delivering crisp English text that sounds easy; Cabell shows a thousand colours with her voice, joking and pleading and loving with her soprano. And interestingly, there's a clear distinction between Liverman's baritone and Christian Mark Gibbs as Nate.

The production by Ron Himes works for me. It's a fantastic show of 60s fashion, with great hats and fun florals and bright shoes. And really, who doesn't love gazing over every detail of a busy kitchen, filled with wallpaper and cafe curtains? Just like Still's score, Himes stays out of the way of this story, letting it tumble forward with natural ease.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632319126/media/2021/09/OTSL_H1_2_mdmzyz.jpg){{% /md %}}

<figcaption>Angel Riley as Soprano Solo #2, Andrew René as Sheriff, Lindsey Reynolds as Soprano Solo #1, Terrence Chin-Loy as Tenor Solo, Tesia Kwarteng as Alto/Mezzo Solo, Geoffrey Peterson as Baritone Solo/Doctor, and Rehanna Thelwell as Aunt Lou in William Grant Still's Highway 1, U.S.A., Opera Theatre of St. Louis, 2021. Photo: Eric Woolsey.</figcaption>

</figure>

_Highway 1, U.S.A._ sits beautifully in the American operatic canon. It nods to its time, with the music leaning toward the sounds of Richard Rogers and George Gershwin, but boasts some fantastic ensemble singing and an earthy approach to musical storytelling. I'm so thrilled that OTSL put this up. It should go elsewhere, quickly.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632318572/media/2021/09/OTSL_Schicchi_1_w70oke.jpg){{% /md %}}

<figcaption>(l-r) Nathan Stark as Simone, Joshua Blue as Rinuccio, Schyler Vargas as Marco, Meghan Kasanders as Nella, Helen Zhibing Huang as La Ciesca, La'Shelle Q. Allen as Zita, Jermaine Smith as Gherardo, Levi Hernandez as Gianni Schicchi pretending to be Buoso Donati, Bianca Orsi as Gherardino, and Rob McGinness as Betto in Gianni Schicchi, Opera Theatre of St. Louis, 2021.. Photo: Eric Woolsey.</figcaption>

</figure>

Among the more standard fare are Puccini's only comedy, [_Gianni Schicchi_](https://opera-stl.org/gianni), and Poulenc's now-ubiquitous one-woman-opera, [_La voix humaine_](https://opera-stl.org/voix). The _Schicchi_, directed by Seán Curran, is everything you want in that show: excellent ensemble work and busy comedic scenes that border on campy, and show-stopping singing. [Joshua Blue](/scene/people/joshua-blue/) is a standout as Rinuccio; with the ringing colours in his voice, he's no doubt one to watch.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632318629/media/2021/09/OTSL_Schicchi_2_bagpp0.jpg){{% /md %}}

<figcaption>Joshua Blue as Rinuccio and Elena Villalón as Lauretta in Gianni Schicchi, Opera Theatre of St. Louis. Photo: Eric Woolsey.</figcaption>

</figure>

The _Voix humaine_ is also sort of everything we want in Poulenc's opera, though it's arguably harder to pin down what a "traditional" _Voix humaine_ would look like. In my opinion, it certainly looks like Patricia Racette draped in silk, fretting into a vintage rotary phone, against a backdrop of crushed velvet, ornate fireplace mantels, and chaise lounges. I wasn't in love with the English translation, but Racette handles it well and she's a stunning actress.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632319021/media/2021/09/OTSL_Voix_1_onnsxw.jpg){{% /md %}}

<figcaption>Patricia Racette as Elle in Poulenc's La voix humaine, Opera Theatre of St. Louis, 2021. Photo: Eric Woolsey.</figcaption>

</figure>

I've seen this opera several times and I'm always intrigued; maybe it was the luxurious setting, the obviously-rich woman obsessed with her French lover, but I found it hard to sympathise with Elle. In one sense, _La voix humaine_ is the perfect pandemic opera because it deals with isolation and the limitations of technology (I highly recommend [Isaiah Bell's treatment for City Opera Vancouver](https://youtu.be/--Fqi-yCesQ)). But on the other hand, when the world is in a health crisis, it's hard to spare the pity for a woman who's feeling some very foreseeable consequences of adultery.

It was OTSL's [_New Works, Bold Voices Lab_](https://opera-stl.org/nwbv-lab) that most stayed with me after viewing. Three short world premieres were unveiled, and it was one of those rare moments in new-opera-land where all the pieces are high-quality, attention-grabbing works. _On the Edge_, by Laura Carpman and Taura Stinson, is a snapshot of life at home during a pandemic, a single mom stretched way too thin, flanked by three children going through the motions of remote learning. [Monica Dewey](/scene/people/monica-dewey/) shows off stellar vocal chops, and Carpman's score achieves an astonishing shift from a picture of chaos to commentary on the importance of love and solidarity.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632318892/media/2021/09/OTSL_NWBV_2_fxyqqd.jpg){{% /md %}}

<figcaption>Calvin Griffin as Teacher 2/Grandma/Father, Monica Dewey as Single Mom/Mama/Mom, Mack Wolz as Teacher 1/Kadin/Mommy/Daughter and Melody Wilson as Kyra/Son/Son in Laura Karpman and Taura Stinson's On the Edge, Opera Theatre of St. Louis's New Works, Bold Voices Lab, 2021. Photo: Eric Woolsey.</figcaption>

</figure>

Steven Mackey and Rinde Eckert's _Moon Tea_ is an awesome bit of fantastical history, reimagining a meeting between the British Royals with the astronauts of Apollo 11. Again, Dewey shines here as Queen Elizabeth II.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632318927/media/2021/09/OTSL_NWBV_3_jlc6dt.jpg){{% /md %}}

<figcaption>Monica Dewey as Queen Elizabeth and Jonathan Johnson as Prince Philip in Steven Mackey and Rinde Eckert's Moon Tea, Opera Theatre of St. Louis's New Works, Bold Voices Lab, 2021. Photo: Eric Woolsey</figcaption>

</figure>

And Damien Sneed and Karen Chilton's _The Tongue & The Lash_ is a stunning look at America's history with racism, an operatic setting of the notorious [1965 debate](https://www.theatlantic.com/entertainment/archive/2019/12/james-baldwin-william-f-buckley-debate/602695/) between James Baldwin and William F. Buckley which argued the motion that the American is at the expense of black Americans. _The Tongue & The Lash_ features some of the night's best singing. [Markel Reed](/scene/people/markel-reed/) as Baldwin orates with a steely baritone that comes with some bite; tenor [Jonathan Johnson](/scene/people/jonathan-johnson/) exudes an easy power that's slightly unnerving — even a bit colonialist — in his portrayal of Buckley, fan of racial segregation. Sneed's score throws in a brilliant moment, sliding swiftly into the blues in a musical nod to the reality of Black American culture, the undeniably present group of people who were so dehumanized.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1632318671/media/2021/09/OTSL_NewWorks_1_pnuhx7.jpg){{% /md %}}

<figcaption>Markel Reed as James Baldwin and Jonathan Johnson as William F. Buckley Jr. in Damien Sneed and Karen Chilton’s The Tongue & The Lash, Opera Theatre of St. Louis's New Works, Bold Voices Lab, 2021. Photo: Eric Woolsey.</figcaption>

</figure>