+++
author = ["authors/jenna.md","authors/greg.md"]
categories = "Review"
date = "2015-04-10T20:10:00-04:00"
lastmod = "2015-04-13T16:16:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428711043690/Orpheus_Fotor.jpg.jpg"
publishDate = "2015-04-10T20:10:00-04:00"
related_articles = ["articles/in-review-opera-ateliers-armide.md"]
related_companies = ["scene/companies/opera-atelier.md"]
related_people = ["scene/people/meghan-lindsay.md","scene/people/peggy-kriha-dye.md","scene/people/mireille-lebel.md"]
short_description = "A collaborative review with contributor Greg Finney of Opera Atelier production of Orpheus &amp; Eurydice at Opera Atelier."
slug = "orpheus-eurydice-opera-atelier"
title = "In review: Orpheus &amp; Eurydice at Opera Atelier"
+++

**Jenna:** Opera Atelier has opened its run of Gluck's [_Orpheus and Eurydice_](http://www.operaatelier.com/season/14-15-season/), set to play until April 19th at the Elgin Theatre. OA presented Berlioz's version of the score, which is one of the company's first dips into 19th-century repertoire, tangental as the dip may be. I'm not hugely familiar with the piece, and so the differences in Berlioz's version weren't apparent to me as a listener; I'd be curious to compare the scores. I do know that Gluck's score has moments of stunning beauty, and really neat orchestra effects (perhaps augmented by Berlioz) that sound ahead of their time.

**Jenna:** The cast of singers is tiny; [Peggy Kriha Dye](https://www.facebook.com/peggykrihadyeofficial) sang a lovely and clear Eurydice, [Meghan Lindsay](http://www.meghanlindsay.com/) flaunted a bright sound and a trouser-role affect as Amour, and mezzo-soprano [Mireille Lebel](http://www.mireillelebel.com/) returned Opera Atelier as Orpheus. Lebel has a sweet sound, making me think of roles like Cherubino and Annio (which are on her résumé); unfortunately, she didn't carry well in the hall. The role seemed very low for her (and most mezzos today, I imagine), and we lost a lot of the affect in Gluck's low writing for Orpheus. Lebel sounded much more comfortable in a higher tessitura, but I was missing the clarity in the coloratura passages. I wouldn't mind hearing Lebel in a different role; I've found that Gluck roles tend to lie in the cracks between the divisions of the voice types of today. Peggy Kriha Dye sang Eurydice with beautiful connection between voice and body. She has a single, extended scene in which she goes from excitement over seeing Orpheus, to suspicion at his lack of eye contact, to despair. I thought she paced it beautifully and always used her voice as her primary tool. Meghan Lindsay was spunky as Amour, and hers was some of the most interesting music of the night. Trouser roles for a soprano are decidedly rare, but Meghan was strutting around with great masculine energy, and full of youth.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428865673577/Orpheus5_Fotor.jpg.jpg)
<figcaption>Mireille Lebel (Orpheus), Peggy Kriha Dye (Eurydice) and Meghan Lindsay (Amour). Photo by Bruce Zinger.</figcaption>
</figure>


**Greg:** I want to preface everything I say with this: I'm a huge Atelier fan, a lot of my friends and colleagues work with them and I have loved a lot of their shows in the past. Unfortunately for me _Orpheus and Eurydice_ falls flat. Not because anything was anyone's fault, but because I felt the fight to keep the ancient form and traditions worked against any modern sensibility applied to the staging, characterizations, or technical and design choices.

**Greg:** The singing, as per usual, was fantastic, although I found that the house was a little unforgiving to Ms. Lebel's Orpheus. She has an interesting colour, a stellar chest voice, a lovely bloom over the top and and a résumé to die for; I just wish I could have heard more of her, especially her coloratura and her mid-voice. I felt at times she may have been struggling with the material, as some of the melismas got a little cloudy in the turns and mordents. Excellent trouser characterization, however I didn't feel connected to Orpheus' loss, and found myself struggling to believe that the gods would oblige his request. Meghan Lindsay as Amour was charming, devilish, and sang with a light, clear soprano that reminded me of champagne. Her characterization of Amour as sort of a playboy, man-about-town was a lovely choice to help contrast the moment of truth in the finale ultimo where Eurydice is revived. Peggy Kriha-Dye was stunning. A lovely agile, feminine soprano who utilizes all the gifts she was given to help add the drama needed for such a role. I felt she was by far the strongest actor in the trio and her work after intermission when reunited with Orpheus was what I was waiting for all night. Strife, sadness and pain oozed out of this effortless soprano that sounded quite large. I feel like this may be the first time I've seen/heard Peggy, but I can assure you it won't be the last. The chorus sang the French repertoire quite well, although there were a few tempo discrepancies between the pit and the choir loft - an affliction with which I can totally relate when there's that much distance between you and the pit.

**Jenna:** The production, I found frustrating. I often struggle with the stylization of Artistic Director [Marshall Pynkoski](http://www.operaatelier.com/about/creative-team/)'s direction, which make use of Baroque gesture and dramatic affectation to tell the story. I think it comes down simply to taste on my end, but I found that this production of _Orpheus_ highlighted my reasons for apprehension. The gestures and poses seemed particularly devoid of motivation; they simply happened in succession, like gesture-by-numbers. The singers were physically committed to their poses, and were always beautiful; but it didn't always feel genuine. I understand what the gestures mean, but the irony here was that the reason for the affectation was covered up by the stylized production. The _human_ parts of this story, like Orpheus' passage through various stages of grief, and Eurydice's very personal insecurities, are what keeps this myth a relevant story. For me, the aesthetic didn't allow for human qualities, and so the expressions of grief or joy seemed disingenuous.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428865853817/Orpheus2_Fotor.jpg.jpg)
<figcaption>Mireille Lebel (Orpheus) with Artists of Atelier Ballet. Photo by Bruce Zinger.</figcaption>
</figure>

**Greg:** I felt like the whole production may have been rushed in its assembly. Marshall's staging, which can be formulaic due to the demands of the house, is not designed for opera, and it's a little unforgiving in reminding you of that. The solution is to stage everything along the proscenium arch - which is also how they would have done it in the 17th and 18th centuries. The problem is it limits the angles in which the singers can place themselves so that the voice can still travel predominantly into the house. I find Pynkoski's other productions are much better at hiding this formula among the dramatic intent of the narrative. The two ladies in pants roles however gave a masterclass in 18th century masculinity. It was quite impressive.

**Greg:** The set design was the usual Gerard Gauci-Baroque-painting-inspired loveliness. The only thing I longed for was more of a distinction between the temple of Eurydice's monument and the gates of Hades - unfortunately called "Hell" a few times in the surtitles (but we'll forgive a poetic translation this time, even if it muddies up the myth). The sets were lovely and stunning, I just wish there was a way they could change them without dropping the curtain 4 times. It's probably my "classical theatre" showing, but I have a real problem with curtains coming down between overture and intermission (and also from intermission to "curtain" - the theatre term for the end of the show). The lighting was interesting. There were moments of magic, but I felt the whole thing a little too dark in the wrong places. Often times I found the trio of ladies' faces difficult to see.

**Jenna:** The Opera Atelier Ballet were beautiful as always, and they had lots of stage time in this production. Pynkoski mentioned in his pre-show talk that Berlioz had left the final ballet out of his version, stating that he would have kept them, had he the resources to perform them. Artistic Director Jeannette Lajeunesse Zingg gave the task to the Atelier dancers, and it was a great opportunity to show off more of their individual techniques. I'll leave the details to Greg, since he's the one with the dance background.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428865919503/Orpheus3_Fotor.jpg.jpg)
<figcaption>Artists of Atelier Ballet. Photo by Bruce Zinger.</figcaption>
</figure>

**Greg:** I'm a big fan of the OA Ballet. These dancers do some incredible work. The period choreography, the costumes, the shoes all fabulous. That being said, I felt this production was a little _over_ choreographed and maybe a little over populated. I lost a lot of footwork amongst all the bodies and there were moments of spacing issues, and a few of the men seemed a little tentative on the transitions - this could be chalked up to nerves. There were a few debuts noted in the program. I do have to give honourable mention to the second _pas-de-deux_ in the finale. It was athletic, graceful, tasteful and well executed. The young couple who danced it, Julia Sedgwick and Dominic Who, have a lovely future ahead of them on the stage.

**Jenna:** The Tafelmusik Orchestra sounded spectacular throughout the night. Maestro Fallis let the drama bubble through Gluck's score, which seemed full of sudden and fleeting moments of beauty; the orchestra made sure we heard all of them. They were particularly great at managing the balance issues with the low tessitura for Orpheus

**Greg:** Tafelmusik is awesome. Full Stop.

**Jenna:** The production ended bizarrely, turning on a dime from a dark story of grief, to a happy ending that includes glitter, cannons of confetti, and the Atelier Ballet carrying cheerleader-type lettered placards that spelled out "L'amour triomphe," and later "#OAOrpheus." Yep. I do like that Pynkoski always has a sense of humour in his productions, be it subtle or bold. I often feel that OA productions present all the elements of opera - the music, the sets and costumes, the dancing, the physical aesthetic - in an undoubtedly beautiful and skilful way; yet these elements seem disconnected, as though they're happening beside each other on the same stage. I've seen Pynkoski's aesthetic work brilliantly in previous OA productions, but the organicism was missing from this _Orpheus_.

**Greg:** Overall it's an enjoyable evening out, I would go see it if I were you. Although the application of social media branding left a bit of a sour taste in my mouth, I was clearly in the minority feeling that way. The audience loved it.
