+++
author = ["authors/hannah-de-priest.md"]
categories = "Review"
date = "2017-09-25T10:00:00-04:00"
lastmod = "2017-09-25T13:00:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348554980/2017-09-24---square---Andriana-Chuchman_Dmitry-Korchak_The-Joffrey-Ballet_ORPHEE-ET-EURYDICE_LYR170915_1195_c.Todd-Rosenberg.jpg.jpg"
primary_image_credit = "Andriana Chuchman, Dmitry Korchak & the Joffrey Ballet, Orphée et Eurydice, LOC, 2017. Photo: Todd Rosenberg."
publishDate = "2017-09-25T10:28:00-04:00"
related_articles = ["articles/in-review-stars-of-lyric-opera.md","articles/the-positive-impact-of-community-created-performances.md"]
related_companies = ["scene/companies/lyric-opera-of-chicago.md"]
related_people = ["scene/people/dmitry-korchak.md","scene/people/lauren-snouffer.md","scene/people/andriana-chuchman.md"]
short_description = "Tacking happy endings onto tellings of traditionally tragic myths in this way was very much en vogue in the eighteenth-century. But for Neumeier&#039;s concept-driven production, while the musical substance remains the same, the story&#039;s denouement is rendered far more devastating than even the myth&#039;s usual tragic end."
slug = "orphee"
title = "Organic elegance: Orphée et Eurydice in Chicago"
+++

The Lyric Opera of Chicago opened its 2017-2018 season this weekend with a stunning new production of Christoph Gluck's [*Orphée et Eurydice*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/orphee-et-eurydice-opera-tickets#./Meet%20the%20Artists?&_suid=1506347404981002233772685965474) that constitutes an historic collaboration with Joffrey Ballet. With much of the audience dressed to the nines for the post-performance [Opera Ball](https://www.lyricopera.org/support/operaball2017), it was a night of high glamour and beauty all around.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348703384/2017-09-24---The-Joffrey-Ballet_Dmitry-Korchak_ORPHEE-ET-EURYDICE_LYR170915_0479_c.Todd-Rosenberg.jpg.jpg)
<figcaption>The Joffrey Ballet and Dmitry Korchak as Orphée in *Orphée et Eurydice*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

And what better way to fête the opening of an opera company's season than with a sumptuous telling of that immortal myth, Orphée? Throughout history, the story of Orfeo and his Eurydice has been told and re-told by dramatists and composers under many guises and with various twists and turns. Gluck re-visited the myth multiple times over his long career; the version of his *Orphée* currently on at LOC is from 1744 when Gluck re-worked his earlier *Orfeo ed Euridice* for the Parisian stage. In addition to changing the libretto from Italian to French, Gluck added a substantial amount of dance music to better adhere to French operatic convention. Additionally, while *castrati* were widely celebrated elsewhere in Europe, the French found the practice of castrating young men to preserve vocal beauty and agility *déclassé*, so Gluck changed the role of Orphée to suit a high tenor (*haute-contre*).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348712748/2017-09-24---Andrian-Chuchman_The-Joffrey-Ballet_ORPHEE-ET-EURYDICE_LYR170915_0651_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Andrana Chuchman as Eurydice and The Joffrey Ballet in *Orphée et Eurydice*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

Russian-born tenor [Dmitry Korchak](/scene/people/dmitry-korchak/) was astounding in the (astoundingly-high) leading role. Indeed, he is likely one of very few tenors today who could sing this role in such a big house without any transpositions. In this production, the brainchild of the brilliant choreographer John Neumeier, Orphée swaps out his usual lyre for a production book of his own; he is a choreographer in rehearsals for a ballet and Eurydice is his wife and his company's prima ballerina. Instead of a snakebite, Eurydice dies in a car
accident and Orphée plunges into mad delusion. His subsequent journey to the land of the dead is the product of delirium and the prodding of his production assistant, Amour, (played here by a plucky [Lauren Snouffer](/scene/people/lauren-snouffer/) in a wig that made her look quite a lot like [Amy Adams in Julie & Julia.](http://adobeairstream.com/wp-content/uploads/2011/02/julie- julia-2.jpg.jpg)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348724191/2017-09-24---Dmitry-Korchak_Andriana-Chuchman_The-Joffrey-Ballet_ORPHEE-ET-EURYDICE_LYR170915_1039_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Dmitry Korchak (Orphée), Andriana Chuchman (Eurydice) and The Joffrey Ballet in *Orphée et Eurydice*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

Korchak met the dramatic demands of Neumeier's vision with the same grace and expressivity he brought to Gluck's vocal lines. Especially moving was his second act "Quel nouveau ciel," in which he floated through the highest ranges of the arioso as he walked slowly through a sea of slow-moving dancers clad in semi-transparent white silk garments. (The costumes, also designed by Neumeier, were stunning throughout but these, which featured tie-waisted white gowns for the women and Japanese-style wide legged pants for men, were especially beautiful.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348732889/2017-09-24---Dmitry-Korchak_Lauren-Snouffer_ORPHEE-ET-EURYDICE_LYR170920_0263_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Dmitry Korchak as Orphée and Lauren Snouffer as Amour in *Orphée et Eurydice*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

In her eighth role at LOC, [Andriana Chuchman](/scene/people/andriana-chuchman/) was a luminous Eurydice. Her singing was especially affecting during "Fortune ennemie," where she deftly employed the many colors of her lush voice to serve the drama of the text, "Je frémis, je languis, je frissonne, je tremble, je pâlis." ("I shudder, I languish, I shiver, I tremble, I grow pale.") Especially in a production that renders Eurydice essentially a product of
Orphée's tortured imagination, Chuchman's deeply-felt performance lent dramatic urgency and weight to the unfolding narrative, even when she was merely walking silently across the stage. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348751039/2017-09-24---Dmitry-Korchak_Andriana-Chuchman_The-Joffrey-Ballet_ORPHEE-ET-EURYIDICE_LYR170920_1936_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Dmitry Korchak (Orphée), Andriana Chuchman (Eurydice), and The Joffrey Ballet in *Orphée et Eurydice*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

Both Chuchman and Korchak are to be commended for interacting with such elegance with the dancers, namely Victoria Jaiani and Temur Suluashvili who were mesmerizing as Eurydice and Orphée's danced doubles. The end of Gluck's libretto veers from the original myth. In Gluck's version, after Orphée turns to look at Eurydice, (violating the condition Amour sets when Orphée resolves to rescue Eurydice from the Underworld), Amour is moved by Orphée's grief and fidelity and resurrects Eurydice. Tacking happy endings onto tellings of traditionally tragic myths in this way was very much *en vogue* in the eighteenth-century. But for Neumeier's concept-driven production, while the musical substance remains the same, the story's denouement is rendered far more devastating than even the myth's usual tragic end. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348769537/2017-09-24---The-Joffrey-Ballet_Dmitry-Korchak_ORPHEE-ET-EURYDICE_LYR170920_0723_c.Todd-Rosenberg.jpg.jpg)
<figcaption>The Joffrey Ballet and Dmitry Korchak as Orphée in *Orphée et Eurydice*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

As the three principal singers begin what was originally a joyful celebration of Eurydice's re-animation by Amour, it becomes clear to the audiences that what Amour has actually brought to Orphée is not the resurrection of his beloved but rather, her memory. The shade Eurydice becomes Orphée-the-choreographer's muse and the finished version of his ballet begins to spring up around him. The corps of Joffrey Ballet floods the stage with bright smiles, wearing vibrant costumes as Orphée and Amour watch from their production desk at the back of the stage. Orphée then slowly walks forward, clutching the (real? imagined?) wedding veil of the dead Eurydice. As the music ends, his pointedly hollow gaze comes up to meet us, the audience. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1506348844892/2017-09-24---Victoria-Jaiani_Temur-Suluashvili_ORPHEE-ET-EURYDICE_LYR170915_1297_c.Todd-Rosenberg.jpg.jpg)
<figcaption>Victoria Jaiani and Temur Suluashvili in *Orphée et Eurydice*, Lyric Opera of Chicago, 2017. Photo: Todd Rosenberg.</figcaption>
</figure>

What does it mean? Does Eurydice "live on" in his art? Has he worked through his grief, or is the real tragedy just beginning? Ultimately, even the most extravagant artistic endeavors can do no more than reflect our lived experiences back to us, just as the many mirrors Neumeier used in this production reflected and doubled every body on the stage. And perhaps, this is art's true power: not to help us triumph over loss but rather to help us confront it.

This production of [*Orphée et Eurydice*](https://www.lyricopera.org/concertstickets/calendar/2017-2018/productions/lyricopera/orphee-et-eurydice-opera-tickets#./Meet%20the%20Artists?&_suid=1506347404981002233772685965474) runs at the Lyric until **October 15th**. If you are lucky enough to be in Chicago right now, endeavor to see it; it is a masterpiece.

>For full details and ticket information for Orphée et Eurydice, follow our box office links below.
