+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2018-04-10T22:19:00-04:00"
lastmod = "2018-04-11T12:02:00-04:00"
preamble = "Against the Grain Theatre's spring production is upon us, and it boasts all the innovation and surprises for which the award-winning company is known. In collaboration with Opera Columbus, Banff Centre for Arts and Creativity, and NYC's Company XIV, AtG presents [*Orphée⁺*](http://againstthegraintheatre.com/orphee/), April 26-28 at the Fleck Dance Theatre in Toronto's Harbourfront Centre. Gluck and Berlioz's score is transformed with new orchestration and arrangements, and the production by Joel Ivany features burlesque dancers, aerialists, and a \"virtual chorus\". \n\nWe spoke with Ivany and AtG Music Director Topher Mokrzewski about all the curiosity inherent in their [*Orphée⁺*](http://againstthegraintheatre.com/orphee/), and what audiences can expect this month:"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523412995166/sq---Marcy-hi-res.jpg.jpg"
primary_image_credit = "Aerialist Marcy Richardson, singing Amour in Orphée⁺."
publishDate = "2018-04-10T22:19:00-04:00"
related_companies = ["scene/companies/against-the-grain-theatre.md","scene/companies/the-banff-centre.md"]
related_people = ["scene/people/joel-ivany.md","scene/people/christopher-mokrzewski.md"]
short_description = "&quot;The key is to employ all these elements to further enhance and heighten the experience of the drama - that is to say, these are not random tricks that have been selected for novelty&#039;s sake. Despite the number of collaborators, there is a unity of purpose behind every device, and I think they coalesce beautifully.&quot;"
slug = "orphe-how-do-we-grieve-in-2018"
title = "Orphée⁺: &quot;How do we grieve in 2018?&quot;"
+++

## What does the "⁺" denote in this adaptation of *Orphée et Eurydice*?

**Joel**: The plus was added to (hopefully) let people know that this is a different *Orphée*.  I realize that everyone expects us to bring something different to our shows, but I'm constantly thinking about the first time go-er.  If they come with an expectation of *Orphée* as Gluck/Berlioz wrote it, they may feel misled.  I also feel like the version that Gluck/Berlioz is pretty amazing.  Our intention was to look further into the work by making some changes to see what could happen.  It's a + and not a - because I feel that the changes are from good intentions.  Not to make the piece better (it's already pretty amazing) but to look at adapting the work with our best intentions at hand.

**Topher**: The plus also conveys the message that this production is comprised of more than its traditional parts. You'll be encountering the piece, from a musical and dramatic perspective, pretty much as it was originally conceived (no significant cuts or libretto adaptations) but with all manner of additional theatrical elements deployed to enhance the telling of the tale. Dancers, aerialists, electronic instruments, sound design. It's an *Orphée* viewed, to a degree, through the lens of our time and is, as such, a little more than a recreation of the work as the original creators conceived it.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523462556067/Orphee---PastedGraphic-3.jpg.jpg)
<figcaption>*Orphée⁺* rehearsal photo by Joel Ivany.</figcaption>
</figure>


## How will you bring together eclectic elements like burlesque, aerialists, and a "virtual chorus" to tell a single story?

**Joel**: In some ways, I say turn on the TV or scroll down Facebook.  The amount of variety, imagery and noise has never been greater.  When it is framed in a familiar body (our computers, screens) it feels contained and possible.  In the same way, I feel that our screen is the proscenium stage.  We are known for inverting the action (like a [Popple](https://en.wikipedia.org/wiki/Popples)…anyone?) but this instance we are keeping all the action framed in that familiar rectangle that we have grown up with and continue to live with (TV, phones, screens, films, etc.).  We have never been more connected to people all over the world.  That should make the world a smaller place.  However, isolation, lack of human interaction and apathy has never felt more prominent.  We feel that our tools for this opera come from the gut, from an instinctual place, and I can't wait to see how it develops.

**Topher**:  I think the diversity of elements at play in this production is a benefit and not a hindrance. The key is to employ all these elements to further enhance and heighten the experience of the drama - that is to say, these are not random tricks that have been selected for novelty's sake. Despite the number of collaborators, there is a unity of purpose behind every device, and I think they coalesce beautifully.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523462496593/Orphee---PastedGraphic-7.jpg.jpg)
<figcaption>*Orphée⁺* costume sketch by Zane Pihlstrom.</figcaption>
</figure>


## How have you made decisions about adapting Gluck/Berlioz's score? What about the music has transformed, and what have you left in place?

**Joel**: There has been quite a bit of back and forth between Team AtG and Team Opera Columbus.  Peggy Kriha Dye and Jason Hiester have worked alongside Topher and myself to settle on instrumentation, cuts, sound effects and structure.  Much of our ideas spilled out from workshops that took place here in Toronto or at the Banff Centre, where we explored the set, projections and sound. From there, we worked with our arranger Lauren Spavelko to make final revisions for the production. The music is fairly intact.  We removed some ballets that were inserted for the Paris presentation and kept much of the Berlioz version (which omits certain familiar numbers).  We've exchanged the harp for an electric guitar and added a synthesizer.  We also looked at having electronic strings, but found that we could do more with the acoustic than with the electronic.

**Topher**: It should be stated that this piece already exists in numerous forms - French, Italian, Gluck, Berlioz, countertenor, mezzo. It's been in a constant state of flux for several hundred years. I look at this project as a continuation of that process of discovery and re-invention. We're standing on the shoulders of giants, and have tried to take some of the very fine ideas already explored by persons much brighter than ourselves, shuffle them round, and re-imagine them in a musical/visual language closer to the sort we're familiar with today.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1523412819351/Joel-Topher-Nikola-Novak.jpg.jpg)
<figcaption>(l-r) Against the Grain Theatre Artistic Director Joel Ivany and Music Director Topher Mokrzewski. Photos by Nikola Novak.</figcaption>
</figure>

## What do you hope to say with *Orphée⁺*?

**Joel**: Over the past few years, grief has been front and centre in the shows that I've been directing (Mozart's *Requiem*, *Kopernikus*, *La Bohème*, *Dead Man Walking*).  *Orphée⁺* is no different.  This opera asks, how do we grieve in 2018?  Often it is at a distance, through emails, computer screens and social networks.  In doing so we distance ourselves from those that may need us the most.  We put up walls, barriers and isolate those that are going through unimaginable grief.  Whether we lost someone important to us or not, we all eventually will.  We are all Orphée and equally not.  His story is epic, heroic, but human and universal.

**Topher**: We have made it a core aspect of our company's creative process to, at times, reposition familiar works. Through that labour, we can find new meaning, yes, but more often than not, we are reminded of the essential elements that make these works great in the first place. Opera is a lot of things to people and there's much debate about what it should be going forward. What it must be and what I believe it is most successful in expressing - more than anything political, or "relevant" or topical - are the essential and common threads of humanity that unite us all. It is an art form for everyone in that sense, if also in those other ways I mentioned. Regardless of what we've done to it, I hope that this production allows people to access the boundless and furthest reaches of our shared experience.

>[*Orphée⁺*](http://againstthegraintheatre.com/orphee/) runs at the Fleck Dance Theatre April 26-28. For details and tickets, [click here](http://againstthegraintheatre.com/orphee/).
