+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = 2020-04-27T04:00:00Z
disclaimer = ""
image_gallery = []
postamble = ""
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1588074808/media/2020/04/sq16_Orlando_125412_LINDSEY_po9w8p.jpg"
primary_image_credit = "Mezzo-soprano Kate Lindsey as Orlando as a man bathed in red in the Vienna State Opera’s production of Olga Neuwirth’s Orlando. Photo: Wiener Staatsoper / Michael Pöhn."
related_articles = ["articles/talking-with-singers-kate-lindsey.md", "articles/pacific-opera-victorias-steampunkmeetsfantasy-rinaldo.md"]
related_companies = ["scene/companies/wiener-staatsoper.md"]
related_people = ["scene/people/kate-lindsey.md"]
short_description = "Instead, composer Olga Neuwirth chose Woolf’s Orlando, her often funny faux-autobiography about a young nobleman in the court of Elizabeth I who awakens one morning as a woman and proceeds to roam about time and space for the next 300 years. "
slug = "orlando-gender-bending-and-the-sound-of-androgyny-in-vienna"
title = "Orlando: gender bending and the sound of androgyny in Vienna"
youtube_url = ""

+++
Mrs. Dalloway would have been my bet for an opera based on a work by Bloomsbury modernist, Virginia Woof. That-stream-of-consciousness treatise tracking the inner thoughts of a London society matron as she shops for a dinner party fairly yearns for languid arias linked with moist recitative and perhaps even an introspective monologue.

Instead, composer Olga Neuwirth chose Woolf’s _Orlando_, her often funny faux-autobiography about a young nobleman in the court of Elizabeth I who awakens one morning as a woman and proceeds to roam about time and space for the next 300 years. _Orlando_, along with _Flush_, Woolf’s subtle criticism of urban life disguised as a biography of a cocker spaniel belonging to Elizabeth Barrett Browning, serves as a gateway to the renowned writer’s more esoteric works.

But Neuwirth wasn’t looking for a gateway to the esoteric. She sought a platform to launch an opera that is thoroughly unconventional in thought, sight, sound and certainly linear storytelling, one that would catapult the driving issue— the recognition of androgyny in both gender and sound. _Orlando_ landed on one of Europe’s most grand if conservative stages, the Vienna State Opera. It is the first work produced by a woman in the company’s 150 year history.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1588074946/media/2020/04/07_Orlando_125264_MELROSE_LINDSEY_kcnmox.jpg){{% /md %}}

<figcaption>Baritone Leigh Melrose as Orlando’s husband Shelmerdine and mezzo-soprano Kate Lindsey as Orlando after becoming a woman in the Vienna State Opera production of Olga Neuwirth’s Orlando. Photo: Wiener Staatsoper / Michael Pöhn.</figcaption>

</figure>

Such was the storm that swept through the opera house this past December when _Orlando_ premiered. It was later streamed for three days on staatsoperlive.org, which accounts for its availability as an unauthorized DVD. A sanctioned video release would be most welcome, especially if it was accompanied by commentary from Neuwirth and notes from the production team, chiefly by costumer designer Rei Kawakubo of Comme des Garcons, whose creations play more as sculpture than clothing, and videographer Will Duke, who designed a range of panoramic and finely detailed video to evoke the far flung times and places that the libretto by Neuwirth and Catherine Filloux require.

The curtain has barely risen on _Orlando_ and suddenly the orchestra in the pit is sharing space and music making with electronic instruments and recorded samples. At times one legitimately wonders where the sounds are coming from and what or who is making them. Second violins are tuned a tad lower than the first and what sounds like a classic English boys’ choir on stage is met with shivering electronic sounds before it becomes immersed in the dissonance of a competing choir located in a space above the auditorium. _Orlando_ is filled with musical moments like these, some fleeting, others nearing thematic status which reinforce Neuwirth’s stance on androgyny and makes the orchestral writing so compelling.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1588074970/media/2020/04/19_Orlando_124976_KOEHLDORFER_NIGGLI_FOERST_b5nett.jpg){{% /md %}}

<figcaption>An on stage rock band in an environment of mass consumerism in the Vienna State Opera’s production of Olga Neuwirth’s Orlando. Photo: Wiener Staatsoper / Michael Pöhn.</figcaption>

</figure>

In harnessing Neuwirth’s score, contemporary music leader Matthias Pintscher created a kind of miraculous flow that captured the work’s often raucous style. Composer/conductor Pintscher knows from whence Neuwirth is coming. Watching a performance of his composition Sonic Eclipse that he conducted with Ensemble InterContemporain of which he is music director, is to understand his keen ability to communicate contemporary music not to mention the unorthodox sounds that his musicians must produce to realize his work.

Polly Graham who assumed direction only seven weeks before the opera’s opening, is sleekly in sync with Pintscher and with the cascade of video that Duke has designed. Graham, the artistic director of the Longborough Festival Opera and the socially and politically progressive Loud Crowd opera company possesses the directorial attitude for which Neuwirth and the Vienna State Opera were surely looking.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1588074990/media/2020/04/22_Orlando_124922_SZENE_jf4rdy.jpg){{% /md %}}

<figcaption>The video design depicting the Great Frost by Will Duke for the Vienna State Opera’s production of Olga Neuwirth’s Orlando. Photo: Wiener Staatsoper / Michael Pöhn.</figcaption>

</figure>

But after everything _Orlando_ has too much plot. Woolf’s book ends on October 28,1928, ostensibly the day the novel is published. The opera ends on the day of each performance. Between 1928 and then, or rather now, much is added that begins as well-intentioned shouts for attention to climate change, sexual abuse and the rise of populism among other things, but ends feeling more like discarded placards for progressive causes. Even the music pales by comparison to the jangle of organized chaos that has preceded it.

What Woolf and Neuwirth make exceedingly clear is that Orlando’s sudden change from male to female brings about an abrupt lowering of her status. That should be enough to carry Neuwirth’s message on androgyny forward. Instead we get a litany that fails to reach us with the exception of the advent of World War II and the projection of the names of Holocaust victims. At this moment the score appropriates a recording of the slow movement of Bach’s double violin concerto played by Arnold Rose and his daughter Alma, who perished at Birkenau in 1944.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1588075018/media/2020/04/23_Orlando_125336_BOND_HAUMAN_ENSEMBLE_aumxxq.jpg){{% /md %}}

<figcaption>Queer cabaret star Justin Vivian Bond and soprano Constance Hauman in the Vienna State Opera’s production of Olga Neuwirth’s Orlando. Photo: Wiener Staatsoper / Michael Pöhn.</figcaption>

</figure>

Unfortunately this moving scene halts the opera’s action. That exciting flow that Pintscher and Graham developed is never fully regained.

Kate Lindsey, that mesmerizing mezzo-soprano, is Orlando, and what virtuosity she exudes, even while being a part of what sounds like a vocal miscalculation. No stranger to trouser parts, having most recently wowed Metropolitan Opera audiences as a punky Nerone in Handel’s _Agrippina_, Lindsey dazzles with her low register when Orlando is a man. She is required to sing in a much higher range after transforming to a woman. At first the change and the impressive manner in which it is sustained seems spectacular and vocally it is a benchmark in Lindsey's career.

But I wonder, if Orlando is truly androgynous and the opera’s androgynous spirit is to be maintained, if the voice would rise so radically. Lindsey is on her own to delineate character and she does so with adroit intensity. She burns as Orlando the female and does so brilliantly, regardless of the appropriateness of her singing range. Due to the abstract and counter-intuitive grandeur of Kawakubo’s costumes designs, likely attention-getting from outer space, they don’t really establish character or place.

> If this star of cabaret is uncomfortable on the operatic stage, it doesn’t show.

When speeding along full-throttle, Orlando is populated by a remarkable group of characters. The queer cabaret artist Justin Vivian Bond, clad in a sheer black Comme des Garcons gown plays Orlando’s child, a character that does not appear in the book. While not an operatic performer in any sense, Mx. (gender neutral honorific preferred) Bond is a distinct presence who positions attitude like a laser. If this star of cabaret is uncomfortable on the operatic stage, it doesn’t show.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1588075036/media/2020/04/26_Orlando_125371_CLEMENTI_LINDSEY_vuqf0x.jpg){{% /md %}}

<figcaption>Mezzo-soprano Kate Lindsey as Orlando who, still a man, decides to become a poet and write "The Oak Tree" in the Vienna State Opera’s production of Olga Neuwirth’s Orlando. Photo: Wiener Staatsoper / Michael Pöhn.</figcaption>

</figure>

There are several standouts in the large and generally excellent cast. Countertenor Eric Jurenas serves as Orlando’s Guardian Angel who watches over him from the very beginning. Soprano Agneta Eichenholz is Sasha, Orlando’s first love who runs off with a Russian sailor during the Great Frost. Later she appears as Chastity, one of three women who visits Orlando after he vows to become a poet and falls into a deep sleep. Baritone Leigh Melrose appears first as Orlando’s husband, Shelmerdine and then as her publisher, Greene. Soprano Constance Hauman divides her presence among three roles; Queen, Purity and Friend of Orlando’s Child.

_Orlando_, a hybrid of fiction and imposed fact, of musical styles so varied it would be easier to mention what is not referenced and of intentions so adventurous as to appear impossible to realize is thrilling opera despite its glitches. What gives it such a strong sense of place, an extraordinary achievement considering that the opera takes place over centuries and almost everywhere, are the visual images that comprise the set or more aptly the places where action transpires. According to Duke, _Orlando_ provided opportunities to utilize all of the tools available to video designers; pre-recorded film, live cameras, animation, photography, graphic design, stock footage and archive footage. A large rear screen projection system is employed with six LED screens that could be configured to meet the video needs.

> What the future holds for _Orlando_ is an open question.

Duke says Neuwirth “had very clear ideas about the information she wanted the video to provide during each scene. Because neither the set design or costume design were really providing any narrative information it was important that the video was able to convey some of that to the audience.” He adds “We thought that incorporating such a range of styles was appropriate for the way that Olga had written the score for Orlando. Musically she references so many styles and periods of music so we wanted to try and mirror that with the images.”

What the future holds for _Orlando_ is an open question. As it stands it deserves further attention and after some judicious editing and rethinking of Orlando’s singing range, could well become a template for opera’s post-modern future. Opera needs a voice that speaks not only to the future but to an unpredictable and exciting one. Olga Neuwirth comes through loud and clear.