+++
author = ["authors/jenna.md"]
categories = "Humour"
date = "2016-03-31T19:52:00+01:00"
lastmod = "2016-04-01T11:03:00+01:00"
preamble = "If you're a collector of opera scores, you likely have some system of organizing them for easy perusal. All those beautiful hardcover editions, charmingly tattered paperbacks, each with their unique set of dimensions and typography on the spine; there's something comforting and cathartic about organizing them, and re-organizing them every few months when the chaos on the shelves becomes too upsetting.\n\nSo, what's your method of choice? Maybe you're a strict Dewey Decimal supporter, or a die-hard Library of Congress fan. Maybe your system is simpler: \"the pile on the piano over here\" and \"the ones not on the piano\". And hey, if it works for you, let's not ruin a good thing.\n\nVariety is the spice of life, which is why we like to mess with the (shelving) system once in a while. Examples below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1459454113378/2016-04-01---High-Fidelity.jpg.jpg"
primary_image_credit = "Photo: John Cusack in High Fidelity, 2000."
publishDate = "2016-04-01T10:18:00+01:00"
related_articles = ["articles/6-tv-shows-that-should-be-operas.md","articles/how-to-really-learn-a-song.md","articles/elitism-irony-and-the-phantom-of-the-opera.md"]
short_description = "So, what&#039;s your method of choice? Maybe you&#039;re a strict Dewey Decimal supporter, or a die-hard Library of Congress fan. Maybe your system is simpler: &quot;the pile on the piano over here&quot; and &quot;the ones not on the piano&quot;. And hey, if it works for you, let&#039;s not ruin a good thing."
slug = "organizing-your-scores-a-serious-business"
title = "Organizing your scores: a serious business"
+++

## Obvious choices: alphabetical & chronological

Alphabetical is probably a logical, sensible choice that will guarantee you can find your choice of score easily on demand. But alphabetical based on what? The composer's last name? First name? Middle initial? The title of the opera? The English-translated title of the opera (*never do this*)? The name of the main character? The first word of the libretto? So many options.

Same goes for chronological organization. Is it by when it was written? When the opera takes place? Better yet, you can get all hipster-nerdy-savvy about it and organize your opera scores by their premiere date. Spark some healthy debate over all those tricky posthumous premieres when company comes over (who needs charades, really?).

## Getting visual: sizes & colours

Maybe you're a visual person, and how your score collection looks on the shelves matters just as much as the music itself. In this case, it's a game of editions. You could create a rainbow of Bärenreiter blue, Ricordi burgundy, Kalmus green, and Schirmer red. The fun comes when that Alkor *Carmen* isn't sitting beside its Schirmer counterpart, or when you have five *Die Fledermauses* scattered across the spectrum, or your hardcover Ricordis are on another shelf entirely from their grey-hued paperback brothers and sisters.

Or, maybe you're after some ascending or descending order of size? Something like, Bärenreiter mini scores, then piano-vocal scores ranging from Kalmus to Schirmer to Boosey, then Dover full scores? And are we looking at height or width? Those new Ricordi paperbacks, printed in the musical equivalent of large-print novels, certainly take up some width (and weight), as anyone working on *Rigoletto* knows well. The possibilities are overwhelming.

## Getting nerdy: source material & keys

Maybe you want to store your scores *and* show off your smarts about what's inside them. You could get nerdy about it and organize your operas by the source material for the story: you'd have your based-on-Goethe section, the based-on-Shakespeare section, then the Brothers Grimm stuff, then Pushkin plots, then Bible stories, Greek mythology, Norse mythology, Druid stuff, then Roman emperors, queens, kings, and American presidents? Whew.

Or, you could drive your guests up the wall trying to figure out your pattern, simply by arranging your scores in ascending order (or descending order, if you're feeling adventurous) of what key they start in? Could be fun, until you hit the 20th-century, where your order of keys becomes entirely up for debate. And, does C major come before c minor? Or does c minor come after E-flat major? And what happens when you've got *Don Giovanni* and *Roméo et Juliette*? Both in d minor... Philosophical questions, these are.

## After some cocktails: animals, body parts & silliness

So, you'd have *Die Fledermaus*, *The Cunning Little Vixen*, *The Golden Cockerel*, *The Nightingale*, *The Bear*, *El gato con botas*, *La gazza ladra*, *Rusalka* (half right), *The Minotaur* (same), plus *Albert Herring* and *Madama Butterfly* for laughs. Animal section, check.

Or what about operas named after body parts? There are more than you'd think. *Les mamelles de Tirésias*, of course, then *The Nose*, *Powder her Face*, *La voix humaine* (is the voice a part?), and maybe *Bluebeard's Castle* and *Simon Boccanegra*?

>Readers, have you got your own score-ganization system (we're proud of that one) that you'd love to share? If so, do it in the comment section below!
