+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2016-03-17T17:21:00+00:00"
lastmod = "2016-03-18T16:32:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1458317032217/2016-03-18---Growth.jpg.jpg"
publishDate = "2016-03-18T16:23:00+00:00"
related_articles = ["articles/the-case-for-nomadic-opera.md","articles/bills-and-business-models.md"]
related_companies = ["scene/companies/canadian-opera-company.md","scene/companies/english-national-opera.md","scene/companies/the-bicycle-opera-project.md","scene/companies/toy-piano-composers.md","scene/companies/against-the-grain-theatre.md","scene/companies/tapestry-opera.md"]
short_description = "All of this is nearing an uncomfortable suggestion. We ask, honestly and without further insinuations: when was the last time that the chorus, or the orchestra, was the most memorable element of an opera?"
slug = "operas-survival-tightened-belts-callous-questions"
title = "Opera&#039;s survival: tightened belts &amp; callous questions"
+++

[English National Opera](http://www.theguardian.com/commentisfree/2016/feb/16/english-national-opera-eno-cultural-treasure-value-for-money) currently holds the spotlight in the ongoing story of opera companies who are pressured to tighten their belts. The spotlight status has been passed from New York City Opera, to San Diego Opera, to Opera Lyra Ottawa, and very publicly to The Metropolitan Opera; these companies faced financial struggles for various reasons, and not all of them survived.

[Arts Council England has reduced ENO's annual funding](http://www.artscouncil.org.uk/media/uploads/Analysis_of_Opera_and_Ballet.pdf) by about a third, or £5M. Pay cuts for the chorus members were proposed, and a responsive strike loomed. Today, [ENO announced that it has settled](http://www.bbc.co.uk/news/entertainment-arts-35841968) its pay disputes with the chorus, finding some moderation between less money, and a lot less money for the singers.

Before the settlement was announced, Cressida Pollock, Chief Executive of ENO [stated](https://www.eno.org/news/further-update-on-eno/), "We cannot move to an 'austerity year' and hope that we buy ourselves some time for a magic solution to materialise. ENO, in one way or another, has adopted this approach for over 30 years...We are not simply trying to find £5m of savings. The company will have to save £5m every year."

Yikes. 

Plenty has been written about how ENO should handle their slashed funding. [Some back the ACE's decision](http://www.spectator.co.uk/2016/02/eno-must-go/) decrease funding, and that there's responsibility on the company to ["adapt or die"](http://www.theguardian.com/commentisfree/2016/feb/16/english-national-opera-eno-cultural-treasure-value-for-money) like any other business. Part of this adapting includes saving on personnel, and members of the ENO chorus became public faces of the individual artists facing significant pay cuts.

The role of the chorus also came up in 2014, when The Metropolitan Opera was negotiating furiously with several unions, again trying to make pay cuts seem palatable under the company's financial strain. The Met Orchestra and several crew unions were also involved in the negotiations, which is a trend mirrored by any struggling company. These are expensive groups of people; at times, prohibitively so.

Without a detailed look at these company's financial reports, it's difficult to confidently point fingers at what or who is sucking up all the money. Except, it's easy: opera, as a whole, is sucking up all the money. It's an extraordinary art form that means a lot to us, and to all of you, readers; but it costs money to put up, and it always has. 

The chorus, the orchestra, the venue and its workers; these are big costs that any opera company faces. In the past 10 years, handfuls of start-up companies have emerged, and even with the arts grants and private donations they acquire, their first few seasons are historically devoid of a full chorus, orchestra, and a venue that looks traditionally like a theatre. Yet these "limitations" become part of the experience. [Unique venues pique interest](/the-case-for-nomadic-opera/), and site-specific works emerge. Operas by Wagner, Verdi, and Strauss don't really work without a full orchestra and chorus, and so the young company's hunt for repertoire unveils gems, everything from *The Turn of the Screw* to *La voix humaine* to [*Il segreto di Susanna*](/in-review-modern-family-opera/). 

Even better, limitations turn into options, prompting adaptations like [Against the Grain Theatre](/scene/companies/against-the-grain-theatre/)'s *#UncleJohn* and *A Little Too Cozy*, and brand new chamber operas (read: portable) like [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/)'s new collection of operas with [Toy Piano Composers](/scene/companies/toy-piano-composers/), [*Travelogue*](/new-teams-new-operas-bicycle-opera-toy-piano-composers/). Frankly, a composer has a better chance of having his work performed more than once if it's slim and compact (read: cheap) in its needs. Even companies with larger budgets know this; the [Canadian Opera Company](/scene/companies/canadian-opera-company/) has notably included at least one chorus-free production per season in recent years. One of these was the chilling double-bill of *Bluebeard's Castle* and *Erwartung*, and it remains one of the more shattering things we've seen on the live stage.

All of this is nearing an uncomfortable suggestion. We ask, honestly and without further insinuations: when was the last time that the chorus, or the orchestra, was the most memorable element of an opera?

There are, of course, works where the masses make a difference. Verdi's *Aida* and Wagner's *Ring Cycle* aren't easily pared down to a small ensemble, and cutting the choruses leaves a large void. These shows attract audiences, though. Funnily enough, other favourites like *La bohème*, *Il barbiere di Siviglia*, *Le nozze di Figaro*, these can and have been done successfully without a chorus, and with a small ensemble (even with a lonely piano). And they work, because these pieces aren't riding on The Large, nor The Loud.

Opera fans have an admirable habit of defending opera; yet what they deem as the life-blood of opera tends to change, depending on what's at risk. [When directors experiment](/panel-regietheater/) with classic operas, the responding outcry says that opera's traditional beauty is in peril. When companies don't commission enough new works, fans claim that contemporary opera is in danger. And, when the members of an orchestra or chorus are facing pay cuts, operaphiles declare the art form pointless without these institutions.

The problem is certainly that there's not enough money for everyone to always do what they want. Groups like the ENO chorus are not whiners; they're affected in an immediate way by "not enough money". Yet it appears that there's never enough money, and if that's a fact, that's a fact. Oversimplified, the decision seems to be between running out of money slowly, or running out quickly. If a company wants more options than these two, we suspect the changes need to be more drastic.

Perhaps it comes down to personal aesthetic, but we've seen proof that opera can be engaging, surprising, and newbie-friendly, even without crystal chandeliers in the house or 100-strong choruses. There's a lot to be said for small venues, where the audience can see the singers' faces and catch smaller details onstasge. It's easier to hear and understand them, and heading to a bar or small art gallery is much less daunting than braving a major opera house (that's a real factor, one that I think opera lovers benevolently ignore).

This isn't what chorus singers or orchestra musicians want to hear, but opera *can* go on without them. It won't be the same as experiencing *Der Rosenkavalier* or *Il trovatore* in their full splendour, but it will offer an orange-type of option to go along with the apples. Opera has already gone from quasi-background entertainment to go with the drinking and card games, to a quiet, rapt-attention evening in a dark theatre. It's naïve to think it won't evolve again, unless we dig in our heels and prevent it from happening. Things that don't bend, break, right?
