+++
author = ["authors/michael-zarathuscook.md"]
categories = "Review"
date = "2018-12-01T21:38:00-05:00"
lastmod = "2018-12-02T09:32:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543718324805/sqOpenChambers-8.jpg.jpg"
publishDate = "2018-12-01T21:39:00-05:00"
related_companies = ["scene/companies/opera-5.md"]
related_people = ["scene/people/jacqueline-woodley.md","scene/people/rachel-krehm.md"]
short_description = "Ultimately it&#039;s the music that resonated the most, while the theatrics — played out in a dichromatic set via mimetic interpretations of the libretto — filled in the gaps that awkward shuffling and transitional applause between segments are otherwise expected."
slug = "opera5s-open-chambers-too-many-cooks-in-the-chamber"
title = "Opera5&#039;s Open Chambers: Too many cooks in the chamber?"
+++

I made my first visit to Factory Theatre this past Wednesday (Nov.28th) — which perhaps identifies, at first glance, as a low-key subway station — courtesy of the amazing Jenna Simeonov, in the cozy yet austere Studio Theatre on the main floor. 

Just what to make of this production? — I'm as sure now as I was in its first five minutes: I'm afraid I don't have enough head to scratch. I know I'm impressed by the entirety of it, despite the sedimentary layers of dramatic features that were frequently inaccessible. It's a bit of, though not entirely, a case of too many cooks in the chamber — oh! and half the menu is written in German (the other half in Russian). The subtitles on a discreet were very helpful, well incorporated and poetically phrased, if you were able to peel away from the list of activity and narrative gestures happening simultaneously. 

Ultimately it's the music that resonated the most, while the theatrics — played out in a dichromatic set via mimetic interpretations of the libretto — filled in the gaps that awkward shuffling and transitional applause between segments are otherwise expected.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543717796792/OpenChambers-2.jpg.jpg)
<figcaption>Rachel Krehm and Jacqueline Woodley in *Open Chambers: Hindemith & Shostakovich*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

### "What are human tears?/When the sunset is glowing red!"

Those words are excerpts from "Music", one of the seven poems by Alexander Blok set to music in 1967 by Dmitri Shostakovich (Op.127) for voice, violin, piano and cello. Yosuke Kawasaki was excellent both on the violin and as an actor during those aforementioned narrative segments; the same can be said of Wolfram Koessel on the cello, who at one point convincingly executed the mimesis of bowing a cello, employing one of the sopranos as the cello. This string duo was exceptional during the Shostakovich portion of the night, and Rachel Krehm's soprano, with its timpanous resonance, rose to meet the occasion of the muscular utterances characteristic of a string section by Shostakovich. 

The voice and music — which is often enough for chamber music — use up most of my sympathetic commentary for this production; and I'm left with little praise for the set design and narrative choreography, components which add as much depth as distraction to the virtuosic performances of the sopranos and musicians. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543717840721/OpenChambers-4.jpg.jpg)
<figcaption>Melissa Scott and Jacqueline Woodley in *Open Chambers: Hindemith & Shostakovich*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

One would search to no avail for the thematic source of the set design in the libretto, that could explain (justify?) the crimson velveteen dream-logic behind the costumes, stage design and repetitive gestures. The aforementioned excerpt was the best I could find, granted the rest of the seven poems by Blok has its share of blood-dimmed tides and impenetrable nights — "A black dream weighed upon my breast./ My predestined end is near." etc...

Jacqueline Woodley's more measured expositional soprano was the outstanding voice for the Hindemith portion of the night. She maintained a compelling stage presence that made the room feel small and intimate throughout. Melissa Scott's performance was a stalwart marathonian effort on the oboe for Hindemith's Oboe Sonata, and continued to hold its own even during the full gale force of the layered parts for viola (Kawasaki), cello and soprano (Krehm) in "Der Wurm am Meer".

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543717905192/OpenChambers-10.jpg.jpg)
<figcaption>Yosuke Kawasaki and Jacqueline Woodley in *Open Chambers: Hindemith & Shostakovich*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

### IN SUMMA SUMMARUM…

The production is on the whole imaginative, and maintains a busy kind of entertainment, but parts of it (set design especially) are a bit staid and at an obtuse angle to the more applaudable risks taken by stage director and designer Patrick Hansen. If the goal, as stated by Hansen, was to "reframe the chamber music experience..." then by that mark the production was a success, albeit a confusing multifaceted one wherein the audience wasn't sure when to clap and when to laugh — despite ample opportunities for both. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1543717918335/OpenChambers-15.jpg.jpg)
<figcaption>(Left  to  Right): Yosuke Kawasaki, violin, Melissa Scott, oboe, Vadim Serebryany, piano, Rachel Krehm, Jacqueline Woodley, and Wolfram Koessel in *Open Chambers: Hindemith & Shostakovich*, Opera 5, 2018. Photo: Dahlia Katz.</figcaption>
</figure>

But there's another mark, the one that brought us through the doors in the first place: among other things, to be immersed in the experience, enthralled by the music, moved by the ballistic force of two very talented sopranos whose voices had their maximum effect in such an intimate space.  Had the music been left alone a bit more, without being crowded by narrative and dramatic dimensions, there might have been more room to be immersed in the music. 

One of the challenges introduced by the addition of the theatrical element to a musical performance is the erection of a fourth wall — a separation between the audience and the performance. There's often very few opportunities to break that fourth wall on the operatic stage, so one has to rely on the power of the singers to leap their voices over that wall and draw us into the realm wherein the imagery of these poems and the lyricism of the music is most potent.  Thankfully the voices rose to such heights and the music found its way through the many hanging frames and red-velvet shawls. 

