+++
author = ["authors/greg.md"]
categories = "Review"
date = "2024-06-18T00:00:00-00:00"
lastmod = "2024-06-18T00:00:00-00:00"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1718717759/sqOpera_5_The_Turn_of_the_Screw_Emily_Ding_Photography_Asitha_Tennekoon__Peter_Quint_Prologue.jpg"
primary_image_credit = "Asitha Tennekoon as Peter Quint and Prologue in The Turn of the Screw, Opera 5, 2024. Photo: Emily Ding Photography."
publishDate = "2024-06-18T00:00:00-00:00"
related_articles = ["articles/an-ambiguous-turn-of-the-screw-at-garsington-opera.md", "articles/death-in-venice-a-near-perfect-production.md"]
related_people = ["scene/people/elizabeth-polese.md", "scene/people/krisztina-szabo.md", "scene/people/rachel-krehm.md", "scene/people/asitha-tennekoon.md"]
related_companies = ["scene/companies/opera-5.md"]
short_description = "The orchestra, under Music Director and conductor Evan Mitchell handled the score and the unconventional space magically. The flow of the score ameliorated the pace of the show itself and vice-versa."
slug = "opera-5-turns-up-the-spooky-in-turn-of-the-screw"
title = "Opera 5 turns up the spooky in Turn of the Screw"

+++
Hello Schmop-Tops!

[Opera 5](/scene/companies/opera-5/) is back and they are not messing around. In their first in-person production since 2018, the team took to the Theatre Passe-Muraille main stage to give us Benjamin Britten's creepy classic, _The Turn of The Screw_. 

Based on the 1898 Henry James novella of the same name, the story goes like this: 

A new Governess is hired to care for two children at Bly Manor. Miles and Flora were orphaned and are now wards of an absentee and disinterested uncle. The Governess is given explicit instructions to _not write to the uncle for any reason_. So obviously, that becomes an issue when Miles is expelled from boarding school. The Governess learns from Mrs. Grose, the housekeeper, that the previous Governess, a Miss Jessel, and the previous valet for the uncle, a Peter Quint, who after developing a close relationship, pass away mysteriously. The Governess now begins to see the ghosts of Jessel and Quint around the property and believes the children to be in danger. In her efforts to protect the children she sends Flora away with Mrs. Grose and then tries to get through to Miles, who she believes is in thrall of the spirit Quint. The boy perishes in her arms.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1718717759/Opera_5_The_Turn_of_the_Screw_Emily_Ding_Photography_Elizabeth_Polese__Governess.jpg){{% /md %}}
<figcaption>Elizabeth Polese as The Governess in The Turn of the Screw, Opera 5, 2024. Photo: Emily Ding Photography.</figcaption>
</figure>

In this production director Amanda Smith has teamed up with dramaturg Daevyd Pepper to angle the lens of the story to include a group of people known as the "Cunning Folk", folk healers and practitioners in the British isles who were often othered and persecuted for their pre-Christian traditions and beliefs. Miss Jessel becomes involved with Quint, who is one of these Cunning Folk; the idea of them being nefarious spirits is only given to us because the details of Quint and Jessel's relationship come from the often judgemental Mrs. Grose, who has her own biases with these healers and magicians. 

The Victorian gothicness of the tale was deliciously heightened by both the design elements, and also the venue itself. Production designer Shannon Lea Doyle, associate JB Nelles, and lighting designer Noah Feaver were skillfully adept and using the natural space they were in and enhancing it, to provide us with a dark and gloomy, but not hard-to-see design and aesthetic. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1718717759/Opera_5_The_Turn_of_the_Screw_Emily_Ding_Photography_Elizabeth_Polese__Governess_Rachel_Krehm__Miss_Jessel.jpg){{% /md %}}
<figcaption>Elizabeth Polese (above) as The Governess and Rachel Krehm as Miss Jessel in The Turn of the Screw, Opera 5, 2024. Photo: Emily Ding Photography.</figcaption>
</figure>

The singing in this show was bonkers. I'm really glad I got to hear soprano Elizabeth Polese in the role of The Governess. I've been a fan of Polese's for quite a few years now and it's wonderful to see the growth in this beautiful instrument. It sounded as though the role was written specifically for her. Her smooth, warm legato lending itself particularly beautifully with Britten's moody soundscape of a score. Dramatically speaking, her acting was refined and nuanced. The journey she took us on from eager, bright-eyed and optimistic to haunted, stressed, and devoted was a masterpiece. 

In the role of Mrs. Grose the housekeeper, mezzo-soprano Krisztina Szabó was magnificent. Her incredible voice on full display. Her upper register rang clear throughout the house with no sign of effort or strain while keeping a secure line through the entirety of her range -- and this role is rangey! She and Polese made some exquisitely beautiful music together and sounded as though they'd been making music together daily for years. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1718717758/Opera_5_The_Turn_of_the_Screw_Emily_Ding_Photography_Elizabeth_Polese__Governess_Krisztina_Szabo__Mrs_Grose.jpg){{% /md %}}
<figcaption>(l-r) Krisztina Szabó as Mrs. Grose and Elizabeth Polese as The Governess in The Turn of the Screw, Opera 5, 2024. Photo: Emily Ding Photography.</figcaption>
</figure>

As Peter Quint, the misjudged Valet of Cunning Folk descent, tenor Asitha Tennekoon brought us a spirit that was, while creepy and scary, and rather benign. His gentle handling of Britten's score was beautifully crafted and his physicalization of Quint's spirit was excellent as well. Tennekoon is a fabulous actor, and this is another great chance for him to flex those muscles! 

In the role of Mrs. Jessel, soprano Rachel Krehm, part of the Opera 5 team, brought and air of curious propriety to her Jessel. At times her large, full soprano muddled a bit of her diction in this particular space, but that's splitting a _very fine hair_. Her portrayal of Jessel was full of love and compassion for young Miles and Flora and her ability to help the audience view that as a threat the way Mrs. Grose interprets it was very well done. 

As Miles the young nephew of Bly Manor's master, countertenor Ryan McDonald sang ebulliently and robustly with all the bluster you would expect from a young boy about to become a man in Victorian England who was also expelled from boarding school. The voice was supported and well-rounded, although the diction could also be cloudy at times, the vitality of their Miles won through in spades. Thera Barclay, in the role of Flora, was also a delight to hear. I don't know Barclay's voice well, but after this show I'm looking forward to hearing a lot more of it. Together the two sounded like true siblings and their chemistry and energy was both palpable and infectious. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1718717759/Opera_5_The_Turn_of_the_Screw_Emily_Ding_Photography_Asitha_Tennekoon__Peter_Quint_Prologue.jpg){{% /md %}}
<figcaption>Asitha Tennekoon as Peter Quint and Rachel Krehm as Miss Jessel in The Turn of the Screw, Opera 5, 2024. Photo: Emily Ding Photography.</figcaption>
</figure>

The orchestra, under Music Director and conductor Evan Mitchell handled the score and the unconventional space magically. The tempi, while definitely Britten, were not sluggish or or too big for the space. The flow of the score ameliorated the pace of the show itself and vice-versa. There were many times, especially with Polese and Tennekoon that all the artists on stage were really making music together. 

We attended a sold-out opening night performance and the reception of the crowd was exactly what the show deserved.

One cool thing that Opera 5 is doing now is they've created and [Opera Intern program](https://opera5.ca/opera-5-opera-mcgill-intern-program/). They've partned with Opéra McGill to train a cast of six young singers from McGill's excellent opera program to cover the roles -- they performed the show on the 13th of June to great reception -- as well as add-on skills in production, administration, and marketing.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1718717758/Opera_5_The_Turn_of_the_Screw_Emily_Ding_Photography_Thera_Barclay__Flora.jpg){{% /md %}}
<figcaption>Thera Barclay as Flora in The Turn of the Screw, Opera 5, 2024. Photo: Emily Ding Photography.</figcaption>
</figure>

So for a warm night in June, it was actually kind of nice to be chilled to the bone by a good spooky story and some really incredible top-notch singing! Bravi tutti, and I can't wait to see Opera 5's next show. 