+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-11-28T22:36:00+00:00"
lastmod = "2016-03-12T16:08:00+00:00"
preamble = "The 2015 Canadian Opera Company's [Glencore Ensemble Studio School Tour](http://www.coc.ca/ExploreAndLearn/Schools/SchoolTour.aspx) is underway, bringing opera for young people into schools. This year, one of the two touring productions is [*Operation Superpower*](http://www.operationsuperpower.com/), originally created by four Juilliard grads, composer Armand Ranjbaran, pianist Peter Dugan, and baritones [John Brancy](/scene/people/john-brancy/) and and [Tobias Greenhalgh](/scene/people/tobias-greenhalgh/). It's an interactive show for 6- to 12-year olds, where young audiences can find their own hidden superpowers; so far, they've performed for ~50,000 superheroes-in-training.\n\nBrancy and Greenhalgh talk about creating *Operation Superpower*, and why it \"has the ability to positively impact the world of classical music & opera at large.\"\n\nPhoto: [Aaron Sheppard](/scene/people/aaron-sheppard/), [Jean-Philippe Fortier-Lazure](/scene/people/jean-philippe-fortier-lazure/), and [Erica Iris](https://twitter.com/mezzoericairis) in the 2015 Glencore Ensemble Studio School Tour production of *Operation Superpower*."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448750946339/2015-11-14-COC-Superpower-172---square.jpg.jpg"
primary_image_credit = "The cast of Operation Superpower, Glencore Ensemble Studio School Tour, 2015. Photo: Chris Hutcheson."
publishDate = "2015-11-30T14:21:00+00:00"
related_articles = ["articles/shhdont-tell-them-its-opera.md","articles/worthy-campaigns-a-silent-night.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md","scene/companies/the-juilliard-school.md"]
related_people = ["scene/people/john-brancy.md","scene/people/tobias-greenhalgh.md","scene/people/peter-dugan.md"]
short_description = "Operation Superpower was originally created by four Juilliard grads: composer Armand Ranjbaran, pianist Peter Dugan, and baritones John Brancy and and Tobias Greenhalgh. It&#039;s an interactive show for 6- to 12-year olds, where young audiences can find their own hidden superpowers; so far, they&#039;ve performed for ~50,000 superheroes-in-training."
slug = "opera-with-a-message-operation-superpower"
title = "Opera with a message: Operation Superpower"
+++

## 1. How did the idea for *Operation Superpower* come about?

We created *Operation Superpower* together with our two friends and classmates, Armand Ranjbaran (composer) and Peter Dugan (pianist), during our time at the [Juilliard School](/scene/companies/the-juilliard-school/). Armand had an idea for an awesome composition project, which stemmed from some late-night conversations we'd had about how cool it would be if someone wrote a superhero opera. He started by writing two astounding works for baritone and full orchestra, titled "Hope" and "Courage", which are loosely based on existing superhero tropes. We recorded these two pieces with an orchestra comprised of our Juilliard classmates in 2009. 

Then, after a few years of collaboration and work with the Juilliard Entrepreneurial and Professional Mentorship programs, we realized that with this special music and our own personal superpowers (singing, composing, and playing piano) we could seamlessly make the transition from large-scale orchestral project to in-school assembly program. 

Thus *Operation Superpower* was born; a program designed for students ages 6-12, to inspire them to discover their own superpowers, and to learn about classical music. With our experiences performing different variations of the program over several years, we learned from our audiences (the students!) what worked, and what didn't. From there, we have been growing and developing the project alongside our personal careers, and it has been a deeply rewarding experience. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448753990739/2015-11-04-COC-Superpower-196---resized.jpg.jpg)
<figcaption>l-r: Erica Iris, Aaron Sheppard and Jean-Philippe Fortier-Lazure in the Glencore Ensemble Studio School Tour production of *Operation Superpower*, 2015. Photo: Chris Hutcheson.</figcaption>
</figure>

## 2. How did you develop the show’s message, and what kind of interaction is there between performers and the audience?

*Operation Superpower*'s main message is that everyone has a superpower or talent which can enrich their own life, and be used to help others. Much like a superhero in the comic book world, our characters have origin stories, and use their talents to make the world a better place. We realized in the process of creating this show that the accessibility of superheroes allowed us to introduce these young audiences to classical music and opera in an organic and powerful way, while also giving us the opportunity to educate and inspire them. 

You would be hard pressed to find an opera that has been composed specifically for young audiences with the express purpose of empowering, educating and encouraging them to dream and grow. We created a narrative core for our piece called "The Five Elements of Discovering your Superpower". These elements are: Courage, Hope, Honesty, Imagination and Friendship. We elaborate on each element in the course of the show, and engage our audiences in an exploration of what each words means. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448754119181/opsupphoto2.jpg.jpg)<figcaption>Tobias Greenhalgh (red) and John Brancy in *Operation Superpower*. Photo: Gerard Collett.</figcaption>
</figure>

For young students, this is a very influential way to learn how to collaborate with one another and understand each other's similarities, differences, and ultimately what makes each of them so special. We designed the show to be highly interactive, immersing the audience in every facet of our story and including a lot of vocal and physical participation as well. The show is at its most powerful during the "imagination meditation" scene, where the students are asked to share their superpowers with the group, and all of their peers are there to cheer them on.

## 3. What sort of production history has the show had so far?

Our show has been performed in many different venues and locations throughout North America, with its most recent premiere this fall at the COC for their Glencore Ensemble Studio Tour! This was a major step for the program, and really outlined what is possible for the future of the project. Since its inception, we have personally performed over 100 shows of the program for upwards of 50,000 students. We've done shows at private schools, public schools, all girl and all boy schools, in theatres, gymnasiums and cafeterias, as well as for underserved communities. 

We have partnerships with The Juilliard School, Young Audiences Arts for Learning, the Peoria Symphony, the Canadian Opera Company, and Opera Saratoga. Our hope is to continue to collaborate with these prestigious institutions, as well as engage other opera companies, employing more young artists to perform our show for students throughout North America, and eventually the rest of the world!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448754335697/2015-11-29%20-%20TobiasJohn.jpg.jpg)
<figcaption>Baritones Tobias Greenhalgh and John Brancy, co-creators of *Operation Superpower*.</figcaption>
</figure>

## 4. How does it feel having the show performed by other artists? 

When we first started *Operation Superpower*, it was a dream for us to have the show performed by other artists, but we knew we would have to work very hard to get to that point. Now that we're there, it is incredibly exciting and a bit scary to think that our show is now out in the world and evolving, as it gets interpreted and performed by others. Ultimately, it's a dream come true! 

Most recently, with the production at the COC, we handed over the baton to their creative team, led by director [Ashlie Corcoran](/scene/people/ashlie-corcoran/), who put their own unique and amazing stamp on the piece. We've received really positive feedback from them, and we know that this is how our show should be moving forward: with new productions inspired and informed by our original concept. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1448754246929/2015-11-04-COC-Superpower-021.jpg.jpg)
<figcaption>Aaron Sheppard, Erica Iris and Jean-Philippe Fortier-Lazure in the Glencore Ensemble Studio School Tour production of *Operation Superpower*, 2015. Photo: Chris Hutcheson</figcaption>
</figure>

## 5. What is your ultimate hope for *Operation Superpower*? 

Our hope for *Operation Superpower* is that it will make its way into every school in North America, performed by young artists either right out of university or those in professional young artist programs. We believe wholeheartedly that *Operation Superpower* has the ability to positively impact the world of classical music & opera at large, and if embraced by the industry, it can make a huge difference for the future of our art form. 

We want to work with opera companies and universities to help them build audiences for classical music at a grass roots level, while also giving young artists the opportunity to connect with students and introduce them to opera. Young singers just beginning their careers have a superhuman amount energy and passion for their art form that can be contagious with young audiences. When channeled through our program, this energy can become a catalyst for inspiration, confidence, positivity and change.  

>For more on Operation Superpower, visit the [official website](http://www.operationsuperpower.com/).
