+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-03-30T22:35:00-04:00"
lastmod = "2018-03-31T10:05:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463609000/sq---Callas-w-cards.jpg.jpg"
primary_image_credit = "BASE Hologram interactive concert performance with Maria Callas at the Jazz at Lincoln Center Frederick P. Rose Hall on Sunday, January 14, 2018 in New York."
publishDate = "2018-03-30T22:35:00-04:00"
related_articles = ["articles/cleanedup-callas-the-remastered-live-recordings.md","articles/so-can-we-hear-hologram-callas-soon.md","articles/big-jim-and-the-smalltime-investors-a-story-often-told.md"]
short_description = "While I was not in attendance at the recent Maria Callas presentation in New York, neither was she. Within limits then, I can write about what is loosely termed a demonstration of holographic inspired illusion, as this consideration kicks off."
slug = "opera-technology-hither-and-yon"
title = "Opera Technology: Hither and Yon"
+++

Sometimes one's attention is captured in seemingly random ways-hither and yon, as it were. A few weeks ago I read about a Maria Callas illusion, followed by the announcement of a *La traviata* boasting 3D sets.  Most recently a recommendation for a DVD of a *Cav/Pag* from Salzburg, evoking black & white and Technicolor movies, appeared in my email. In no time I was thinking about the role of technology in opera.

## The Illusion of Callas

While I was not in attendance at the recent Maria Callas presentation in New York, neither was she. Within limits then, I can write about what is loosely termed a demonstration of holographic inspired illusion, as this consideration kicks off.

Purists might take pause over the upcoming digital exhumation of La Divina, who will appear before North American audiences later this year. But their curiosity may be aroused by the prospect of actually seeing and hearing this beloved diva, even, if in reality, it is a digitally enhanced 3-D illusion. Hopefully Base Holograms, the producer of *Callas in Concert*, knows what it is in for when tampering with Maria Callas. 

To paraphrase Shakespeare and as purists would contend, the voice is the thing. So hearing a digitally remastered Callas accompanied by a live 60-piece orchestra, replacing the recorded monophonic tracks, might provide an inducement. In fact, while the visual illusion is garnering most of the attention, it is the technical pampering of Callas' recorded voice and the stripping away of the old musical tracks that may prove to be the most compelling take-away from this event. 

But the fact remains that the illusion begins with the creation of a visual Callas. A body double was trained to duplicate Callas' distinct posture and mannerisms. Then her striking features were digitally transposed on to the filmed image of the double and the visual source material was born.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463124585/Callas-w-conductor.jpg.jpg)
<figcaption>BASE Hologram interactive concert performance with Maria Callas at the Jazz at Lincoln Center Frederick P. Rose Hall on Sunday, January 14, 2018 in New York.</figcaption>
</figure>

Much of the laser projection technology remains proprietary, but we are told it will result in the projection of a filmed, but seemingly live, Callas on stage. She will not only respond to what will presumably be an adoring audience, but also interact with the conductor. Audiences are assured of witnessing a lifelike performance. How lifelike will rely on their willingness to suspend, or to momentarily redefine, reality.

The concert is to include works by Bellini, Bizet, Verdi and Puccini. It is reasonable to wonder if "Vissi d'arte," one of the few live operatic performances by Callas captured on video (Act two, *Tosca*, Covent Garden, 1962) will be included. Perhaps because the existing video is so definitively acted as well as sung, and represents a pinnacle in the Callas oeuvre, another video rendition might be a stress on the boundaries, even of illusion. Needless to say, the concert's contents will raise eyebrows, not to mention blood pressures, no matter what is programmed.

Critical and public response to *Callas in Concert* will play a role in determining how this technology evolves in opera and more broadly in popular culture. In addition to Callas, Base Holograms is producing another concert featuring the illusory presence of the late country music great, Roy Orbison. If the company appears to be hedging its bets, it also risks offending whole segments of the musical world by reviving these two icons from diverse musical genres. Maria and Roy had better be good, genuinely good.

Will *Callas In Concert* herald a new form of entertainment and mark the beginning of a useful source of musical reference and documentation? Or will it become a footnote in the history of arguably the most famous opera singer of the 20th century? Whatever the outcome, the technology is an intriguing and extraordinary feat that will have its moment. 

## Affectations and *La Traviata*

In the meantime the Philharmonia Orchestra of New York (PONY) offered a two-performance run of Verdi's *La Traviata* recently. According to the press release, it was to feature holographic settings, cutting-edged lighting and 3-D settings on a mega screen. If the Callas concert is based on illusion, this PONY effort was knee deep in affectation. 

Images, moving and otherwise, appeared on a scrim in front of the stage and on a rear screen. Nothing appeared remotely 3-D except for a short appearance by a large pillar and an origami inspired bull. Standard issue rock concert lighting and audience blinding twirling spotlights were more annoying than cutting edge.

The promised 3-D sets consisted mainly of photographs of a luxurious hotel room, an empty restaurant and an interior that looked like a page from an IKEA catalog. Film and animation projections included aerial footage of Manhattan and Niagara Falls by night, streaming stardust, cascading rose petals and an ascending angel. The cumulative result was purported to smash opera conventions. They remained intact.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463579271/EJL-180320-1875.jpg.jpg)
<figcaption>Alex Richardson as Alfredo and Karen Chila-ling Ho in the PONY production of Verdi's *La Traviata*. © 2018 ed Lefkowicz / lefkowicz.com.</figcaption>
</figure>

Karen Chia-ling Ho sang Violetta. Her voice, while yet to fully blossom, has a strength that was able to surmount, if not yet soar, through, the vocal challenges that are part of Violetta's vocal baggage. She was more at home with the redemptive aspects of our heroine than of the thrill-seeker and was graceful throughout. At times she should have been directed to be less so. Her scene with Germont, the father of her lover Alfredo, chillingly sung by Robert Kerr, was especially forceful and perhaps the most moving moment in the production. A winner of the Eastman School of Music's Renee Fleming Award, Miss Ho will sing Violetta on tours in Japan and Taiwan this year. Surely this experience will sharpen both her vocal and interpretative skills. 

Alex Richardson's Alfredo was nicely matched. While he was singing his heart out in the second act, the silhouette of a cat levitating across the rear screen, elicited chuckles from the audience. Mr. Richardson maintained his pained dignity throughout the cat's appearance. He earns admiration, as much of his ardent Alfredo as for his composure. He and Miss Ho provided a lovely vocal blend that somewhat compensated for a general lack of passion throughout the production. Mr. Richardson made his Metropolitan Opera debut as the shepherd in 2016's *Tristan und Isolde*. This month he sings Falminio in New York City Opera's *L' Amore del Tre Re*. Alfredo was an opportunity of which Mr. Richardson took full advantage. 

Project Hand in Hand, partnering with PONY, provides performance opportunities to choral students from the East Japan disaster areas. This is a laudable initiative. As the Hand in Hand Chorus 2018, these young singers possess an immediate charm, impressive vocal precision and a physical energy, all of which, under other circumstances, would be most welcome. The group, however, was not suited to portray the demimonde that the chorus in La Traviata represents. They would be lovely, indeed joyous, to see and hear in so many other vehicles, or just being themselves.


<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463139742/GerDancerVio.jpg.jpg)
<figcaption>Robert Kerr as Germont, modern dancer, Kiki Cat and Karen Chila-linh Ho as Violetta in the PONY production of Verdi's *La Traviata*. © 2018 ed Lefkowicz / lefkowicz.com.</figcaption>
</figure>

Atsushi Yamada's conducting was efficient and meticulous, though he did not imbue Verdi's score with an inner life to express the corrupt society surrounding Violetta. He supported the singers with lilting strings and tempos that kept the production moving. There was a sense that the singers, the orchestra and the stage direction were similarly shaped but that in the end they never aligned to form a whole. Perhaps the focus on technology kept them apart.

The technical effects compromised what was otherwise a respectable *La Traviata*. The artistic forces behind the production seemed more intent on creating a high-energy spectacle rather than a powerful romantic tragedy. At times the effects undercut the efforts of its earnest singers. PONY would do well to focus its resources on what it does best--providing a forum for emerging musicians, in this case, opera singers, just as it does with the orchestra and through its Hand to Hand choir partnership.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463532236/Ring-of-Fire.jpg.jpg)
<figcaption>Larrson Suzuki dances with a ring of fire in the PONY production of Verdi's *La Traviata*. © 2018 ed Lefkowicz / lefkowicz.com.</figcaption>
</figure>

The evening was not a complete technical overstatement. A few elements reached beyond affectation to the level of serviceable effects. Rear screen close-ups of Violetta and Alfredo gave the production an intimacy that it otherwise lacked. A bullfighter, athletically danced by Larrson Suzuki, energetically took control of a projected flaming ring of fire on the scrim and elegantly dispatched the 3-D bull. 

Throughout the production, an expressive modern dancer, Kiki Cat, vividly depicted Violetta's journey and transformation through choreography that alternately showed exuberance and exhaustion. Using dance in the service of the libretto, rather than interrupting it as dance often does in opera, was the most innovative aspect of the evening. Happily, both dancers were as warmly received as the singers and chorus at the curtain call.

## *Cav/Pag* in Black & White and Technicolor

The curtain calls received rapturous response at the 2015 Salzburg Easter Festival after the performance of the double bill of *Cavalleria Rusticana* and *Pagliacci*. This is a production, marked by cinematic invention that sets a standard for the infusion of video technology in opera. It is also the *Cav/Pag* role debut of superstar tenor, Jonas Kaufmann and can be viewed to great effect on a DVD that is widely available from Sony Classical.

Stage director and set designer, Philipp Stolzl's melding of these two verismo mainstays jolted the senses with a stage design that included six playing areas on two levels. Scene changes flowed as smoothly and as frequently as motion picture fades. Close-up projections heightened the passions of the operas. The stage areas, often combining to form one larger area on the lower level, alternately offered atmospheric material in addition to close-ups, and simultaneous happenings. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463170594/vlcsnap_Pictures_cavandpagsalzburgnoredbull00053.jpg.jpg)
<figcaption>In *Cavalleria Rusticana*, Turridu (Jonas Kaufmann), left, is having an affair with Lola, wife of Alfio (Ambrogio Masteri). Turiddu has just bitten Alfio's ear, signifying that one of them must die as a result of a duel with knives, according to "country honor." ©2016 Unitel Classica/Sony Classical.</figcaption>
</figure>

Viewing the DVD, it is apparent that Stolzl, also a film and music video director, had a broadcast audience in mind. The DVD periodically shows the Salzburg audience and the entire stage, and then follows the action to the individual areas. With wide panning shots we have a feeling for what is was like to be in the audience and to fully experience the impact of the projections and sleek scene changes. The veteran video director is Brian Large.

*Cavalleria Rusticana* unfolds with the look of a black and white film with backgrounds that suggest Lyonel Feininger paintings. In village scenes the effect is Felliniesque while in interior settings, it evokes the starkness of Ingmar Bergman. Such broad homage works effectively in this context. Costume designer, Ursula Kundra sticks to the black and white concept, daring into grey and prints to achieve a country village look. 

Kaufmann, as Turiddu, after what appeared to be a slightly unsteady start, though it may have been his intense acting, is charming and desperate in equal doses. He is sadly, and at times, hysterically aware of where his passion will lead him. Ludmyla Monastyrska as Santuzza, his wronged wife, lets loose with her own desperation, which is of the demented, kitchen-sink variety. 

After intermission, or rather a change of disks in this two DVD set, the curtain rises on a garish, Technicolor inspired *Pagliacci*. While *Cav* wraps itself in the black and white of strict behavioral codes, *Pag* is about the consequences of unhinged passions and tempers. Of course it plays in color, as close to gaudy Technicolor as stage reality can get, and what a visual shock it is. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463183303/vlcsnap_Pictures_cavandpagsalzburgnoredbull00060.jpg.jpg)
<figcaption>Here is an audience view of the six playing areas used in both *Pagliacci* (pictured here in garish colors) and in *Cavalleria Rusticana* in somber black & white settings. The lower sections combine to create a larger playing area while all include screens for close-ups and other projected material. ©2016 Unitel Classica/Sony Classical.</figcaption>
</figure>

Kaufman rages as Canio and his dark tenor issues a predictably show stopping "Vesti la gubba." Despite its familiarity, Kaufmann's interpretation disturbs. Stolzl gives Cannio's wife, Nedda, a seething Maria Agresta, and the other characters in Pag's overheated commedia troupe, their due with erotically charged stage movement that brings the proceedings to a fever pitch. Canio's savagely painted scar of a smile is harrowing in projected close-up in the house, and on the home screen.

You may wish to turn up the volume or use earphones to fully appreciate Christian Thielemann and his Dresden orchestra and chorus. Eschewing their reputation for Wagner and Strauss, Thielemann and his group reach the romantic high of Italian opera with this Mascagni/Leoncavallo program. Their playing is full of rich volume and contrast. In gorgeous harmony with Stolzl's cinematic concept, it brims with dark and then colorful expressiveness, but never overflows, or for that matter, overlaps between the two operas. Technology aside, how marvelous it is to hear Kaufmann and the vocal crew joined with such orchestral and choral opulence. 

Here motion picture technology plays a conceptual as well as technical role in shaping this *Cav/Pag* and the results are stunning to the eye and ear. Undeniably, this all took place in one of the most operatically advantaged environments in the world, but the lessons are transferable.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1522463202463/vlcsnap_Pictures_cavandpagsalzburgnoredbull00106.jpg.jpg)
<figcaption>Jonas Kaufmann as Canio in *Pagliacci* who has discovered his wife's infidelity and contemplates how to punish her and her lover. ©2016 Unitel Classica/Sony Classical.</figcaption>
</figure>

From these hither and yon sources, it becomes apparent that technology in opera is something of an unfolding mystery and a double-edged sword. Certainly we appreciate the massive accessibility that opera, via video and broadcast, has gained. We know that technology can enhance its story-telling capabilities and make the overall experience more exciting, thus meeting the demands of today's opera audiences. We know too, that the myriad temptations of technology, to which opera productions on all scales are prey, can overshadow what is most important when not employed with sensitivity. And over 40 years after her death, the spirit of Maria Callas continues to loom, with renewed anticipation.
