+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = 2022-01-26T05:00:00Z
disclaimer = ""
image_gallery = []
postamble = "_P.S. Hilariously,_ [_this_](/help-the-pandemic-has-made-me-opera-conservative/) _is how I felt about everything about four months ago._"
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1643223547/media/2022/01/Beethoven_yshnak.jpg"
primary_image_credit = ""
related_articles = ["articles/covid.md"]
related_companies = ["scene/companies/houston-grand-opera.md", "scene/companies/los-angeles-opera.md", "scene/companies/lyric-opera-of-chicago.md", "scene/companies/the-metropolitan-opera.md", "scene/companies/l-opéra-de-montréal.md", "scene/companies/edmonton-opera.md", "scene/companies/vancouver-opera.md", "scene/companies/calgary-opera.md", "scene/companies/canadian-opera-company.md"]
related_people = []
short_description = "In the before times, I was all for stories that had big emotions and swept me out of reality; now, it feels futile to expect that a great high note can affect us with the same ease that it did before we all lost ourselves to a public health emergency."
slug = "opera-creeps-back-to-canada-it-reminds-me-of-beethoven"
title = "Opera creeps back to Canada & it reminds me of Beethoven"
youtube_url = ""

+++
Who else wants off the rollercoaster?!

Readers, if you're like me, you've become a hardened version of an opera fan. You swat away feelings of hope when you see a season announcement from a major company. You read about last-minute show cancellations  - or last-minute virtual pivots - with an audible amount of _yeah, seems about right_ in your resigned sigh.

Elsewhere in the world, things seem less dire. European (read: German) companies are up and running, switching on and off for periodic closures as needed because they have robust state funding models. And in the US, things are effectively open, with full seasons coming out of Chicago Lyric, Houston Grand, and LA Opera. The Met even managed to make some history with its 2021-22 opener, Terence Blanchard's _Fire Shut Up in my Bones_.

In Canada, the return is certainly slower. Our funding model doesn't allow for quick pivots à-la-Oper Frankfurt. And if we're being brutally honest, we're seeing the effects of living in a culture that simply does not prioritize the arts, let alone when the industry is in trouble.

> It feels futile to expect that a great high note can affect us with the same ease that it did before we all lost ourselves to a public health emergency.

So when opera does appear to be trickling back (Omicron waves notwithstanding), one shouldn't be a choosy beggar, right? I can't help but notice, though, that the in-person productions Canadian companies can afford to put up are operas that feel really far away from life right now.

The COC's hybrid season was set to feature in-person shows starting with _Madama Butterfly_ in February 2022 (now offered digitally, because Omicron), followed by Arin Arbus' _La traviata_ and Diane Paulus' _The Magic Flute_. All three are COC-owned productions, which makes sense because I imagine funding is tight.

Across Canada, it's a similar situation. Calgary's [_Merry Widow_](https://calgaryopera.com/21-22/merry-widow) opens this week, and its _Traviata_ will follow in April. Edmonton is rolling out [_Bohème_](https://www.edmontonopera.com/2022/boheme) next month, with _Così fan tutte_ soon after. In [Vancouver](https://www.vancouveropera.ca/), it was _Orfeo ed Euridice_, with _Cavalleria rusticana_ and _H.M.S. Pinafore_ on the 2022 horizon. In [Montreal](https://www.operademontreal.com/en/shows/2021-2022-season), it was going to be _Traviata_, but at least _Magic Flute_ is still in the plans.

All low-risk picks; _Bohèmes_ and G&S have always put the bums-in-seats.

And the reasoning is clear: money is tighter than ever, artists can't travel as freely, and the best laid plans are subject to destruction at any moment. It's not the time to gamble on new opera, or even 21st-century opera, despite its exciting lurch toward real relevance in the last 10 years. It's not even the time to try out a fun new co-production, apparently. I imagine donors are dropping away, and the wiggle room for adventure seems razor-thin.

But these tried-and-true operas just... don't land right. We've always craved art that says something about the world around us, and as much as we may love them, these operas don't offer much to a COVID-stricken society.

But when you think about it, it's almost hilarious to consider showing up for a _Traviata_ after the two years we've all just had with all the destruction and loneliness and dismay. In the before times, I was all for stories that had big emotions and swept me out of reality; now, it feels futile to expect that a great high note can affect us with the same ease that it did before we all lost ourselves to a public health emergency.

Here's a little story for you:

For one of my Master's degree recitals (hay, Don Wright Faculty of Music!) I programmed Beethoven's [Cello Sonata No. 3 in A Major, Op. 69](https://www.youtube.com/watch?v=X9pivx91mVk). As I practiced and practiced, I noticed that for an opus sixty-nine, the thing sounded pretty darn rudimentary. Like, closer to Haydn and Telemann than anything Beethoven is known for. This Cello Sonata is super tonal with clear structural guidelines, full of the kind of safe rule-following that's very weird when we consider that by this point, Beethoven had already written his _Eroica_ Symphony and both the _Waldstein_ and _Appassionata_ Piano Sonatas.

> Maybe we're like Beethoven: out of necessity, we're going with the better-safe-than-sorry option, even though it doesn't say anything new.

What was with the shift backwards, I wondered? Turns out: he was going deaf. Beethoven wrote the A Major Cello Sonata around 1808, a handful of years after he started losing his hearing. And if you were a revolutionary composer who could no longer trust his ears, what would you do? You'd trust music theory, and you'd write what works on paper. At least until you get used to writing without your ears, and you finally branch out again and end up with a [_Große Fugue_](https://en.wikipedia.org/wiki/Grosse_Fuge)_._

The history nerd in me was thrilled to have found a reason - or at least a plausible theory - why Beethoven went from bold to safe so abruptly, mid-way through his career. But the human in me was heartbroken that there was this trail of breadcrumbs in Beethoven's composing, where we could (ironically) hear the man go deaf, go from bold innovator to timid form-follower.

I remembered that story when piecing together my thoughts on the current state of things in Canada's opera scene. Maybe we're like Beethoven: out of necessity, we're going with the better-safe-than-sorry option, even though it doesn't say anything new. I understand the decision; I just mourn the fact that we're making it because we're in precarious health.

It's worth remembering that Beethoven's conservatism, brought on by deafness, was only temporary. He went on to write the _Missa Solemnis_ and _Fidelio_ and the Ninth Symphony, after all; so maybe we're in for a fresh bout of revolution?

<figure data-type="video">{{% md %}}<iframe width="840" height="630" src="https://www.youtube.com/embed/X9pivx91mVk" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>{{% /md %}}

</figure>