+++
author = ["authors/john-hohmann.md"]
categories = "Review"
date = "2018-04-29T19:51:00-04:00"
lastmod = "2018-04-30T17:55:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525044907322/sqDSC_7132_preview.jpg.jpg"
primary_image_credit = " Mila Henry (piano) and Kacey Cardin perform \"Inhibitionist\" by Rachel Peters. Her Kind, Opera On Tap, 2018. Photo: Laura Thomson."
publishDate = "2018-04-29T20:49:00-04:00"
related_people = ["scene/people/kacey-cardin.md","scene/people/chelsea-feltman.md"]
short_description = "Her Kind opened mysteriously enough as the sopranos entered costumed in dissimilar black outfits, their heads covered in grey veils. Standing strategically around the periphery of the playing area, they produced a polyphonic sound evoking the solemnity and religiosity of Hildegard&#039;s composition concerning salvation and the Virgin Mother."
slug = "opera-on-taps-her-kind-music-a-beer"
title = "Opera On Tap&#039;s Her Kind: music &amp; a beer"
+++

Hildegard von Bingen, that ever-relevant 11th-century saint, who was an author, mystic, poet, theologian, and, among other things, a composer, would likely be pleased with the company she keeps in *Her Kind, A Classical Cabaret Celebrating Womankind*, presented by the agile and intelligent Opera On Tap, New York. In residence at the Flea in Tribeca, its gracefully produced and thought-provoking evening began with the company's five sopranos singing Hildegard's "Quia ergo feminia," part one, arranged by company director and *Her Kind* creator, Sara Noble.

The sopranos are Elena Armijo, [Kacey Cardin](/scene/people/kacey-cardin/), [Chelsea Feltman](/scene/people/chelsea-feltman/), Cameron Russell and Krista Wozniak, singers with strong and polished voices, each having a distinct quality that was revealed throughout the evening. Fortunately they are also versatile, which is vital, considering the assortment of music and texts involved. Music director Mila Henry showed that she shared this talent to adapt with supportive accompaniment at the piano from which she also conducted.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525045416815/DSC_6952_preview.jpeg)
<figcaption>Elena Armijo, Krista Wozniak, Mila Henry (at piano), Chelsea Feldmann, Cameron Russell, and Kacey Cardin perform "She Was Warned" by Catherine Aks. *Her Kind*, Opera On Tap, 2018. Photo: Laura Thompson.</figcaption>
</figure>
 
*Her Kind* opened mysteriously enough as the sopranos entered costumed in dissimilar black outfits, their heads covered in grey veils. Standing strategically around the periphery of the playing area, they produced a polyphonic sound evoking the solemnity and religiosity of Hildegard's composition concerning salvation and the Virgin Mother.

Janet Cardiff's audio installation, *The Forty Part Motet*, came to mind. Installed a few years ago at The Cloisters, the Metropolitan Museum of Art's medieval branch, it consisted of forty high-fidelity speakers arranged in a spacious oval, each emitting a voice of a Thomas Tallis motet. Here, the vocal blend took on a similar technological air, a subtle yet visceral reminder of Hildegard's enduring presence that grabbed the audience.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525045784338/DSC_6855_preview.jpeg)
<figcaption>Elena Armijo and Kacey Cardin sing Hildegard von Bingen. *Her Kind*, Opera On Tap, 2018. Photo: Laura Thompson.</figcaption>
</figure>

Then came a number that can best be described, in cabaret terms, as a change of pace. The singers raised their veils and three of them, Elena, Krista and Cameron (the printed program put us on a first-name basis with the company) accompanied by Mila, performed "The Cooking Trio" from the Okoye/Cote opera, *We've Got Our Eye On You*. Close, comical harmony coupled with seductive energy and rollicking piano work, did not salvage this remedially rhymed tune. The energy of the singers might have been better utilized had they tapped into the kitschy verve of the Andrews Sisters and applied it to Stephen Sondheim's earlier song of similar sentiment, "A Little Priest."

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525045446595/DSC_6905_preview.jpeg)
<figcaption>Chelsea Feltman speaks Sappho's poem, "Fragment 31". *Her Kind*, Opera On Tap, 2018. Photo: Laura Thompson.</figcaption>
</figure>

Three pieces by Evan Mack, the composer of the acclaimed opera, *Angel of the Amazon* and the anticipated *The Ghosts of Gatsby*, included selections from his song cycle, *Preach Sister, Preach* with words supplied by Simone de Beauvior, Mae West, and Lucille Ball. Elena's interpretations punctuated the evening, shaping characters as well as songs. 

Chelsea and Krista gave Sappho's poem about her love for another woman, "Fragment 31," a fervent reading with Mila's sensitive accompaniment, followed by Francis Pollock's "Weaving", in which her direct composition illuminated the ancient poetess' lyric drive.

Anne Sexton's confessional poetry, "Her Kind," with music by Christopher Berg and Gilda Lyons' setting of "Seven Times," received poignant renditions by Krista and Chelsea respectively. Dorothy Parker's "The Red Dress," an enigmatic poem set by Ricky Ian Gordon, was sung with a tart wistfulness by Kacey who was so quietly compelling in "Inhibitionist." This is a work with music and lyrics by Rachel Peters that especially rewarded our close attention. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525045601369/DSC_6962_preview.jpeg)
<figcaption>Elena Armijo sings “Mae West” from the cycle *Preach Sister, Preach* by Evan Mack. *Her Kind*, Opera On Tap, 2018. Photo: Laura Thompson.</figcaption>
</figure>

Lyons' deeply felt composition for Elizabeth Cunningham's exquisite "Prayer," received heart-stopping harmonizing by Elena, Chelsea, and Cameron. I can think of no more fitting praise then to say that the amity of these three women reminded me of the Trio recordings by Dolly Parton, Linda Ronstadt and Emmylou Harris, that remain unmatched in the realm of collaborative music-making.

Perhaps at this point it is appropriate to mention U.S. Senate majority leader and accidental lyrist, Mitch McConnell. Catherine Aks has composed a song in the form of Gregorian chant that enshrines McConnell's admonishment of Senator Elizabeth Warren and her filibuster on Jeff Sessions' Attorney General nomination. "She was warned, she was given an explanation but she persisted," sang the company with glorious gravity and satiric edge. One day it may become the first campaign song in the style of a Gregorian chant.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1525045617397/DSC_7221_preview.jpeg)
<figcaption>Krista Wozniak, Chelsea Feltman, and Cameron Russell perform *In Twenty Minutes* by Frances Pollock. *Her Kind*, Opera On Tap, 2018. Photo: Laura Thompson.</figcaption>
</figure>

Hildegard closes the cabaret with part two of "Quia ergo femina" sung by the company. The saint's composition was a spiritual wrap-around for *Her Kind*. In between there was so much more that has gone without mention. Suffice it to add Menotti's "Steal me, sweet thief," from *The Old Maid and the Thief*, sung by Elena and "Come My Way, Go Yours" with music by Ellen Mandel, to a poem by Glyn Maxwell, both of which were performed so effectively by the company.

There were topical pieces too, including "Introducing That Most Marvelous Human Freak, The Bearded Lady Miss Lupin," with music by Christopher Berg to a poem by Clare Pollard and "In Twenty Minutes," music and text by Frances Pollock, that spoke so powerfully to social issues. Cameron sang them with currency and theatrical flair.

*Her Kind* succeeds on its own ambitious terms and adheres to Opera On Tap's credo that the power of the human voice is best appreciated from about 20 feet away, with a beer in hand, as Sara Noble told us before it began. That casual approach belies the fact that the organization plays a crucial role in promoting and communicating the work of today's composers. Classical music, especially contemporary operatic music, is alive and well within this organization. Hopefully *Her Kind* and future shows like it will continue to seduce audiences with their intelligent and welcoming presence. 
