+++
author = ["authors/gianmarco-segato.md"]
categories = "Editorial"
date = "2015-06-11T20:47:00-04:00"
lastmod = "2015-06-13T13:14:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1434070561606/mefistofele_053_resize_Zs%C3%B3fia-P%C3%A1lyiSquare.jpg.jpg"
primary_image_credit = "A scene from Mefistofele at the Hungarian State Opera. Photo by Zsófia Pályi."
publishDate = "2015-06-13T10:45:00-04:00"
related_articles = ["articles/can-nycs-opera-scene-take-good-advice.md","articles/don-giovanni-at-the-estates-theatre.md"]
related_companies = ["scene/companies/hungarian-state-opera.md"]
short_description = "In late May I had the opportunity to experience opera from an entirely different viewpoint from which many of us are accustomed to in larger North American opera centres. I spent 10 glorious days in Budapest, attending operas, concerts and recitals in a variety of stunning venues, listening to a wide range of soloists, orchestral and choral ensembles in productions that simply blew the mind of this Torontonian."
slug = "opera-on-steroids-budapest"
title = "Opera on Steroids: Budapest!"
+++

In late May I had the opportunity to experience opera from an entirely different viewpoint from which many of us are accustomed to in larger North American opera centres. I spent 10 glorious days in Budapest, attending operas, concerts and recitals in a variety of stunning venues, listening to a wide range of soloists, orchestral and choral ensembles in productions that simply blew the mind of this Torontonian. 

My goal was to soak in an old-school, European ensemble company, in this case the Hungarian State Opera; the company presents a staggering 600 performances per season, utilizing a more or less stable roster of (mostly Hungarian) soloists, choral singers and orchestra members. International “star” name singers are pretty well M.I.A. compared to what we are used to in larger, North American opera companies these days. You don’t see many of usual suspects – the Alice Cootes, Isabel Leonards, Anna Netrebkos, Jonas Kaufmanns, Sondra Radvanovskys, who populate the rosters of companies in Chicago, Toronto, New York and San Francisco. I wondered – how might this affect my opera experience; what would the quality be like; would I miss hearing the very high level of singing I’ve become so used to (and privileged) to experience in my home town?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1434070633468/Der%20Freischutz_2.jpg.jpg)
<figcaption>A scene from the Hungarian State Opera's Der Freischütz. Photo by Attila Nagy.</figcaption>
</figure>

The answers to this are not cut and dry. Most of the singing I heard was of a very high caliber – with (as one would expect) some stand-out performances. Singers like bass Gábor Bretz, who was a supremely menacing (and tall!) Mephistopheles, gloriously sung in a new production of Gounod’s *Faust*; house soprano Beatrix Fodor sang the bejesus out of Agathe’s notoriously challenging arias in (another) new production of Weber’s *Der Freischütz*, and the more dark-voiced, dramatic soprano, Gabriella Létay Kiss as an intensely moving Margarita in Boito’s *Mefistofele*. 

As memorable as these individual performances were, the true stars of these three “chorus” operas were indeed, the hard-working singers in the chorus themselves. They were 80 strong in both the Gounod and Weber with their numbers swelling to close to 100 for the Boito – yes, my jaw dropped as well! Their sound was awesome and overwhelming – the famous, almost entirely choral opening act of *Mefistofele* blew the audience away as angels and devils fought it out and their collective sound, literally raising the theatre’s roof. Similarly, the musical commitment of the orchestra at all these performances was palpable – I’ll never forget seeing some of the musicians gleefully smiling and swaying to the jaunty tunes of *Faust*’s ballet music (almost unbelievably played in its entirety and fully choreographed!).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1434070767704/Mefistofele_2.jpg.jpg)
<figcaption>A scene from the Hungarian State Opera's Mefistofele. Photo by Zsófia Pályi.</figcaption>
</figure>

Can I mention the productions themselves? All three were entirely contemporary, carefully-considered interpretations with no whiff of the routine. In the *Faust*, Marguerite’s lower social status was convincingly established by making her a char woman at an expensive golf resort. You probably needed a more intimate knowledge than I possess of recent 20th century Hungarian history to understand *Der Freischutz*’s critique of that country’s Communist era – but it was bracing and compelling nonetheless. *Mefistofele* was simply the most extravagant, spectacular opera production I’ve ever seen. To give you an idea, the centerpiece of the set was a massive, 5-storey metal helix built to hold 120 people, that was also equipped with a handy central elevator! 

The Hungarian State Ballet was featured prominently in all three productions – one of the advantages I suppose of integrating your national opera and ballet troupes more as one company, sharing the same theatres, presenting productions in continual rotating repertory (very different for example, than the complete independence that exists between the Canadian Opera Company and the National Ballet of Canada here in Toronto).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1434071433837/HSO.jpg.jpg)
<figcaption>Nice digs at the Hungarian State Opera.</figcaption>
</figure>

The system of producing opera in Budapest (and by extension, in the Czech Republic and many smaller cities in Germany, Austria and Switzerland) is obviously very different than in North America. A resident company of artists means you might hear a singer take on a major, starring role one night and then a smaller, supporting comprimario role the next (as I experienced with the excellent young baritone Haja Zsolt as Valentin in *Faust* and then a couple nights later, in a walk-on part in *Der Freischütz*). It was clear that local audiences cheer their favourites who they have heard sing many roles in any given season. 

The huge scale of these productions seems possible in part due to considerable government funding (although many in the arts express financial concerns due to the political bent of the current Hungarian regime) and by North American standards, much lower rates of pay. Overall, I sensed a huge pride both on the part of the singers and musicians and the audiences for whom they performed. It was thrilling to be part of a crowd that showed their appreciation by clapping in unison, calling back singers again and again with their ovations. This reaction reconfirmed for me the importance of experiencing music live, with other people, of moments in time that can never be recreated again.
