+++
author = ["authors/blanche-isral.md"]
categories = "Op-ed"
date = "2015-10-15T23:17:00-04:00"
lastmod = "2015-10-17T13:24:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1444965675752/GriefSquare.jpg.jpg"
publishDate = "2015-10-16T08:00:00-04:00"
related_articles = ["articles/the-future-of-opera-is-indie.md","articles/tosca-the-nyco-renaissance.md","articles/a-diction-lesson-french-canadian-swearing.md"]
related_companies = ["scene/companies/opera-lyra-ottawa.md"]
short_description = "There has been a distraught and saddened buzz in the opera community ever since Opera Lyra announced an immediate halt of its 2015-2016 season due to severe budget shortfalls. As the opera world absorbs this difficult hit, reactions on social media are evolving in line with the five stages of grief."
slug = "opera-lyra-and-the-five-stages-of-grief"
title = "Opera Lyra and the Five Stages of Grief"
+++

There has been a distraught and saddened buzz in the opera community ever since [Opera Lyra](/scene/companies/opera-lyra-ottawa/) announced an [immediate halt](/opera-lyras-immediate-shutdown/) of its 2015-2016 season due to severe budget shortfalls. As the opera world absorbs this difficult hit, reactions on social media are evolving in line with the five stages of grief:

### 1. Denial: No...

Many people, including myself, were extremely shocked by the press release. But when you look at the facts, Opera Lyra was actually founded in response to the National Arts Centre removing opera from its offering over three decades ago. They were always operating in semi-rebellion, and that spirit should have remained their driving force. Since then, Opera Lyra has spent more than half of its existence fighting deficits, with the most recent 2011 hit coming as a result of the 2008 economic downturn. Jeffries has used the words "baffled", "puzzled", and "surprised" when describing how the recent *Barber of Seville* fell flat, but at the end of the day, an entire organization depending on the success of one Rossini “garden-variety updating” (Jeffries’s words) is a very dire situation.

### 2. Anger: This is all Harper’s fault! 

I know, I know...it feels great to have a scapegoat. But it isn’t (only) the government’s fault. As Opera Lyra specified, their issues spanned all revenue sources, the major problems being commercial sponsorships and an unexpected drop in ticket revenue. Although they were in part affected by decreased government revenues, a different government would likely have only stalled the inevitable.

### 3. Bargaining: Maybe they can make a comeback?

Opera Lyra hasn’t actually closed or folded or filed for bankruptcy – at least not yet. With the big announcement, Opera Lyra is basically saying "big donors, speak now or forever hold your peace." General Director Jeep Jeffries actually told reporters today that if anyone offered the company $200,000, they’d be "back in business tomorrow". Opera Lyra’s official plan is now to look into "lower cost models, or wider partnerships". And, considering the organization’s size, and some comments by the mayor, it seems at least somewhat likely that something opera-related will rise from the ashes in some form or another, with a new, more suitable strategy. A year from now, this may end up looking like [San Diego Opera](/scene/companies/san-diego-opera/) (who, by the way, have pulled a 'phoenix' move of their own. In a nutshell, after an announcement that San Diego Opera was going to close at the end of their 2014 season, the artistic director left, and the organization received a tidal wave of support that enabled them to rescind the decision. They are presenting a reduced version of their planned 2015-2016 season.)

### 4. Depression: Opera is dying ☹ 

A few months back, addressing the Big Opera phenomenon, I [wrote](/the-future-of-opera-is-indie/): I have no patience for arts organizations playing the pity card. This is because I truly believe that opera is a living, breathing artform, not just a museum curiosity. Storytelling through song and staging is pretty much the oldest form of art there is. Creation and performance are fundamental to the human experience, directly following the need for food and shelter in our evolution. I stopped feeling sorry for opera when I realized this. 

In today’s environment, an organization can no longer hide behind laurels or tradition. New audiences are not any dumber, and if that is how you see it then you’re right in line with patterns of thinking a thousand years strong. Actually, today’s audiences are more demanding, and their demands are, as always, evolving. The only difference is that the evolution is happening faster than ever, alongside everything else in our society. In the early years, Opera Lyra made a choice to take the route of Big Opera – presenting traditional operas the traditional way, aiming for the big expensive hall, depending on old-guard donors – because it made sense to them in the 1980s climate. But today’s climate is vastly different, so the presenting model should also be vastly different.

### 5. Acceptance: Now is the time to find the boldest young, diverse arts leaders in this country, and let them lead the way.

Opera is one of the hardest types of art to organize and manage. It always has a million plates spinning. It often requires a cast and an orchestra with specific and demanding tasks, unions and specialized venues with some of the most stringent regulations and fees, the right people behind it to fundraise and market and communicate the message, and a lot of last-minute risk. It can be easy for organizations to become crippled under the weight of tradition. And, unlike in many other artforms, Canadian companies can’t mitigate risk by spreading it out over dozens and dozens of productions in a year. Even the largest opera companies in this country only put on between four and six productions in a season. 

For-profit organizations are simple to manage, because you can take one glance at a financial statement and recognize, by the dollars and cents, when it no longer makes sense to stay the same. Not-for-profit organizations have so many more layers than just the bottom line, so things can get cloudier. But the principle is the same: evolve or get left behind. That can mean a lot of different things in the arts. We need to not only listen to, but also encourage and employ big thinkers from younger, more diverse communities who really understand the core of the art form. These people belong in arts management positions with enough agency and authority to take action on fresh approaches.

Opera is at an exciting crossroads, as evidenced by the amount of [independent opera companies](/scene/companies/indie-opera-to/) popping up. Opera Lyra has taken one approach, which was to try to wow audiences with big Canadian singers and big productions with full orchestra in the NAC. They have struggled with that approach for years now. After yesterday, I trust that they are ready to sit down and evaluate whether a "garden-variety updating" was what their community needed. And I hope that when the Ottawa opera community rises up again, they will put absolutely everything back on the table, and invite a lot of fresh blood. 
