+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2018-10-31T13:23:00-04:00"
lastmod = "2018-11-02T09:56:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541012736000/sq_KLH3942a.jpg.jpg"
primary_image_credit = "Jonas Kaufmann as Dick Johnson in La fanciulla del West, Metropolitan Opera, 2018. Photo: Ken Howard/Met Opera."
publishDate = "2018-11-02T09:56:00-04:00"
related_companies = ["scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/jonas-kaufmann.md","scene/people/evamaria-westbroek.md"]
short_description = "It&#039;s funny how similar the opera-going experience is, be it at an opera house or the movies. Older audience members still kvetch about the venue - &quot;They should have it at TIFF,&quot; et cetera - and there&#039;s the usual mixture of apologies and harumphing as latecomers squeeze past their neighbours&#039; knees to find their mid-row seats."
slug = "opera-laid-bare-for-better-or-for-worse-in-the-mets-fanciulla"
title = "Opera laid bare, for better or for worse in the Met&#039;s Fanciulla"
+++

It had been a good handful of seasons since I last saw a live cinema broadcast in the Metropolitan Opera's *Live in HD* series. I had contented myself with the Met's *On Demand* collection, watching the archived videos on my own time, on my own couch. But for [*La fanciulla del West*](https://www.metopera.org/season/2018-19-season/la-fanciulla-del-west/) - and a bit for Jonas Kaufmann, I admit - I made the trek to my nearest Cineplex theatre.

It's funny how similar the opera-going experience is, be it at an opera house or the movies. Older audience members still kvetch about the venue - "They should have it at TIFF," et cetera - and there's the usual mixture of apologies and harumphing as latecomers squeeze past their neighbours' knees to find their mid-row seats. And the pre-show people watching is top-notch, when aided by the Met's HD cameras. In the panning of the crowd, I spotted a Kristine Opolais, and, I'm pretty sure, a Matthew Epstein. 

Once the show actually starts - in this case, the well-loved production of [*La fanciulla*](https://www.metopera.org/season/2018-19-season/la-fanciulla-del-west/) by Giancarlo del Monaco - it's as though the camera zooms in not only on the good, but the ugly.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541013037370/FAN_3491a.jpg.jpg)
<figcaption>A scene from Act I of *La fanciulla del West* with Eva-Maria Westbroek as Minnie, Metropolitan Opera, 2018. Photo: Ken Howard/Met Opera.</figcaption>
</figure>

The good: Jonas Kaufmann sounds like a million bucks. When he comes onstage, Kaufmann sets himself apart as the first real, layered character onstage - a tough thing to pull off when one is playing a dark, brooding cowboy with a habit of negging, named *Dick Johnson*. Kaufmann is suave, of course, but he's also acting voice-first; his return to the HD series came with a lot of anticipation, and it's exciting to hear someone live up to the hype.

Kaufmann's portrayal also pulled the best out of Eva-Maria Westbroek as Minnie. Westbroek is an utterly charming dork of a woman, whose life is firmly compartmentalised by the environments in which she's very comfortable (bartending, defusing the advances of many lonely men) and in which she's totally lost (dealing with her own feelings of butterflies for Johnson).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541012874032/_KLH4213a.jpg.jpg)
<figcaption>Eva-Maria Westbroek as Minnie and Jonas Kaufmann as Dick Johnson in *La fanciulla del West*, Metropolitan Opera, 2018. Photo: Ken Howard/Met Opera.</figcaption>
</figure>

The rest of this *Fanciulla* was underwhelming, and it's hard to pinpoint exactly why. This 1991 production was never created with an HD broadcast in mind - though in its on-camera presentation it reminds me oddly of the look of *Horace and Pete* - so perhaps we should be forgiving when the cameras pick up the outdated stage-isms, like lame fight choreography, and hokey acting better suited to a large theatre. And you could call them quaint pieces of opera voyeurism to see the minor staging fumbles, a rogue piece of fake snow stuck in a character's hair long after it should have melted.

Somehow, *Fanciulla* reveals more than many pieces why - as unfair a stereotype as it may be - opera is seen as stuffy and old-fashioned. The show is full of archetypes that seem a bit tired: the tough woman in a man's world, the black-hearted man in a position of power, the suave and mysterious stranger. There are a few nasty bits of racism that just need to be excised from the repertore: the Met wisely translated "Messicani" as "cutthroats" - although that's not necessarily a better term for "Mexicans" - but they mind-bogglingly kept in the horrid scene where we meet Wowkle and Billy, two indigenous Americans who speak *to each other* in what's meant to be broken English, with a scattering of bad grammar. Gross, and cringe-worthy no matter what way you look at it. It's an example of classic ≠ sacred.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541012885011/FAN_3251a.jpg.jpg)
<figcaption>Eva-Maria Westbroek as Minnie in *La fanciulla del West*, Metropolitan Opera, 2018. Photo: Ken Howard/Met Opera.</figcaption>
</figure>

Among those who go to see the Met's live cinema broadcasts, I wonder what the proportion is of total opera newcomers. My hunch is that the cinema audiences are pretty serious opera fans, the people who would certainly go to see the show live if they were closer to New York. These listeners likely have a huge advantage, compared to a first-time opera-goer: they've heard opera live, and thus they know its power.

I have a hard time believing that an opera newbie would be thoroughly impressed by a Met cinema broadcast. There's enough clumsiness in the product - particularly in dated offerings like *Fanciulla* - that it just doesn't stand up to the quality of other media one could see on the big screen (including musicals). Without knowing how powerful opera can be - something that's only obvious when you experience it live, and microphone-free - a cinema broadcast isn't quite enough to convince you. (Although for some, Jonas Kaufmann just might do the trick.)

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541012891479/FAN_4646a.jpg.jpg)
<figcaption>Željko Lučić as Jack Rance in *La fanciulla del West*, Metropolitan Opera, 2018. Photo: Ken Howard/Met Opera.</figcaption>
</figure>

None of this is to say that the Met's *Live in HD* series is a waste. It's a huge factor in connecting the opera world - the fans to the singers, and vice versa. And there's something totally fabulous about settling into a high-backed movie chair that slightly reclines, surrounded by movie food and great visibility no matter where your seat is. For opera fans, it's a total treat.

So maybe the answer is to split the difference: opera fans should bring their opera-newbie friends to the movies - in fact, the November 10 broadcast of Nico Muhly's [*Marnie*](https://www.metopera.org/season/2018-19-season/marnie/) might be a good pick - and follow it up with an outing to catch some live opera. If you're looking for recommendations on that latter bit, give us a shout at [hello@schmopera.com](mailto:hello@schmopera.com).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1541012897825/FAN_3466a.jpg.jpg)
<figcaption>A scene from Act I of *La fanciulla del West*, Metropolitan Opera, 2018. Photo: Ken Howard/Met Opera.</figcaption>
</figure>

>For the full line-up of the Metropolitan Opera's *Live in HD* series, [click here](https://www.metopera.org/season/in-cinemas/).
