+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2016-10-14T15:44:00+01:00"
lastmod = "2016-10-17T16:52:00+01:00"
preamble = "[Opera On Tap](/scene/companies/opera-on-tap/) is pairing episodic opera with virtual reality, with their new series, [*The Parksville Murders*](http://theparksvillemurders.com/). With music by Kamala Sankaram, libretto by Jerre Dye, and directed by Cari Ann Shim Sham\\*, *The Parksville Murders* is a horror opera, created specifically for a virtual reality experience. How cool is that? Audiences can tune in with their VR technology of choice (more on that below), to get both an entirely new operatic experience, while being completely creeped out.\n\nOn October 27, Opera On Tap is holding a [special preview event](https://www.eventbrite.com/e/the-parksville-murders-exclusive-preview-event-tickets-28072123477) at the Archway Under Manhattan Bridge, 80 Pearl St., New York, where audiences can watch the full pilot episode. [Click here](https://www.eventbrite.com/e/the-parksville-murders-exclusive-preview-event-tickets-28072123477) for tickets.\n\nWe spoke with Opera On Tap about the creation of *The Parksville Murders*, and how you can tune in."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476615477955/2016-10-16---PM-Square.jpg.jpg"
primary_image_credit = "Photo by Cari Ann Shim Sham*."
publishDate = "2016-10-17T10:28:00+01:00"
related_articles = ["articles/draculas-neighbour-nancy-allen-lundy.md"]
related_companies = ["scene/companies/opera-on-tap.md"]
short_description = "&quot;In episode 1, two young women (Sarah and Corrine) wake up confused and terrified in a dark, surreal, music-filled world of incongruities and evil intentions, a space where Time seems to have curved in on itself somehow. Grotesque, masked figures slowly gather around the two from the corners of the darkened room, ceremoniously awaiting the women’s fate.&quot;"
slug = "opera-in-virtual-reality-the-parksville-murders"
title = "Opera in virtual reality: The Parksville Murders"
+++

## What can you tell us about *The Parksville Murders*?

I can't say it better than our librettist Jerre Dye when he put together a series frame and synopsis for us, so I'm paraphrasing him here:

"Sometimes technology is older than you think. In *The Parksville Murders*, the VR viewer is given access to a secret, virtual space where the act of witnessing is essential in the perpetuation of an ancient and terrifying magic. Parksville, NY is not just a lonely, little, derelict town off Highway 17, it is a portal, a sacred virtual space where human suffering and sacrifice has become a communal and virtual act. Parksville is a place where you, The Watcher, have been given a front row seat to gaze upon the unthinkable. How will you choose to navigate this world?

In episode 1, two young women (Sarah and Corrine) wake up confused and terrified in a dark, surreal, music-filled world of incongruities and evil intentions, a space where Time seems to have curved in on itself somehow. Grotesque, masked figures slowly gather around the two from the corners of the darkened room, ceremoniously awaiting the women’s fate. As the thundering sonic world escalates and The Watchers descend upon them, one woman fights her way out, only to find that 'out' might be yet another illusion in this horrific, virtual universe. Will you help Sarah?"
 
## What does it mean to experience opera in virtual reality?

At its heart, virtual reality is a technology that immerses a viewer in the experience of a film.  It attempts to simulate a reality-based experience for a viewer by placing him or her in the middle of the room where the action is taking place.  Think of it as the tech industry's way of removing the fourth wall for audiences. It is taking immersive theater to the next level of innovation. When a viewer experiences opera in virtual reality, he or she is placed in the center of the set, surrounded by the characters of the story, and in our opera, the viewer becomes a part of the story.  

Additionally we're utilizing a cutting edge 3D audio technology called sound spatialization.  So when a viewer turns his or her head the sound adjusts to how it would sound in the actual space where the opera is taking place.  Imagine as a first-timer to opera, literally being bathed in operatic sound and surrounded by the story.  It's an amazing and transformative experience.  

How do you enter virtual reality?  Through a headset that is connected to your smartphone.  You can watch a video that is formatted for virtual reality on Youtube or Facebook, or via a custom app that is created for the VR film.  Headsets are as cheap as $15, i.e., Google Cardboard, and as expensive as $800, i.e., Oculus Rift. Oculus Rift has its own computer system and does not require a separate smartphone to operate.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476615578296/2016-10-16---PM-Cemetery.jpg.jpg)
<figcaption>Photo by Cari Ann Shim Sham*.</figcaption>
</figure>

## How was the rehearsal process for this project different than a more traditional opera production? 

The rehearsal process was very different, and much more like the process is for film.  We had to break the score down into a shot list, so when we filmed the opera we did so scene by scene rather than straight through. What did feel familiar was the actual singing in the space while on-set.  Our principal performers’ performances were captured live in the space while we filmed and the result is glorious, ambient and blooming.  That is what you will hear when you watch the film - those live-captured performances rather than a flat stereo -recorded version recorded in a studio.

## How many episodes will there be, and for how long will Opera On Tap make us wait for episode 2?

We're planning 12 episodes in season 1.  Episode 2 is several months away.  Episode 1 will go public in late January when we will take it on the film festival circuit.  We're calling it our pilot episode and hope to partner with a distribution platform post-festival run to finish the season.  Stay tuned!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476615637553/2016-10-16---PM.jpg.jpg)
<figcaption>Photo by Cari Ann Shim Sham*.</figcaption>
</figure>

## How does *The Parksville Murders* fit into Opera On Tap's mission?

Our company has always focused on finding ways to make opera more accessible to a broader audience. There is nothing about this project that doesn’t resonate with our mission.  We specialize in 'opera up close' and have created a national infrastructure for distributing that concept nationally. *The Parksville Murders* allows us to take a logical next step in not only utilizing the distribution channels we have created through our infrastructure but in further distributing opera to a larger national audience through cross-pollination of multiple genres and through the online accessibility of the content we create.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1476615726562/Opera%20on%20Tap%20FB%20Event%20header.jpg.jpg)
</figure>

>For more details, [click right here.](http://theparksvillemurders.com/)
