+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-09-08T09:07:00+01:00"
lastmod = "2016-09-15T15:26:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473945682355/2016-09-15---Concert.jpg.jpg"
publishDate = "2016-09-15T15:20:00+01:00"
related_articles = ["articles/in-review-hannigan-grazinyte-tyle-BBC-proms.md","articles/party-arias-the-traits-of-lesser-operas.md","articles/falstaff-in-cambridge.md"]
related_people = ["scene/people/albina-shagimuratova.md"]
short_description = "If an opera truly is a great work of drama and music, does that mean it&#039;s less likely to translate well without sets or costumes? If the drama and music are wonderfully combined, does an in-concert performance mess up a composer&#039;s delicate balance? If a great opera feels like it&#039;s going on for days, how much fault lies in our dwindling contemporary attention spans?"
slug = "opera-in-concert-uncluttered-or-uninteresting"
title = "Opera in concert: uncluttered or uninteresting?"
+++

If you think about it for too long, the idea of doing opera in concert is pretty odd.

It's sort of similar to the practice of reading Shakespeare aloud, in that the art form doesn't get represented in the way it was meant. If Shakespeare had wanted his words only to be read and heard, arguably he would have put them into a sonnet. Similarly, if a composer had wanted his audience to hear music and watch the musicians at work, would he not have written a symphony or some bit of chamber music?

And perhaps the difference between an uncluttered experience like this one, and a boring time at an unstaged opera, lies in the choice of repertoire. There's nothing actually wrong with an in-concert performance of an opera. In fact, it can be great. You can focus on the music, and watch the singers in a more natural state, unobscured by costumes or lighting. Without strong input from a director (or any at all), it can shine a better light on the individuals in the cast; you see their own personalities, their own takes on their characters.

And perhaps the difference between an uncluttered experience like this one, and a boring time at an unstaged opera, lies in the choice of repertoire. There are some operas that decidedly are a bit of a downer in concert. It would be sort of lame to do something like Ravel's *L'enfant et les sortilèges*, or Britten's *The Rape of Lucretia*, done without staging or visual enhancement; *L'enfant* is about surrealism and awe, and *Lucretia* is too closely connected with action to pull the drama from the score.

Of course, it's a slippery slope to draw the line between an opera's being suitable or not for in-concert performance. We have a hunch that *La bohème* would be a poor in-concert choice, but there's something about *The Turn of the Screw* that could be totally eerie in such a pared down setting. It's likely that many of you, readers, disagree, because it inevitably comes down to taste.

At the 2016 BBC Proms, we heard Rossini's *Semiramide* in concert at Royal Albert Hall, wth Sir Mark Elder conducting the Orchestra of the Age of Enlightenment. Russian coloratura soprano [Albina Shagimuratova](/scene/people/albina-shagimuratova/) was stunning in the title role, filling Albert Hall with staggering high notes, and a lovely richness in her sound that is rare among coloraturas. [Daniela Barcellona](/scene/people/daniela-barcellona/) was a strong Arsace, showing off the bottom of her voice to complement Semiramide's great heights. Bass Mirco Palazzi sang Assur, with tenor Barry Banks as Idreno; both gentlement stepped in on short notice to replace Ildebrando d'Arcangelo and Levy Strauss Sekgapane, respectively.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1473939695137/2016-09-14---Shagimuratova---pc---Pavel-Vaan-Leonid-Semenyuk.jpg.jpg)<figcaption>Albina Shagimuratova, coloratura soprano. Photo by Pavel Vaan and Leonid Semenyuk.</figcaption>
</figure>

On the one hand, *Semiramide* is just too long for a concert performance. It's over three hours of music; now, when that music is played by the fantastic OAE and sung by great singers, it isn't such a bad problem to have. Yet this in-concert Rossini shone a bright light onto the piece itself, exposing every musical moment that urges the characters to move, for a scene to change, for some *reason* to repeat oneself as much as they do in *bel canto* operas.

When you keep hearing these musical cues that should mean something, yet there's nothing new to see, that's when an in-concert performance can feel empty. The *Semiramide* cast worked to bring the piece to life in a setting like this; Arsace had his first entrance from one of the aisles in the audience, and the ghost of Nino, sung by James Platt, terrified the standing-room listeners with a house entrance from the rear. Shagimuratova wore queenly gowns, Platt a white suit.

Great ideas, yet not large enough for a space like the Albert Hall. The funny thing is, the singing of *Semiramide* just may be enough to sustain an audience, if the score took a healthy amount of cutting. The vocal pyrotechnics are what leads any *bel canto* opera, hopefully more so than any director's imaginings. 

If an opera truly is a great work of drama and music, does that mean it's less likely to translate well without sets or costumes? If the drama and music are wonderfully combined, does an in-concert performance mess up a composer's delicate balance? If a great opera feels like it's going on for days, how much fault lies in our dwindling contemporary attention spans, versus in the fact that the composer may never have expected his audience to sit quietly and listen the entire time?

The best in-concert operas we've seen have been under 2 hours, without chorus, and they're stories which boil down to relationships. This doesn't mean you can't do *La bohème* in-concert; but perhaps Perpignan's scene doesn't need to stay in. Simply put: if you've cut the staging, doesn't that leave the music subject to the same?

Readers, what say you on the topic? Are in-concert operas a great opportunity to hear a work, uncluttered? Or are they a lesser operatic experience?
