+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2014-01-28T14:07:00-05:00"
lastmod = "2018-01-03T11:25:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1514991811717/2018-01-03---Scarf.jpg.jpg"
publishDate = "2014-01-28T14:07:00-05:00"
related_people = ["scene/people/isaiah-bell.md"]
short_description = "There is this stereotype of &quot;theatre folk.&quot; They come to rehearsal enveloped in pashmina, they identify themselves with their choice of uniquely quirky glasses-frames, and they wear the kind of clothing that begs the honest question, &quot;Did you make that tunic yourself?&quot;"
slug = "opera-great-or-just-the-greatest"
title = "Opera: don&#039;t judge it by its people"
+++

There is this stereotype of "theatre folk." They come to rehearsal enveloped in pashmina, they identify themselves with their choice of uniquely quirky glasses-frames, and they wear the kind of clothing that begs the honest question, "Did you make that tunic yourself?"

The Theatre Person is also in his own head about the wrong things. He will prattle on about the significance of the colour pewter as a symbol of virility, and ignore the fact that the singer onstage can't see the conductor while curled in the fetal position facing upstage. These details interrupt the Theatre Person's creative process.

And best of all, the Theatre Person should not be criticized for his skills in time management; one must never go down in the history books as the critic who scoffed at the next artistic genius. Don't want to pull a Rite-of-Spring.

But it struck me recently, as a person who has been present in a wide range of rehearsal styles, that not all of these styles are equally, well, good.

Sure, there's a huge opportunity for magic to happen onstage as actors, singers and players improvise and throw themselves "into the moment." But what's forgotten is that in any form of live theatre, the ability to appear organic and improvisatory onstage is a life-long skill to master.

Leaving room for spur-of-the-moment inspiration in theatre is a must for any good director and artist. What the above Theatre Person often doesn't see is that this flexibility must come _after_ a director shares his detailed and complete idea for the arc of the piece. It's not about building up a piece from zero and leaving 10% room at the top for "inspiration." It's about creating 100% of the piece, and then finding small points of wiggle room where it's still dramatically organic.

Thoughtful Canadian tenor Isaiah Bell sums up the process of becoming a performer who appears to be a "natural":

"First you have to learn to sing, then you have to learn to forget you're singing but still be able to sing, and you have to learn stagecraft, and then go back and integrate the two, and then learn to forget about both, while still doing them, so that when you're in front of an audience all they're seeing is a person experiencing something, who also happens to be singing, and presenting their experience theatrically in such a way that people can understand it. It's incredibly complicated because you can't just tell someone who is still working on the first or second step to just go to the last step."

Here's a fantastic example of improvisation with a massive foundation of musical skill: Victor Borge and Itzhak Perlman cranking out some sort of Hungarian rhapsody. Ridiculous.

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/Ux3lMeFaA7s" frameborder="0" gesture="media" allow="encrypted-media" allowfullscreen></iframe>
</figure>

It's fair to say that anyone putting on a piece of music theatre, opera, orchestra music, etc., has the goal of creating a performance that is easy and organic. But, says Bell, "It's also important to realize that there's this huge base of work that has be done before we can see what it is that makes opera - or any theatre - so good."

So what's my point? It's that the product of a mediocre creative process is a mediocre performance. And dull shows can take the fun out of theatre for its biggest fans, let alone the general public. I think lazy artistry does a disservice to what's possible out in the music and theatre scenes; it's up to the artists to make sure they've stepped up in the detail department. It's up to, say, the trombonist in the band with the good phrasing idea to speak up and remind their colleagues that a higher bar always exists. It's up to the bass soloist in Beethoven's 9th to find something worth saying within his spitefully written part.

And then the cool thing will happen: the audiences will start to notice a difference between something organic and something just simple. And they'll come back to the best for more.

To end on another Bell-ism, it's "like Rembrandt training and honing his skills his whole life to paint something so finely that when you see it all you see is a real, whole person looking at you, seemingly captured in a single living moment from 400 years ago."

>Do you agree? Do you think we're being opera snobs? Let us know in the comments below!
