+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2015-05-25T13:56:00+01:00"
lastmod = "2016-02-29T19:11:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1433177914389/ParisOpera.jpg.jpg"
publishDate = "2015-06-02T14:18:00+01:00"
related_articles = ["articles/who-cares-what-bring-on-the-why.md", "articles/arizona-opera-on-tradition.md", "articles/whats-on-at-the-met-201617.md"]
related_companies = ["scene/companies/against-the-grain-theatre.md", "scene/companies/tapestry-opera.md", "scene/companies/indie-opera-to.md", "scene/companies/the-metropolitan-opera.md", "scene/companies/royal-opera-house.md"]
related_people = ["scene/people/ana-sokolovic.md", "scene/people/david-lang.md"]
short_description = "We&#039;re talking about newbies, here; if everything is new, everything is on the table. I say then, let&#039;s first present opera in its most progressive form. Not to create a bias, but precisely because preconceptions about opera exist; the simplest way to break them down is to show them something, called opera, that doesn&#039;t fit the stereotypes."
slug = "opera-for-first-timers-thinking-outside-the-box"
title = "Opera for first-timers &amp; thinking outside the box"

+++
There's a lot written about what operas are great for first-timers. *Carmen*, *Don Giovanni*, *Tosca*, *The Barber of Seville*, *La bohème*, *La traviata*, these are all popular picks, apparently some of our best bets at luring new audiences to the opera (and having them come back again). The [Royal Opera House](http://www.roh.org.uk/news/opera-for-first-timers-your-suggestions) asked its Twitter followers what their suggestions for first-timers would be; their picks mirrored my examples above, plus a few votes of *Die Zauberflöte* and *L'elisir d'amore*.

<blockquote class="twitter-tweet" lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/RoyalOperaHouse">@RoyalOperaHouse</a> Tosca. It&#39;s all there: love, death &amp; a fabulous baddie with one of the best arias in opera!</p>&mdash; Penny Murphy (@PennyMurphy) <a href="https://twitter.com/PennyMurphy/status/288342173647265793">January 7, 2013</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/RoyalOperaHouse">@RoyalOperaHouse</a> Carmen big tunes, exciting dramatic, fun and no recitative to get lost in!</p>&mdash; Ione Chadwick (@Ione_Elizabeth) <a href="https://twitter.com/Ione_Elizabeth/status/288346529784266752">January 7, 2013</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

<blockquote class="twitter-tweet" lang="en"><p lang="en" dir="ltr"><a href="https://twitter.com/RoyalOperaHouse">@RoyalOperaHouse</a> L&#39;elisir d&#39;amore as it&#39;ll make them laugh *and* cry. Otherwise let them try an operatic version of a story they know &amp; love</p>&mdash; Shyam Bhatt (@_ShyamBhatt) <a href="https://twitter.com/_ShyamBhatt/status/288344725956743169">January 7, 2013</a></blockquote>
<script async src="//platform.twitter.com/widgets.js" charset="utf-8"></script>

I suppose there's a difference between a good choice for a willing opera newbie, and first-time operas that represent the industry well. Among opera lovers there's an implicit wish, however, that bringing someone to their first opera will inspire them to become a full-blown fan. Beautiful singing, high drama, and memorable tunes are what *Barber* and *Bohème* bring; I'm not saying these operas are inaccessible, but they have arguably hit a plateau with their ability to foster the kind of audiences that would buy season subscriptions.

Opera looks different today than it did even decades ago, and it certainly *is* different than the average person's preconceptions. Large-scale *Aida*s are rivalled by opera on the small scale, showcasing new works and re-imaginings of old works. This doesn't cancel out opera on the grand scale, but why should grand be the point of entry for someone's first opera?

We're talking about newbies, here; if everything is new, everything is on the table. I say then, let's first present opera in its most progressive form. Not to create a bias, but precisely *because* preconceptions about opera exist; the simplest way to break them down is to show them something, called opera, that doesn't fit the stereotypes.

There's no real reason to show someone *Tosca* over *Anna Nicole* as their first show. Some of you may recoil at my suggestion, but bear with me. *Tosca* and *Anna Nicole* are extreme examples, but I really think that a first-timer who saw an opera in their native language, about someone they remember from their lifetime, with music that doesn't sound strictly "classical", would be more apt to see another opera.

Trade *La traviata* for Floyd's *Susannah*, *Die Fledermaus* for Roark's *The Whisky Opera*. I'm not saying the newer, English operas are "better" operas, but I think they're truer gateway drugs. Shows like Heggie's *Dead Man Walking* can show that opera composers are alive today, living in the same world as everyone else. Sokolovic's *Svadba-Wedding* and David Lang's *the whisper opera* would throw some pretty big wrenches in, well, most preconceptions about opera. Even works like Benjamin's *Written On Skin* or Harris' *M'dea Undone*, while they may seem musically daunting (varsity-level opera), are such organic works of drama that they're hypnotizing. Certainly different from Puccini.

Alongside new operas are updated, translated versions of old classics. Taking a newbie to Against the Grain Theatre's *Figaro's Wedding* or [ERRATICA](http://erratica.org/projects/dido-and-aeneas)'s *Dido and Aeneas* gives them a truer experience of these pieces by removing the language and anachronistic barriers. Like any good opera, these adaptations are designed to be organic to their performance space and specific audience; they're not dependent on having seen a tradition *Le nozze di Figaro*, and I'd wager that a first-timer who saw *Figaro's Wedding* would be tempted to see a *Nozze*, more than the other way around.

Thinking outside the box when it comes to gateway operas is good for the newbie, and *good for the industry*. Perhaps we don't give new opera enough credit, or consider it a more advanced form of art. For opera companies, I think adapting their programming to prioritize the new (and potentially weird) is an obvious tactic to try. Historically, one doesn't hear a lot of opera traditionalists who enjoy branching out to hear the new, or the small, or the unfinished of the opera scene. Like I said earlier, perhaps it would work better the other way around. Start them with the new, and by the time they get to *Carmen*, they'll hear it with educated ears, free from stereotypes about parking & barking and the idea that opera is strictly a musical genre.

When it comes to companies filling their seasons with way more new opera and on various scales, perhaps it's a bit of putting the cart before the horse. I'll cede that large houses won't be the places to show smaller-sized operas, but as the frontline for the average person's endeavour into opera, large opera companies are the best ones to take the leap with a season where new, and/or English opera makes a majority of the line-up. Just like *Bohème* is easier to find playing than *Anna Nicole* (and probably easier to see done "meh", too), it's easier for an interested opera newbie to look up the [Met](/scene/companies/the-metropolitan-opera/) than [The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/). Yes, I know, if the Met put twelve new shows in English on their 2015/16 season, the donorship would suffer hugely and the whole house of cards would crash down. Without changing up the game, opera as consumed by newcomers will continue to live up to stereotypes, and the proof otherwise will stay comparably hidden. The term "museum" will become more and more accurate.

To read more on this topic, check out Tom Services piece for *The Guardian*, ["Your first opera: What should it be? And why?"](http://www.theguardian.com/music/tomserviceblog/2014/may/08/inside-opera-day-the-best-opera-for-first-timers) for *The Guardian*, and Michael Volpe's ["The First Opera?"](http://www.huffingtonpost.co.uk/michael-volpe/the-first-opera_b_1550385.html) for *Huffington Post*.