+++
author = ["authors/jenna.md"]
categories = "Review"
date = "2017-11-30T22:06:00-05:00"
lastmod = "2017-12-02T17:33:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512253336103/2017-11-30---square---DSC_4141.jpg.jpg"
primary_image_credit = "James Dunn as Sam and Megan Dunn as Gracie in the Canadian Opera Company’s new production of The Magic Victrola (Opera for Young Audiences, 2017), photo: Gaetz Photography."
publishDate = "2017-12-02T17:33:00-05:00"
related_articles = ["articles/for-kids-grownups-alike-the-scorpions-sting.md","articles/a-hit-with-the-kids-wow-factor.md"]
related_companies = ["scene/companies/canadian-opera-company-ensemble-studio.md","scene/companies/canadian-opera-company.md"]
related_people = ["scene/people/andrew-haji.md","scene/people/danika-lorn.md","scene/people/megan-quick.md","scene/people/simone-mcintosh.md","scene/people/samuel-chan.md","scene/people/bruno-roy.md","scene/people/lauren-eberwein.md","scene/people/samantha-pickett.md","scene/people/stephane-mayer.md"]
short_description = "The Magic Victrola features opera&#039;s top-shelf tunes: the Lakmé Flower Duet, Carmen&#039;s &quot;Habanera&quot;, the infamous &quot;O mio babbino caro&quot; from Gianni Schicchi; perhaps less well-known are the picks that stand for larger operatic truths, like the textbook bel canto of &quot;Quanto è bella&quot; (L&#039;elisir d&#039;amore), the delicious coloratura of the &quot;Doll Song&quot; (Les contes d&#039;Hoffmann), and timeless scenes from The Magic Flute."
slug = "opera-for-all-the-magic-victrola"
title = "Opera for all: The Magic Victrola"
+++

Opera purists may recoil from the idea of a revue-type show, of a mash-up of hits from the most beloved works from the canon, tied loosely together with a makeshift plot and connect-the-dots dialogue. Essentially, that's what a young-audience-friendly piece like *The Magic Victrola* is. Yet the current [production by the Canadian Opera Company](http://www.coc.ca/PerformancesAndTickets/1718Season/OperaforYoungAudiences.aspx) is well done, wrapped up tightly with a smart bow; it's a reminder that excellent artistry - be it singing, direction, or design - can result in an exception to anyone's aesthetic rule.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512097325292/2017-11-30---DSC_5052.jpg.jpg)
<figcaption>A scene from the Canadian Opera Company's new production of *The Magic Victrola* (Opera for Young Audiences, 2017), photo: Gaetz Photography.</figcaption>
</figure>

*The Magic Victrola* features opera's top-shelf tunes: the *Lakmé* Flower Duet, Carmen's "Habanera",  the infamous "O mio babbino caro" from *Gianni Schicchi*; perhaps less well-known are the picks that stand for larger operatic truths, like the textbook *bel canto* of "Quanto è bella" (*L'elisir d'amore*), the delicious coloratura of the "Doll Song" (*Les contes d'Hoffmann*), and timeless scenes from *The Magic Flute*.

The musical selections are woven into a cute - if hokey - English libretto by David Kersnar and Jacqueline Russell. Gracie and (Megan Dunn) Sam (James Dunn), left at their grandfather's place all summer with no wi-fi, treat their boredom with some ancient technology: a Victrola record player and a box of opera recordings. Their listening experience quickly becomes interactive - magical, even - as the characters from the recordings come to life.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512097343733/2017-11-30---DSC_4751.jpg.jpg)
<figcaption>(l-r) Andrew Haji as Tamino, Samantha Pickett as First Lady (in background), and Ardon Bess as Grandpa in the Canadian Opera Company's new production of *The Magic Victrola* (Opera for Young Audiences, 2017), photo: Gaetz Photography.</figcaption>
</figure>

The libretto treads an interesting line between pure storytelling and an almost meta championing of opera; between the passion that Grandpa (Ardon Bess) expresses for his collection of records, and the demonstrative edu-tainment provided by Papageno-come-to-life (Bruno Roy), there's a small element of over-selling, even to an audience of kids. Yet there was something Disney/Pixar-like about the production directed by Ashlie Corcoran, which is full of exaggerated physicality; Camellia Koo's sets and costumes strike a great balance between attracting the eye and piquing curiosity - what better way to draw in an audience than with a line-up of large items covered mysteriously in sheets?

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512097351351/2017-11-30---DSC_4330.jpg.jpg)
<figcaption>(l-r) Andrew Haji as Nemorino, James Dunn as Sam, and Megan Dunn as Gracie in the Canadian Opera Company's new production of *The Magic Victrola* (Opera for Young Audiences, 2017), photo: Gaetz Photography.</figcaption>
</figure>

Hokey as the plot may be, it does what's most important, which is to get us from one fantastic musical number to the next. The high quality performances by the cast of singers prove that opera really is capable of holding the attention of young listeners - when done very, very well; they made stand-alone scenes out of their work. With a few double-cast roles, the cast consists of members of the COC Ensemble Studio, plus Ensemble alumnus Andrew Haji. It was a total delight to see these young artists deliver professional-level singing, and to watch them distill their artistry into a single moment from a famous opera.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512097360145/2017-11-30---DSC_4205.jpg.jpg)
<figcaption>Danika Lorèn as Olympia and Samuel Chan as Papageno in the Canadian Opera Company's new production of *The Magic Victrola* (Opera for Young Audiences, 2017), photo: Gaetz Photography.</figcaption>
</figure>

[Haji](/talking-with-singers-andrew-haji/) lived up to opera's exaggerated romance with his "Quanto è bella"; [Danika Lorèn](/spotlight-on-danika-loren/) was an adorable doll with machine-like coloratura (in the most excellent of ways) in "Les oiseaux dans la charmille"; [Simone McIntosh](/scene/people/simone-mcintosh/) was a spicy Carmen with a gorgeous sound; [Lauren Eberwein](/scene/people/lauren-eberwein/) stole hearts with "O mio babbino caro"; and [Bruno Roy](/scene/people/bruno-roy/) was a lovable Papageno who had the audience rooting for him in his search for love.

Plus, Music Director [Stéphane Mayer](/scene/people/stephane-mayer/) deserves a nod for his two-hand rendition of the overture to Mozart's *Le nozze di Figaro*. That's no small feat!

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1512097335126/2017-11-30---DSC_4797.jpg.jpg)
<figcaption>(foreground) Andrew Haji as Tamino with (l-r) Samantha Pickett as First Lady, Simone McIntosh as Second Lady and Megan Quick as Third Lady in the Canadian Opera Company's new production of *The Magic Victrola* (Opera for Young Audiences, 2017), photo: Gaetz Photography.</figcaption>
</figure>

It's a different look for the COC Ensemble's annual production geared toward young audiences. Rather than taking a portable show on the road, [*The Magic Victola*](http://www.coc.ca/PerformancesAndTickets/1718Season/OperaforYoungAudiences.aspx) welcomes young audiences into the COC's space, and reaps the rewards of being a stationary production. The piece really does demonstrate what opera does best: it gives its audiences a buffet of things to see and hear.
