+++
author = ["authors/jenna.md"]
categories = "Op-ed"
date = "2015-11-04T16:42:00-05:00"
lastmod = "2015-11-04T16:44:00-05:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1446673347437/2015-11-04---DirectorMusic.jpg.jpg"
primary_image_credit = "Radiohead's Karma Police, by synesthetic artist Melissa McCracken."
publishDate = "2015-11-05T08:00:00-05:00"
related_articles = ["articles/does-a-good-artistic-director-read-music.md","articles/meet-the-director-liza-balkan.md","articles/talking-with-directors-jennifer-williams.md"]
related_people = ["scene/people/tom-diamond.md"]
short_description = "It&#039;s odd when you think about it too much: opera companies generally employ a person who is less musically literate than many 10-year old pianists, to make directorial choices in a theatre genre where music is the vital vehicle of the story. So, why isn&#039;t a strong musical background a prerequisite for directing opera? "
slug = "opera-directors-an-unfair-disadvantage"
title = "Opera directors: an unfair disadvantage?"
+++

One of the funny things about the opera rehearsal room is the delegation of tasks between the two "bosses," the conductor and director. It's hard to make a case one way or the other about whether the director or the maestro knows the opera the best. You could argue that the conductor has the advantage of being able to decipher both the text (in theory, anyway) and the music. It’s relatively rare to find a director who reads music well, and although he or she has the dramaturgical chops, it’s sometimes fair to say that the director misses elements of the story that exist in the music itself.

It's odd when you think about it too much: opera companies generally employ a person who is less musically literate than many 10-year old pianists, to make directorial choices in a theatre genre where music is the vital vehicle of the story. So, why isn't a strong musical background a prerequisite for directing opera? An easy answer is that the director learns on the job. It's a collaborative art form, after all, and the conductor is there to oversee the music and generally leave the drama to the director. Under the umbrella of "drama," though, are costumes, sets, lighting, character motivation, and visual aesthetic of what the audience experiences. That's quite a lot of territory that's under the supervision of (usually) a Non-Musician.

It could be easy to make the association that the rise of the director in past decades coincides with the rise of baffling productions and fearsome Regietheater; perhaps you could deduce that there have been dents made in the presentation of opera by some of these directors without strong musical skills. Yet, they bring an advantage to the table that I liken to the difference between singers with classical/conservatory backgrounds and those who started in music theatre. Frankly, it all comes down to being able to read the text, without distraction.

My own learning curve as I began playing for singers included learning to really read that third line on the score. You know, the one with the words? For a pianist, a conductor, even a singer, it’s so easy to get hung up on technical challenges and tempo markings. It's freeing to find out that so many of your questions can be answered in that line with text. I imagine that it can be easier to see the forest if you're not an expert on tree species; I mean to say, being musically illiterate will keep one's eye on the prize, in the case, the text.

I imagine a director, asked to direct a production of *Le nozze di Figaro*, listening to a recording of the piece for the first time. They're swept away by the music, a Disney's-*Fantasia*-esque scene playing in their mind as they listen with virgin ears to Mozart's genius. They wouldn't be distracted by musical symmetry, or Mozart's brilliant duet-writing; in a sense, a dramaphilic non-music type would hear an opera in the way that a composer would want it to be heard.

I remember doing a production of Britten's *A Midsummer Night's Dream* with Tom Diamond a few summers ago, and I was wowed by his approach to comedy. He heard what was ridiculous in the music, what was sincere, what was movement. By the end of the rehearsal process, the music seemed to function as a by-product of what was happening onstage, like a cartoon soundtrack. Over on the music-centric side of the rehearsal room, the conductor and my fellow music staff were geeking out over Britten's orchestration, and his ingenious letimotifs for the Mechanicals versus the Fairies. It's fair to say that we often forgot the opera was a comedy, and we would have missed many of the opportunities that our director found.

Diamond is one example, but in my time rehearsing opera, directors continue to impress upon me the value of collaborative creation. Over and over again, I've arrived on day one with an understanding of the piece, and a director can imagine an entirely novel world, or a hidden facet of two characters' relationship; they do this, even without the depth of musical skill that seems crucial for singers and conductors.

Maybe it's like that trope about reading Shakespeare, versus hearing it performed; or maybe it's more like how losing one sense can heighten the others. The difference between a director's approach and a conductor's is tangible, and it's about where one starts with the piece. When it comes to music with text, it's almost funny that it can take young musicians a relatively long time to learn how to begin with the words. It's where the composer started, after all.
