+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-04-11T19:37:00-04:00"
lastmod = "2015-04-11T19:57:00-04:00"
preamble = "<p>\n\t<a href=\"http://www.operadacamera.ca/\" target=\"_blank\">Opera da Camera</a> is hard at work, getting ready for their upcoming production of Handel's <a href=\"http://www.operadacamera.ca/2014-15\" target=\"_blank\">Xerxes</a>, running February 19, 21, 28 and March 1st. What's with the Elvis get-up, you ask? I asked Co-Artistic Directors Meagan Zantingh and Kathrin Welte about all that gender fluidity in Handel's operas, and how Opera da Camera is answering the big question of audience accessibility. #viveleroi indeed!\n</p>"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428795263966/Serse-Poster-Web.jpg.jpg"
publishDate = "2015-02-12T09:09:00-05:00"
related_articles = ["articles/opera-da-cameras-hansel-und-gretel.md"]
related_companies = ["scene/companies/opera-da-camera.md"]
related_people = ["scene/people/meagan-zantingh.md","scene/people/valerie-belanger.md","scene/people/kathrin-welte.md"]
short_description = "Opera da Camera is hard at work, getting ready for their upcoming production of Handel’s Xerxes, running February 19, 21, 28 and March 1st. What’s with the Elvis get-up, you ask? I asked co-Artistic Directors Meagan Zantingh and Kathrin Welte about all that gender fluidity in Handel’s operas, and how Opera da Camera is answering the big question of audience accessibility. #viveleroi indeed!"
slug = "opera-da-camera-xerxes-is-the-new-elvis"
title = "Opera da Camera: Xerxes is the new Elvis"
+++

<h2>1. How did the connection between the stories of <em>Xerxes</em>and a drag king's love triangle come about?</h2>
<p>
	We were quite dedicated to producing an opera this season that pushes a bit at the boundaries of traditional stagings. The original score of <em>Xerxes</em> includes a lot of gender bending, whether that is embodied physically or aurally by the voice. The title role was written for a castrato, and Xerxes' brother, Arsamene, was intended to be sung by a soprano. The fiancée of Xerxes, Amastre, was written for a woman, but this woman ends up being disguised as a man for almost the entire opera. And even a manservant, Elviro, dresses up as a woman flower-seller in one scene. It is strange to think that audiences in Handel's time, where gender roles were more rigidly defined than today, likely had an easier time coming to terms with all this confusion than our modern audiences, who have certain expectations of a sound world and physical world matching up. With all of the cross-dressing inherent in the original piece, we decided that this could in fact be what we build on to bring the opera into a more modern context. Our director, <a href="http://www.canis-tempus.org/pages/Andy.htm" target="_blank">Andrew Cuk</a>, decided we would not hide all of the cross-dressing in our production, but instead assign the genders of the roles to what they sound like: women. So while the plot remains untouched and the story of love, jealousy, hate and lust still takes place, it now does so in the context of homosexual relationships between women. To make the setting seem even more "real" for today's audience, the action takes place in a drag king club in contemporary Montréal, where Xerxes, the bar's owner, rules like "the King".
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428795314366/Meagan-Zantingh-headshot.jpg"><img data-resize-src="http://lh3.googleusercontent.com/lpiwwxCkW97AGWPJCGTjbSsJWf326dbTS3wx2W8ixOJvqpmBeF3YrHRt8ccZR1MrQ3wLMjjFapvGRaw51CwJsRKua321qw" src="http://lh3.googleusercontent.com/lpiwwxCkW97AGWPJCGTjbSsJWf326dbTS3wx2W8ixOJvqpmBeF3YrHRt8ccZR1MrQ3wLMjjFapvGRaw51CwJsRKua321qw=s1200"></a><figcaption>Meagan Zantingh, Co-Artistic Director, Opera da Camera</figcaption></figure>
<h2>2. Why do you think that Handel's operas are so often updated and re-imagined? What artistic allowances do his works allow?</h2>
<p>
	His operas from the beginning were meant to be relatively flexible, depending on what singers and musicians he had available and what the production budgets were. And even though this opera is technically about the King of Persia, there are almost no historical elements in the plot. The real focus is on the love story and the real emotions of the characters. This makes it easy to set it anywhere.
</p>
<h2>3. Opera da Camera is about small venues and audience accessibility. How are these two things linked?</h2>
<p>
	The stereotype of opera today is that it's an elitist genre where rich people go to watch huge, expensive productions in big theatres. Opera da Camera wants to attract people by making them feel more a part of the action, by letting them see the singers up close. They will notice how the singers work incredibly hard, sweat, breathe, and have facial expressions. There is such power in the human voice, and we believe that the more intimately it can be experienced by the public, the more they will feel the voice and the story resonate within them.
</p>
<p>
	The <a href="http://www.theatrerialto.ca/en/home.html" target="_blank">Rialto Theatre</a>, where we've had the honour of performing these past three years, provides a level of casual comfort that is not usual in a regular theatre. There is cabaret seating and booths; there's a bar with opera-themed drinks; some of the action of the opera will take place in the audience itself. In a way, this allows us to help audiences experience opera more as it would have been common in Handel's time, where the social aspect of meeting up with friends to spend an entertaining evening together was just as important as appreciating the artistic merit of the work presented.
</p>
<figure data-type="image"><a href="https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1428795364948/Kathrin-Welte-photo.jpg"><img data-resize-src="http://lh3.googleusercontent.com/w412gSPHZ22frF2xz9bb97xv7YZDc_Uqoh9JwC49ltSSPEWFBX3mSYeY6Kgu4IQLd6goesLVBjPEe6amcVERzQJeCPqw" src="http://lh3.googleusercontent.com/w412gSPHZ22frF2xz9bb97xv7YZDc_Uqoh9JwC49ltSSPEWFBX3mSYeY6Kgu4IQLd6goesLVBjPEe6amcVERzQJeCPqw=s1200"></a><figcaption>Kathrin Welte, Co-Artistic Director, Opera da Camera</figcaption></figure>
<h2>4. How indicative is Opera da Camera of Montréal's opera scene?</h2>
<p>
	The <a href="http://www.operademontreal.com/en" target="_blank">Opéra de Montréal</a> is obviously the great establishment in this city, along with its <a href="http://www.operademontreal.com/en/emerging-artists/atelier-lyrique" target="_blank">Atélier Lyrique</a> programme. However, this city is full of gifted emerging artists looking for opportunities to sing roles and be part of exciting productions. In the past few years, there have been other small companies like ours (<a href="https://cbmroyal.wordpress.com/" target="_blank">Compagnie Baroque Mont Royal</a>, <a href="http://www.opera-immediat.com/" target="_blank">Opéra Immédiat</a>, <a href="https://twitter.com/stuandjess" target="_blank">Stu&amp;Jess Productions</a>), that have realized there is a niche for productions on a smaller scale. And the public, some of whom may not be interested in the grand scale of the Opéra de Montréal, is ready to experience opera on a more intimate level. Opera da Camera is proud to have an audience that is made up of mostly young people and often first-time opera goers. We see ourselves as an important part of the city's operatic ecosystem. If audiences like what they see in our productions, then perhaps they'll try other companies like the Opéra de Montréal…and hopefully this might work vice versa as well!
</p>
<h2>5. What are some projects you'd like to see developed by Opera da Camera in future seasons?</h2>
<p>
	For a long time we've had the dream of experimenting with different venues, venues that aren't necessarily theatres – and continuing to make the space and what it has to offer part of the show. Another important goal would be to collaborate more with other small companies in the country. It takes such effort and financial risk to mount new productions as we do, that it could be hugely beneficial to begin considering joint productions to take off some of the pressure. This is, after all, what many bigger houses do already. Even just two small companies putting together their production budgets would allow for slightly higher production values right from the beginning. But more importantly, both could afford the companies to be a bit more 'artistically risky', by mounting unusual/unconventional productions. The question of going traditional vs modern is a tough one for a small company that relies hugely on the revenue of ticket sales, and therefore needs to appeal to as broad a public as possible.
</p>
