+++
author = ["authors/joshua-chong.md"]
categories = "Review"
date = 2021-06-06T04:00:00Z
disclaimer = "This review was originally published on _Opera Canada_. It is reposted here with permission from the author."
image_gallery = []
postamble = "Opera Atelier’s filmed production of The Resurrection is streaming until June 10. Tickets and more information can be found [here](https://www.operaatelier.com/season-and-tickets/2020-2021-season/handel-the-resurrection-opera-atelier)."
preamble = ""
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1622747083/media/2021/06/sqOA-TheResurrection-BruceZinger_jkkjle.jpg"
primary_image_credit = "Meghan Lindsay (left) and Allyson McHardy in Handel's The Resurrection, Opera Atelier, 2021. Photo: Bruce Zinger."
related_articles = []
related_companies = ["scene/companies/tafelmusik-baroque-orchestra-chamber-choir.md", "scene/companies/opera-atelier.md"]
related_people = ["scene/people/douglas-williams.md", "scene/people/allyson-mchardy.md", "scene/people/carla-huhtanen.md", "scene/people/meghan-lindsay.md", "scene/people/colin-ainsworth.md"]
short_description = "What a pity, then, that Zingg and Pynkoski’s production couldn’t be showcased on a traditional stage, like that of Koerner Hall—where this production was originally set to premiere in April 2020—or the Elgin Theatre, Opera Atelier’s de facto home."
slug = "opera-ateliers-the-resurrection-is-resplendent-art-in-the-face-of-adversity"
title = "Opera Atelier’s The Resurrection is resplendent art in the face of adversity"
youtube_url = ""

+++
Georg Frideric Handel's _The Resurrection_ is really an oratorio in name only. Discounting its liturgical basis, the piece has all the hallmarks of a baroque opera seria: dramatic characters, a clear—albeit skimpy—plot and a theatricality in the libretto that demands the use of elaborate sets and costumes.

But when _The Resurrection_ premiered in 1708, Pope Clement XI had shuttered theatres and banned operas. That, however, didn’t dissuade Handel and his contemporaries, who simply skirted the laws by disguising their operas as oratorios—using Biblical characters to tell allegorical stories, and presenting these works as concerts rather than full theatrical productions.

For over three centuries, Handel’s rarely-produced work has been masquerading as an oratorio—popping up in concert halls during Lent every once in a blue moon. How ironic, then, that it has taken another theatre-shuttering moment in history for _The Resurrection_ to finally receive the operatic treatment it deserves.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1622747180/media/2021/06/OA-The_Resurrection-DouglasWilliams-BruceZinger_do4dz8.jpg){{% /md %}}

<figcaption>Douglas Williams and Artists of the Atelier Ballet in Handel's The Resurrection, Opera Atelier, 2021. Photo: Bruce Zinger.</figcaption>

</figure>

We have to thank Opera Atelier for that. Their long-awaited filmed production of _The Resurrection_ (seen May 27) is a sumptuous and lavish affair that showcases Handel’s work in all its glory. With direction by Marshall Pynkoski and inspired choreography by Jeannette Lajeunesse Zingg, it’s hard to imagine how this piece could have ever been presented in a concert setting—with static singers in front of a symphony orchestra.

> Ainsworth, reprising his role from the 1999 production, is a joyful St. John the Evangelist, with a silvery voice to match.

Pynkoski pulls profound performances filled with rich characterization and vocal nuance from the cast. That the performers were able to achieve both is a considerable feat, given that the vocal tracks had to be recorded separately at Koerner Hall before filming even began at St. Lawrence Hall’s grand ballroom (COVID-19 restrictions prohibited any singing on the film set).

[Carla Huhtanen](/scene/people/carla-huhtanen/) and [Douglas Williams](/scene/people/douglas-williams/) convincingly portray an archangel and Lucifer, respectively. Standing atop a metal scaffolding and basking in a haze of neon blue light, Huhtanen delivers her opening aria “Disserratevi, o porte d'Averno” with a effervescent brilliance befitting of an angel setting the perpetual darkness of hell aglow. Her delicate, acrobatic coloratura is the antithesis of Williams’s dark leathery baritone.

> Lindsay, an Opera Atelier favourite, is perfectly cast as Mary Magdalene.

Their fiery Act II duet “Impedirlo saprò!” is one of the production’s highlights. Williams’s raging Lucifer proclaims that he will halt Christ’s message from proliferating across the world, while Huhtanen’s archangel, with a look of annoyance, tells him that it’s an impossible task. The duet is a thunderous duel teeming with layered characterization, humour and bombastic energy.

The earth-dwellers, however, are far less interesting than their supernatural counterparts. Mary Magdalene ([Meghan Lindsay](/scene/people/meghan-lindsay/)) and Cleophas ([Allyson McHardy](/scene/people/allyson-mchardy/)) spend much of the oratorio moping over Christ’s crucifixion, while St. John the Evangelist ([Colin Ainsworth](/scene/people/colin-ainsworth/)) is a thinly-drawn faithful follower who assures the two women that Christ will rise from the dead.

Lindsay, an Opera Atelier favourite, is perfectly cast as Mary Magdalene. In “Ferma l'ali, e sui miei lumi”, her plaintive voice floats above a gentle cascading accompaniment of strings and oboe. As Cleophas, McHardy has a mellifluous tone and an unfaltering vocal dexterity that makes the numerous coloratura passages in “Vedo il ciel, che più sereno” sound easy. And Ainsworth, reprising his role from the 1999 production, is a joyful St. John the Evangelist, with a silvery voice to match.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1622747230/media/2021/06/OA-TheResurrection-MeganLindsayTylerGledhill-BruceZinger_cyf7rn.jpg){{% /md %}}

<figcaption>Meghan Lindsay (left) and Tyler Gledhill in Handel's The Resurrection, Opera Atelier, 2021. Photo: Bruce Zinger.</figcaption>

</figure>

Under the direction of Elisa Citterio, Tafelmusik’s orchestra brings out the musical shading and lyricism in Handel’s enrapturing score.

Wonderful, too, are the 12 members of the Artists of Atelier Ballet, who play various roles throughout the piece—from an army of angels in heaven to the inhabitants of purgatory. Despite physical distancing measures that require dancers to be at least two metres apart at all times, Zingg’s kinetic choreography is the most original I’ve seen in her recent works.

What a pity, then, that Zingg and Pynkoski’s production couldn’t be showcased on a traditional stage, like that of Koerner Hall—where this production was originally set to premiere in April 2020—or the Elgin Theatre, Opera Atelier’s de facto home. Throughout the 100-minute performance, I couldn’t help but feel that the grand ballroom in St. Lawrence Hall was just the wrong site to stage this work.

The long and narrow space often meant that Marcel Canzona’s cameras were situated at severely acute angles in relation to the performers, sometimes only capturing their profile. And due to the lack of backstage space, actors and dancers had to stand off to the side, in full view of the camera, as they awaited their entrances. Not to mention the ballroom’s gaudy salmon-pink walls, which clashed with the decadent gold and royal blue designs in Gerard Gauci’s set.

But all these are minor nitpicks in an otherwise remarkable film—a magnificent work of immense scale and even greater quality that was borne out of adversity.