+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-12-06T09:09:00+00:00"
lastmod = "2016-12-06T12:01:00+00:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1481020520467/2016-12-6---Tech-Opera.jpg.jpg"
publishDate = "2016-12-06T10:49:00+00:00"
related_articles = ["articles/mustsee-mashups-mozart-vs-machine.md"]
short_description = "The great, classic sci-fi isn&#039;t about aliens or lasers or teleportation; it&#039;s about people and the things we go through in any environment. Similarly, the great, classic operas aren&#039;t about singing for its own sake; they&#039;re about those same people and those same environments."
slug = "opera-and-scifi-the-puritan-intersection"
title = "Opera and sci-fi: the puritan intersection"
+++

Music is a universal storytelling device, and technology is currently at a point where a composer can imagine virtually any sound, and find a way to recreate it. Whenever we go to hear new works - and precisely *because* they're new works - there's often an infusion of technology, or science fiction, or futurism, because those are the kinds of things from which artists now draw inspiration more and more. We've seen operas about meme lovers on a first date, operas about robots, librettos made up of Google search auto-fills; last night, we added to that list a couple of shorts, presented at [Second Movement](https://secondmovement.org.uk/)'s *rough for opera #14*.

It's tough to parse exactly why some tech- and sci-fi-infused opera works feel out of touch. Of course, the same goes for opera about anything; not even all love stories become classics. So, what's the difference between operas about video games and chatting online and the universe, and an episode of *Battlestar Galactica*?

When futuristic opera doesn't work (and granted, this is an opinion), why not? Some reasons, silly as they may be:

<ul class="nospace">

<li>It's weird to sing words like "Skype" and "transmitter" and "username".
<li>Visually, live theatre rarely looks as slick as CGI.
<li>Technology is synonymous with speed, efficiency, and few emotional states.

</ul>

There's a curious overlap in the fan bases of sci-fi and opera. Both groups can be puritans; where *Star Trek* fans pore over details from one episode or series to another, opera fans get off on searching for that perfect marriage of beautiful singing and pointed storytelling. So perhaps we fall into that latter category, our ears hopelessly tuned to the strains of acoustic instruments and themes of humanity.

And maybe our nurtured ideas of what opera "is about" aren't founded in error; like in the opera world, the biggest "hits" of sci-fi film and TV have strong, even central stories about human relationships, aspirations, and insecurities. And just like how opera fans implore the opera-resistant to "give it a try," that their assumptions of being bored and yelled at for 5 hours are unfounded, the sci-fi resistant may need to get over their assumptions that *Battlestar* is nothing but shooting aliens with lasers.

The great, classic sci-fi isn't about aliens or lasers or teleportation; it's about people and the things we go through in any environment. Similarly, the great, classic operas aren't about singing for its own sake; they're about those same people and those same environments.

At *rough for opera #14*, we saw a workshop of *The Two-Sided Boy*, by Freya Ireland and Liz Swift. A teenaged boy is really into gaming, and his mother feels cut off from her son, seemingly unable to have her love for him reciprocated. The piece collects inspiration from video game soundtracks, video projection of live and pre-recorded images, the use of acoustic and synthesized instruments, and the blending of live and pre-recorded singing. What worked was the central story, which was the mother's relationship with her son; what worked less well was the combination of live and electronic elements. The acoustic balance was tricky; we had to strain to hear the words sung by live singers. In a neat scene where the mother desperately tries calling her son on Skype, we see her at her computer, as well as a projected, pre-recorded video of what her son would see on his monitor. The delay that grew between the screen and the singer - as true as it may be for many a Skype user - became distracting.

*CONSTELLATIONS*, by Anna Clock and Lauren Tata, was a soundscape of sorts, one that would be a very cool addition to a tour through a planetarium. Clock created an aural world representative of the universe, and Tata used an overhead projector, acetate, and cardboard to create evocative images of stars and galaxies. The combination resulted in something like a Carl Sagan special + Imogen Heap + Regina Spektor + Foley artists. Clock and Tata found the humanity in the rudimentary scenography; instead of using computer animation, the flawed, even quaint idea of paper on a projector bridged the gap between the stars above and the people below. What we craved was a narrative, yet that's another opinion.

Obvious statement: no matter what the genre of live theatre, it has to be done very, very well. The stories don't have to be earthly, but they have to be organic. With opera in particular, there are firm pillars still in place, no matter where the story unfolds: the text needs to be singable, and the pace of the story needs to work within a musical setting. 

Technology is changing so quickly that shows - on the stage or on TV - can feel dated within one or two years; relying on the novelty of technology alone can keep an opera from becoming part of the canon, the same way that *La traviata* would have faltered if it were simply another tale of a sick sex worker. So, it was encouraging to hear Second Movement's workshop presentations of new operas which live in these worlds that humans are currently exploring, yet which tell stories that are more, well, universal.
