+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2018-06-05T23:45:00-04:00"
lastmod = "2018-06-05T23:45:00-04:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528256399361/sqAriaSemiFinalsII-5.jpg.jpg"
primary_image_credit = "American baritone John Brancy in the Aria Semifinals of the Concours musical international de Montréal, 2018. Photo: Tam Lan Truong Photography."
publishDate = "2018-06-05T23:45:00-04:00"
related_people = ["scene/people/john-brancy.md","scene/people/rihab-chaieb.md","scene/people/andrew-haji.md","scene/people/emily-dangelo.md"]
short_description = "I suppose that&#039;s what happened as the CMIM Aria finalists were announced. I made a few private predictions of my own, and I was largely on the same page as the jury. But I was dismayed to see two singers left out of the final round, perhaps for swinging too far one way or the other."
slug = "onto-the-finals-why-cant-they-all-just-win"
title = "Onto the finals: why can&#039;t they all just win?"
+++

The great thing about voice competitions is that they're an efficient way of getting your fix of no-holds-barred singing from the singers who are serious enough about their craft to do all the hard work it takes to vie for a prize.

The frustrating thing about voice competitions is that they are not the same thing as voice *performances*. 

When 12 great singers compete for 6 spots in the CMIM finals, it can become an exercise in choosing apples or oranges, to make value judgments on who does something better than whom. 

Does a jury value vocal precision, excellent technique, and error-free execution? Or do they give a nod to storytelling, and the art of "leaving it all out on the stage"? 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528256522791/AriaSemiFinalsIII-3.jpg.jpg)
<figcaption>The jury of the Concours musical international de Montréal, 2018. Photo: Tam Lan Truong Photography.</figcaption>
</figure>

Sometimes these options can come at the expense of each other. Precision can take away from heartfelt expression, and singing from one's heart can result in the odd imperfect note.

(Of course, every competitor in this year's CMIM - the ones who sing for glory and a good chunk of prize money - hopes to be a shimmering combination of the two extremes: a performer who can move an audience to tears with his vocal perfection.)

I suppose that's what happened as the CMIM Aria finalists were announced. I made a few private predictions of my own, and I was largely on the same page as the jury. But I was dismayed to see two singers left out of the final round, perhaps for swinging too far one way or the other.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528256448309/AriaSemiFinalsII-4.jpg.jpg)
<figcaption>Tenor Petr Nekoranec in the Aria Semifinals of the Concours musical international de Montréal, 2018. Photo: Tam Lan Truong Photography.</figcaption>
</figure>

Czech tenor Petr Nekoranec, I thought, earned himself a spot in the final 6 with his crystal-clear vocal cut in the Maison symphonique, and his proudly ringing high Cs (and a D for good measure). And Canadian-Tunisian mezzo Rihab Chaieb put everything into her program, which went from the ecstatic exhale of the Composer's Aria from *Ariadne auf Naxos* to the layered scena that is Charlotte's Letter Scene from *Werther*. 

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1528256475105/AriaSemiFinalsIII-1.jpg.jpg)
<figcaption>Mezzo-soprano Rihab Chaieb in the Aria Semifinals of the Concours musical international de Montréal, 2018. Photo: Tam Lan Truong Photography.</figcaption>
</figure>

Maybe the judges thought Nekoranec delivered perfect singing without enough soul; and maybe they found Chaieb's stunning storytelling to come with a side of human imperfection.

In both cases, it was a shame to see their names left out of the 6 singers set to sing their final aria rounds this Thursday.

Still, there's good news: the finalists are all excellent singers. South Korean tenor **Mario Bahg** caught my attention in this round with a sweeping sound used well in his mix of verismo and bel canto. Russian bass **Mikhail Golovushkin** is, as I said in the preliminary rounds, the real deal. South Korean tenor **Konstantin Lee** sang an impressive arc from Donizetti to Puccini to Massenet. American baritone - and a crowd favourite, to be sure - **John Brancy** sang a Billy Budd to make you heavy in your seat. And Canadians **Emily D'Angelo** and **Andrew Haji** keep up Canada's reputation for producing really, really good singers.

Tune in to the final round this **Thursday, June 7, 7:30pm ET** via the [CMIM's live webcast](https://concoursmontreal.ca/en/live/). And if you missed part II of the semifinal round, catch up below:

<figure data-type="video">
<iframe width="854" height="480" src="https://www.youtube.com/embed/
gCOPWbzu04o" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe>
</figure>
