+++
author = ["authors/jenna.md"]
categories = "Editorial"
date = "2016-05-17T17:29:00+01:00"
lastmod = "2016-05-19T13:39:00+01:00"
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1463579542502/2016-05-19---Netrebko-by-Ruven-Afanador.jpg.jpg"
primary_image_credit = "Anna Netrebko. Photo: Ruven Afanador."
publishDate = "2016-05-18T23:34:00+01:00"
related_articles = ["articles/in-defence-of-singers.md","articles/psychology-audition.md","articles/how-was-it-and-other-dangerous-questions.md","articles/when-singers-call-in-sick.md","articles/reason-947-we-dont-envy-singers-singing-on-camera.md"]
related_companies = ["scene/companies/royal-opera-house.md","scene/companies/the-metropolitan-opera.md"]
related_people = ["scene/people/anna-netrebko.md","scene/people/cecilia-bartoli.md","scene/people/sondra-radvanovsky.md"]
short_description = "The story of Bartoli&#039;s Bernstein, plus Netrebko&#039;s evaded Norma, combine in an example of one big plight of opera singers today: they&#039;re damned if they do, and they&#039;re damned if they don&#039;t. Bartoli did; she took a role that seemed an odd choice, and plenty of unfavourable reviews of McKinley&#039;s West Side Story seemed to have an undercurrent of &quot;I told you so&quot;. She should have shown more self-awareness, more respect for the demands of Bernstein&#039;s score, right?"
slug = "one-more-reason-we-dont-envy-singers"
title = "One more reason we don&#039;t envy singers"
+++

You've likely heard about [Anna Netrebko](/scene/people/anna-netrebko/)'s decision to withdraw from the title role in *Norma* at both the Royal Opera House and the Metropolitan Opera next season. The Met has since secured the more-than-capable [Sondra Radvanovsky](/scene/people/sondra-radvanovsky/) to replace her, and Sonya Yoncheva will sing the role at Covent Garden.

ROH's Kaspar Holten said in a statement, "We are, of course, very frustrated that Anna has felt it necessary to cancel a major role debut with us for the second time." The first of Netrebko's cancellations was for the role of Marguerite in Gounod's *Faust* in 2014. Netrebko said the change was something she "could not have anticipated," and that "I have come to the unfortunate conclusion my voice has evolved in a different direction."

Also in the news are the varied reviews for [Cecilia Bartoli](/scene/people/cecilia-bartoli/)'s performance of Maria in the Salzburg Whitsun Festival's production of *West Side Story*. Bartoli shared the role, sort of, with Michelle Veintimilla, in Philip Wm. McKinley's production; the idea was based on a concept that ponders the question of what happens to Maria after Tony dies. Apparently Bartoli did all the singing, but spoke none of the dialogue. It sure seems like an odd thing to have witnessed. 

But directional choices aside, when it was announced that Bartoli would sing Maria, people were skeptical, [us included](/i-just-met-a-girl-named-cecilia/). Opera puritans can get snitty about things, sure; but this confusion was founded in a bit more fact than speculation. Bartoli made her career on Vivaldi, Mozart, Rossini, and more obscure 17th- and 18th-century Italian repertoire, and she sings the hell out of it. Like her or not, you could take dictation from her coloratura, and she's an expert on making every single note mean something. Her singing of Bellini's Norma drew mixed reviews; it seemed to be a battle of taste, and Bartoli armed herself against our contemporary understanding of *Norma* and the recordings of Joan Sutherland and Maria Callas in our ears, with extensive research into Bellini's autograph score and the performing practices at the time of its composition.

Those tools aren't helpful when it comes to Bernstein. Bartoli's age and vocal colour worked against a convincing Maria, it seems; the decision for her not to speak the show's dialogue may not have been Bartoli's, but it's unlikely she didn't have a hand in the choice, since she's the Artistic Director of the Whitsun Festival. Possible ego trips and unwise casting aside, Bartoli's Maria falls, like every other casting controversy, on the wide spectrum of personal taste.

The story of Bartoli's Bernstein, plus Netrebko's evaded Norma, combine in an example of one big plight of opera singers today: they're damned if they do, and they're damned if they don't. Bartoli did; she took a role that seemed an odd choice, and even went as far as to leave out the dialogue, which is part of that role. Plenty of unfavourable reviews of McKinley's *West Side Story* seemed to have an undercurrent of "I told you so". She should have shown more self-awareness, more respect for the demands of Bernstein's score, right?

But what about Anna Netrebko? Though it's likely that the story runs deeper than the star soprano's vocal evolution, which she says veered away from feeling comfortable as a Norma, Netrebko did show the self-awareness that people craved from Bartoli. In this case, being self-aware may indeed mean, "I thought I could sing Norma but it turns out I can't." No doubt, Netrebko is well aware of what critics may say if she were to dig in her heels and make a go of a hefty role like this one. It would be those same permutations on "I told you so" that Bartoli's Maria earned.

It's another case where singers seem to be damned if they do, and damned if they don't. For someone like Netrebko, opera houses have to plan seasons ahead to secure her; that's wise on the planning end of things, but it conflicts with the fact that voices change. On the other hand, someone like Bartoli took on a role in part because it went with the Whitsun Festival's "Romeo and Juliet" theme, and probably in part because she just wanted to sing it. This kind of decision, fuelled by a passion for the music and the role, is really admirable, and it's a sign of an artist who has achieved success in her career. Not all singers find themselves with the freedom to pick and choose.

Who knows if Bartoli wanted to sing Maria in the kind of production that McKinley directed? And who knows if Netrebko's eyes were bigger than her stomach, something she only realized after suffering the early stages of Norma-induced indigestion? And neither story would be as interesting if star singers weren't involved. But it's a great picture of what it means for an artist to be in charge of her career. Young artists are advised to start doing this as soon as possible; the apparently endless list of caveats that come with this advice is one of the many reasons that we really, *really* don't envy opera singers.
