+++
author = ["authors/jenna.md"]
categories = "Interview"
date = "2015-07-28T14:08:00-04:00"
lastmod = "2015-08-01T11:48:00-04:00"
preamble = "[The Bicycle Opera Project](/scene/companies/the-bicycle-opera-project/) has never been busier. Currently, the group of cycling singers are finishing up a month-long run of [Dean Burry](/scene/people/dean-burry/)'s new opera, *The Bells of Baddeck*, and on Monday they begin their East Coast tour (August 3-11 in Nova Scotia, August 14-September 6 in Ontario, all by bike!) of *shadow box*, a tight collection of Canadian scenes and by people like [James Rolfe](/james-rolfe-anna-chatterton-on-creating-crush/), [Chris Thornborrow](http://www.schmopera.com/chris-thornborrow-on-composing-with-kids/), and Tobin Stokes. I had a chance to hear a preview of *shadow box* this spring, and I'm so thrilled for the artistic quality of this production.\n\n*The Bells of Baddeck* tells the story of Alexander Graham Bell, and it's not the one you think you know. I spoke with soprano and Artistic Director [Larissa Koniuk](/scene/people/larissa-koniuk/), BOP singers [Stephanie Tritchew](/scene/people/stephanie-tritchew/) and [Christopher Enns](/scene/people/christopher-enns/), and *Baddeck* librettist, Lorna MacDonald, about what sounds like a summer of operatic proportions.\n\n*shadow box* tours August 3-September 6. For details and tickets, follow the box office links below."
primary_image = "https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438127214502/Training-ride.jpg.jpg"
primary_image_credit = "Soprano Stephanie Tritchew on a Bicycle Opera Project training ride. Photo: Geoffrey Sirett."
publishDate = "2015-08-01T11:48:00-04:00"
related_articles = ["articles/the-bicycle-opera-project-at-21c.md","articles/in-review-shadow-box.md","articles/on-the-road-jmc-romeo-juliette.md","articles/great-ideas-portland-opera-a-la-cart.md"]
related_companies = ["scene/companies/the-bicycle-opera-project.md","scene/companies/indie-opera-to.md"]
related_people = ["scene/people/larissa-koniuk.md","scene/people/geoffrey-sirett.md","scene/people/christopher-enns.md","scene/people/stephanie-tritchew.md","scene/people/liza-balkan.md","scene/people/giles-tomkins.md","scene/people/chris-thornborrow.md","scene/people/james-rolfe.md","scene/people/michael-christie.md"]
short_description = "The Bicycle Opera Project has never been busier. Currently, the group of cycling singers are finishing up a month-long run of Dean Burry&#039;s new opera, The Bells of Baddeck, and on Monday they begin their East Coast tour (August 3-11 in Nova Scotia, August 14-September 6 in Ontario, all by bike!) of shadow box, a tight collection of Canadian scenes and by people like James Rolfe, Chris Thornborrow, and Tobin Stokes."
slug = "on-the-road-the-bicycle-opera-project"
title = "On the road: the Bicycle Opera Project"
+++

### 1. Can you give us an idea of what *The Bells of Baddeck* is about?

**Larissa Koniuk**: We all know Alexander Graham Bell as the inventor of the telephone, but his legacy, and that of his wife Mabel, extends so far beyond the telephone it’s hard to know where to begin! Mabel was deaf from early childhood, but she was an incredibly strong woman and was undisputed as Bell’s greatest influence. Alexander Graham Bell, like his father, was a teacher of oral communication for the deaf, and contributed to a vast number of areas of scientific research including aeronautics, genetics, and early fibre-optics.

AGB and Mabel traveled to Baddeck, Nova Scotia and soon fell in love with its landscape and Gaelic charm, establishing their estate, Beinn Bhreagh, atop a red mountain on the scenic Bras d’Or Lake. Mabel and AGB had a beautiful relationship and would walk everyday together at 5pm before dinner, holding hands so that AGB could tell Mabel about stories from the day with their unique hand spelling system.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438127445131/At-the-top-of-Beinn-Bhreagh-with-the-great-grandchildren.jpg.jpg)
<figcaption>At the top of Beinn Bhreagh with the Bell great grandchildren. L-r: Mimi Mekler, Stephanie Higgins, Gardiner Fairchild, Hugh Muler. Photo: Larissa Koniuk</figcaption>
</figure>

*The Bells of Baddeck* tells the story of both Mabel’s and AGB’s early lives, meeting at the Clarke School for the Deaf, and then finding their new home in Baddeck, Cape Breton where AGB worked on later experiments including flight.

**Lorna MacDonald**: Many people are unaware of the strength of Mabel’s resolve and her status as a very equal partner in their relationship. The fact that Mabel could lip-read in several languages as a young girl is quite astounding and speaks to her upbringing and her intelligence. She read and explained the Helmholtz overtone series to Alec after he had come up with his own interpretation of it!

Also, Alec was a fine pianist and in his early life he aspired to be both a professional pianist as well as a teacher of speech and elocution, as was his father before him. The fact that his mother was deaf led to the family work in teaching the deaf. Bell’s love for music and the repose he found in both music and in his life in Cape Breton is front and centre. His musical life affected his understanding of sound transmission and harmonics as well as his emotional and cultural well-being.

Finally, the love story of Alec and Mabel is inspiring and the intertwining of their love for one another with their generosity to the airmen who ultimately flew the Silver Dart is very much at the heart of *The Bells of Baddeck*.

## 2. What’s it like bringing an opera to audiences that understand its context?

**Lorna**: First of all, it felt risky...this is Cape Breton’s first opera, and although it is definitely a hybrid with dialogue and a variety of musical styles, artistic values were my highest priority. The quality of singing and music making trumped everything else for me, and this meant that the space had to be refigured for acoustic quality. 

That Parks Canada contributed a major acoustic re-fit was support of the highest order, and I am tremendously grateful. Baddeck now has a fully functional acoustic performance space. Secondly, why not in Cape Breton? Why not someone from Port Morien? Why not combine my musical life in Toronto with my roots in Cape Breton? My commute is crossing the Bras d’or Lakes and the moody mountains surrounding them — what means most to me is that beauty of all types have coalesced here this summer — beauty of the story, of music, of friendships, of relationships with young artists and children, of family, of the Island, of generosity toward me and the cast.

**Larissa**: We had an incredibly special first day on this production. Lorna arranged for a tour of the Bell’s estate by the actual Bell great grandchildren. I play Daisy, AGB and Mabel’s daughter and when I met Hugh, one of our great-grandchildren guides, he stretched out his arms, teary eyed, and exclaimed, "Grandma!"

Followed by, "You’re looking well."

The tour was incredible and the "Big House" was better than a museum. It was one of those days that you’ll always remember. And knowing that context, that members of the Bell family were present in the opening night audience made us sink in to this project in a deeper way and want to learn our historically accurate lines all the more...well, accurately.

If you’re interested, you can read more about our visit to Beinn Bhreagh [here](bicycleopera.com/bells-of-baddeck-opens-in-baddeck/).

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438127744951/In-front-of-the-Big-House-at-Beinn-Bhreagh.jpg.jpg)<figcaption>Larissa Koniuk and Stephanie Tritchew in front of the Big House at Beinn Bhreagh. Photo: Geoffrey Sirett.</figcaption>
</figure>

**Chris Enns**: Introducing myself to one of Bell’s great-grandsons, I told him I was playing Lieutenant Thomas Selfridge (one of the airmen that helped Mr. Bell with his experiments) and instantly his eyes turned glassy.

"He was Mrs. Bell’s favourite."

In opera we spend most of our time telling fictional stories, or if they were once based in history, so much time has passed it’s easy to disconnect, to treat them as "less than real". It’s a different kind of play, a different kind of creation when your character is a demigod vs someone’s grandfather.

And it’s even more than just the people, it’s the place itself. There’s an intangible when you’re surrounded with a set steeped in history, you can’t help but react to it. It changes you. Being here... in Baddeck to sing the story of the Bell family, is far different than it would be if we were singing it in Toronto.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438127838071/Opening-night-reception-with-Dean-Burry.jpg.jpg)<figcaption>L-r: Stephanie Tritchew, Larissa Koniuk, Giles Tomkins, Erika Nielsen, Chris Enns, Dean Burry, Lauren Klein, at the opening night reception for *The Bells of Baddeck*. Photo: Geoffrey Sirett.</figcaption>
</figure>

### 3. How has it been to collaborate with Dean Burry?

**Larissa**: I think it’s clear at this point that we are fans of Dean’s. We did an excerpt of his *Brother’s Grimm* last tour, and this year our touring production, shadow box features both an excerpt from *The Bells of Baddeck*, and a short opera, *Submission*, created at Tapestry Opera’s Composer-Librettist Laboratory.

Dean is great because he creates music that is simultaneously interesting and beautiful, but he also has a knack for writing just on the edge of “new” and what is still accessible and rewarding for both veteran and new audiences to opera. Being from the East Coast he evokes the love of this beautiful place, especially in the scene that we are touring for *shadow box*.

He has created some truly beautiful music for *The Bells of Baddeck*. Mabel’s aria slays me every time.

**Stephanie Tritchew**: *The Bells of Baddeck* has been a whole different experience because it's a brand new piece. In the audition, Dean asked us our comfortable singing ranges, etc., so he could compose the music for our voices. How cool is that? The music is beautiful and influenced by the music of the East coast which makes it super accessible to the audiences out here and Dean has given us the perfect music to tell the Bell family's story.

### 4. What kind of feedback have you received so far?

**Chris**: The feedback has been overwhelming. The community has been so supportive! It’s so fun to be in a place that doesn’t get much classical music exposure, but has an incredible arts scene. The musical talent in Cape Breton is ridiculous, and being able to add our operatic slant on it has been fun. They teach us fiddle tunes, we teach them how to ... um... sing really loud? Mainly we learn sweet fiddle tunes.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438128112207/The-kids-loving-their-lollipop-bouquets-from-BOP.jpg.jpg)<figcaption>Kids from the *Bells* cast enjoy their lollipop bouquets. Photo: Geoffrey Sirett.</figcaption>
</figure>

We’ve also had a lot of feedback on the story itself. It means so much to this community, but more than just Baddeck, or Cape Breton. I met a woman in line for my morning coffee yesterday from the Clarke School in Philadelphia. The Clarke School is a school that Alexander Graham Bell taught at, and Mabel attended (it’s actually where they met) and still exists today. She was so excited that we had told that part of the story and told me how much amazing work the Clarke school is still doing today.

**Larissa**: We’ve had an amazing turn out for this run. The audiences are lovely and we’ve heard over and over from local residents that they can’t believe this show is right here in Baddeck. The Bell museum staff have been incredibly supportive and the local Baddeck residents have embraced this show and us, the cast, with warm arms (just like Hugh). We couldn’t ask for more.

### 5. What is it like living in Cape Breton for seven weeks?

**Larissa**: We live in the beautiful wilderness outside of Baddeck and every day we cycle a short 5 kilometers into Baddeck alongside the Bras d’Or. We pass rocky shores complete with starfish, see herons take flight, and sailboats blow around Baddeck Bay in front of the Cape Breton red cliffs. When we pass the lighthouse we’re close, and then we spend the day in the cute town rehearsing for shadow box, with Bells of Baddeck shows in the evenings four times a week. We’ve been living with amazing colleagues in a big cottage by the lake and sharing meals together.

<figure data-type="image">{{% md %}}![](https://res.cloudinary.com/schmopera/image/upload/v1545409169/media/webhook-uploads/1438128218398/Hike-at-Uisge-Bahn-Falls.jpg.jpg)<figcaption>l-r: Stephanie Tritchew, Giles Tomkins, Larissa Koniuk, Geoffrey Sirett, and Erika Nielsen, enjoying a hike to Uisge Bahn falls. Photo: Geoff's camera's self-timer.</figcaption>
</figure>

We’ve gone on one major training ride so far (yikes, we should get out on some more training rides!) to a beautiful hike to Uisge Bahn falls. And perhaps my favourite experience so far has been attending an authentic Cape Breton square dance at a nearby town with top-notch fiddlers and charming local people who didn’t mind giving us a shove in the right direction. At the close out of *Bells of Baddeck*, we open our own show, *shadow box* and tour it to Nova Scotia audiences August 3rd through 11th, before returning home to Ontario to tour for three more weeks!

￼Wish us luck for the hilly terrain!
